/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.miscellaneous;

import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.mixin.mixins.common.accessor.BaseSpawnerAccessor;
import com.google.common.collect.Iterables;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class MoaEggItem
extends class_1792 {
    private static final Map<class_5321<MoaType>, MoaEggItem> BY_ID = new IdentityHashMap<class_5321<MoaType>, MoaEggItem>();
    private final class_5321<MoaType> moaType;
    private final int color;

    public MoaEggItem(class_5321<MoaType> moaType, int shellColor, class_1792.class_1793 properties) {
        super(properties);
        this.moaType = moaType;
        this.color = shellColor;
        BY_ID.put(moaType, this);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 itemStack = context.method_8041();
        class_1657 player = context.method_8036();
        if (player != null && player.method_7337()) {
            class_2586 blockEntity;
            class_1937 level = context.method_8045();
            if (!(level instanceof class_3218)) {
                return class_1269.field_5812;
            }
            class_3218 serverLevel = (class_3218)level;
            class_2338 blockPos = context.method_8037();
            class_2350 direction = context.method_8038();
            class_2680 blockState = level.method_8320(blockPos);
            if (blockState.method_27852(class_2246.field_10260) && (blockEntity = level.method_8321(blockPos)) instanceof class_2636) {
                class_2636 spawnerBlockEntity = (class_2636)blockEntity;
                BaseSpawnerAccessor baseSpawnerAccessor = (BaseSpawnerAccessor)spawnerBlockEntity.method_11390();
                class_1299<Moa> entityType = AetherEntityTypes.MOA.get();
                spawnerBlockEntity.method_46408(entityType, level.method_8409());
                baseSpawnerAccessor.aether$getNextSpawnData().method_38093().method_10582("MoaType", this.getMoaType().method_29177().toString());
                baseSpawnerAccessor.aether$getNextSpawnData().method_38093().method_10556("PlayerGrown", true);
                blockEntity.method_5431();
                level.method_8413(blockPos, blockState, blockState, 3);
                itemStack.method_7934(1);
                return class_1269.field_21466;
            }
            class_2338 relativePos = blockState.method_26220((class_1922)level, blockPos).method_1110() ? blockPos : blockPos.method_10093(direction);
            if (AetherEntityTypes.MOA.get().method_5899(serverLevel, this.getStackWithTags(serverLevel, itemStack, player, false, this.getMoaType(), false, true), relativePos, class_3730.field_16465, true, !Objects.equals(blockPos, relativePos) && direction == class_2350.field_11036) != null) {
                level.method_33596((class_1297)player, (class_6880)class_5712.field_28738, blockPos);
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5814;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 heldStack = player.method_5998(hand);
        if (player.method_7337()) {
            class_3965 hitResult = MoaEggItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
            if (hitResult.method_17783() != class_239.class_240.field_1332) {
                return class_1271.method_22430((Object)heldStack);
            }
            if (!(level instanceof class_3218)) {
                return class_1271.method_22431((Object)heldStack);
            }
            class_3218 serverLevel = (class_3218)level;
            class_2338 blockpos = hitResult.method_17777();
            if (!(level.method_8320(blockpos).method_26204() instanceof class_2404)) {
                return class_1271.method_22430((Object)heldStack);
            }
            if (level.method_8505(player, blockpos) && player.method_7343(blockpos, hitResult.method_17780(), heldStack)) {
                if (AetherEntityTypes.MOA.get().method_5899(serverLevel, this.getStackWithTags(serverLevel, heldStack, player, false, this.getMoaType(), false, true), blockpos, class_3730.field_16465, false, false) == null) {
                    return class_1271.method_22430((Object)heldStack);
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
                level.method_33596((class_1297)player, (class_6880)class_5712.field_28738, blockpos);
                return class_1271.method_22428((Object)heldStack);
            }
            return class_1271.method_22431((Object)heldStack);
        }
        return class_1271.method_22431((Object)heldStack);
    }

    public Consumer<Moa> getStackWithTags(class_3218 serverLevel, class_1799 stack, class_1657 player, boolean isBaby, class_5321<MoaType> moaType, boolean isHungry, boolean isPlayerGrown) {
        class_1799 itemStack = stack.method_7972();
        return class_1299.method_48156(consumerEntity -> {
            consumerEntity.method_7217(isBaby);
            consumerEntity.setMoaTypeByKey(moaType);
            consumerEntity.setHungry(isHungry);
            consumerEntity.setPlayerGrown(isPlayerGrown);
        }, (class_3218)serverLevel, (class_1799)itemStack, (class_1657)player);
    }

    @Environment(value=EnvType.CLIENT)
    public int getColor() {
        return this.color;
    }

    public class_5321<MoaType> getMoaType() {
        return this.moaType;
    }

    @Nullable
    public static MoaEggItem byId(class_5321<MoaType> moaType) {
        if (moaType != null) {
            for (class_5321<MoaType> key : BY_ID.keySet()) {
                if (!moaType.equals(key)) continue;
                return BY_ID.get(key);
            }
        }
        return null;
    }

    public static Iterable<MoaEggItem> moaEggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }
}

