/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.attachment.AetherTimeAttachment;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.ai.controller.BlankMoveControl;
import com.aetherteam.aether.entity.monster.dungeon.FireMinion;
import com.aetherteam.aether.entity.monster.dungeon.boss.BossNameGenerator;
import com.aetherteam.aether.entity.projectile.crystal.AbstractCrystal;
import com.aetherteam.aether.entity.projectile.crystal.FireCrystal;
import com.aetherteam.aether.entity.projectile.crystal.IceCrystal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.mixin.mixins.common.accessor.LookAtPlayerGoalAccessor;
import com.aetherteam.aether.network.packet.clientbound.BossInfoPacket;
import com.aetherteam.aetherfabric.entity.IEntityWithComplexSpawn;
import com.aetherteam.aetherfabric.network.PacketDistributor;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5195;
import net.minecraft.class_5425;
import net.minecraft.class_7225;
import net.minecraft.class_8103;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class SunSpirit
extends class_1314
implements AetherBossMob<SunSpirit>,
class_1569,
IEntityWithComplexSpawn {
    private static final double DEFAULT_SPEED_MODIFIER = 1.0;
    private static final double FROZEN_SPEED_MODIFIER = 0.3;
    private static final float INCINERATION_DAMAGE = 10.0f;
    private static final int INCINERATION_FIRE_DURATION = 8;
    private static final int SUN_SPIRIT_FROZEN_DURATION = 175;
    private static final int ICE_CRYSTAL_SHOOT_COUNT_INTERVAL = 5;
    private static final int SHOOT_CRYSTAL_INTERVAL = 50;
    private static final int SPAWN_FIRE_INTERVAL = 35;
    private static final class_2940<Boolean> DATA_IS_FROZEN = class_2945.method_12791(SunSpirit.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_FROZEN_DURATION = class_2945.method_12791(SunSpirit.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2561> DATA_BOSS_NAME = class_2945.method_12791(SunSpirit.class, (class_2941)class_2943.field_13317);
    private static final class_2940<Boolean> DATA_DISPLAY_WEAK_MESSAGE = class_2945.method_12791(SunSpirit.class, (class_2941)class_2943.field_13323);
    private static final class_5195 SUN_SPIRIT_MUSIC = new class_5195(AetherSoundEvents.MUSIC_BOSS_SUN_SPIRIT, 0, 0, true);
    public static final Map<class_2248, Function<class_2680, class_2680>> DUNGEON_BLOCK_CONVERSIONS = new HashMap<class_2248, Function<class_2680, class_2680>>(Map.ofEntries(Map.entry((class_2248)AetherBlocks.LOCKED_HELLFIRE_STONE.get(), blockState -> ((class_2248)AetherBlocks.HELLFIRE_STONE.get()).method_9564()), Map.entry((class_2248)AetherBlocks.LOCKED_LIGHT_HELLFIRE_STONE.get(), blockState -> ((class_2248)AetherBlocks.LIGHT_HELLFIRE_STONE.get()).method_9564()), Map.entry((class_2248)AetherBlocks.BOSS_DOORWAY_HELLFIRE_STONE.get(), blockState -> class_2246.field_10124.method_9564()), Map.entry((class_2248)AetherBlocks.TREASURE_DOORWAY_HELLFIRE_STONE.get(), blockState -> class_2246.field_10124.method_9564())));
    private final class_3213 bossFight;
    @Nullable
    private BossRoomTracker<SunSpirit> dungeon;
    private class_243 origin;
    private int xMax = 9;
    private int zMax = 9;
    private int chatLine;
    private int chatCooldown;
    protected double speedModifier;

    public SunSpirit(class_1299<? extends SunSpirit> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new BlankMoveControl((class_1308)this);
        this.bossFight = (class_3213)new class_3213(this.getBossName(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795).method_5410(true);
        this.setBossFight(false);
        this.origin = this.method_19538();
        this.field_6194 = 50;
        this.method_5875(true);
        this.speedModifier = 1.0;
        this.method_5971();
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData) {
        this.setBossName((class_2561)BossNameGenerator.generateSunSpiritName(this.method_59922()));
        this.origin = this.method_19538();
        return spawnData;
    }

    public void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new DoNothingGoal(this));
        this.field_6201.method_6277(1, (class_1352)new SunSpiritLookGoal((class_1308)this, class_1657.class, 40.0f, 1.0f));
        this.field_6201.method_6277(2, (class_1352)new ShootFireballGoal(this));
        this.field_6201.method_6277(3, (class_1352)new SummonFireGoal(this));
        this.field_6201.method_6277(4, (class_1352)new FlyAroundGoal(this));
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 500.0).method_26868(class_5134.field_23719, 0.35);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_IS_FROZEN, (Object)false);
        builder.method_56912(DATA_FROZEN_DURATION, (Object)0);
        builder.method_56912(DATA_BOSS_NAME, (Object)class_2561.method_43470((String)"Sun Spirit"));
        builder.method_56912(DATA_DISPLAY_WEAK_MESSAGE, (Object)true);
    }

    public void method_5773() {
        super.method_5773();
        this.breakBlocks();
        this.evaporate();
        if (this.getChatCooldown() > 0) {
            --this.chatCooldown;
        }
        if (this.method_6032() > 0.0f && !this.isFrozen()) {
            double x = this.method_23317() + (double)((this.method_59922().method_43057() - 0.5f) * this.method_59922().method_43057());
            double y = this.method_5829().field_1322 + (double)this.method_59922().method_43057() - 0.5;
            double z = this.method_23321() + (double)((this.method_59922().method_43057() - 0.5f) * this.method_59922().method_43057());
            this.method_37908().method_8406((class_2394)class_2398.field_11240, x, y, z, 0.0, -0.075, 0.0);
            this.burnEntities();
        }
        this.method_36456(class_3532.method_20306((float)this.method_36454(), (float)this.method_5791(), (float)20.0f));
        this.speedModifier = this.isFrozen() ? 0.3 : 1.0;
    }

    private void breakBlocks() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                class_2338.method_29715((class_238)this.method_5829().method_1009(1.0, 0.0, 1.0)).forEach(pos -> {
                    class_2680 state = this.method_37908().method_8320(pos);
                    if (this.isBreakable(state) && (state.method_26218((class_1922)this.method_37908(), pos).equals(class_259.method_1077()) || !state.method_26220((class_1922)this.method_37908(), pos).method_1110()) && (this.getDungeon() == null || this.getDungeon().roomBounds().method_1006(pos.method_46558()))) {
                        this.method_37908().method_8651(pos, true, (class_1297)this);
                        serverLevel.method_14199((class_2394)class_2398.field_11240, pos.method_46558().method_10216(), pos.method_46558().method_10214(), pos.method_46558().method_10215(), 5, this.field_5974.method_43058() / 2.0 - this.field_5974.method_43058(), this.field_5974.method_43058() / 2.0 - this.field_5974.method_43058(), this.field_5974.method_43058() / 2.0 - this.field_5974.method_43058(), 0.1);
                    }
                });
            }
        }
    }

    private boolean isBreakable(class_2680 blockState) {
        return !blockState.method_26215() && !blockState.method_26164(AetherTags.Blocks.SUN_SPIRIT_UNBREAKABLE) && blockState.method_26204().method_36555() >= 0.0f && blockState.method_26204().method_36555() < 100.0f;
    }

    private void evaporate() {
        class_238 boundingBox = this.method_5829();
        class_2338 min = class_2338.method_49637((double)(boundingBox.field_1323 - (double)this.xMax), (double)(boundingBox.field_1322 - 3.0), (double)(boundingBox.field_1321 - (double)this.zMax));
        class_2338 max = class_2338.method_49637((double)(Math.ceil(boundingBox.field_1320 - 1.0) + (double)this.xMax), (double)(Math.ceil(boundingBox.field_1325 - 1.0) + 4.0), (double)(Math.ceil(boundingBox.field_1324 - 1.0) + (double)this.zMax));
        AetherBossMob.super.evaporate(this, min, max, blockState -> true);
    }

    public void burnEntities() {
        List entities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1012(0.0, -2.0, 0.0).method_1002(-0.75, 0.0, -0.75).method_1002(0.75, 0.0, 0.75));
        for (class_1297 target : entities) {
            if (!(target instanceof class_1309)) continue;
            target.method_5643(AetherDamageTypes.entityDamageSource(this.method_37908(), AetherDamageTypes.INCINERATION, (class_1297)this), 10.0f);
            target.method_5639(8.0f);
        }
    }

    public void method_5958() {
        super.method_5958();
        this.bossFight.method_5408(this.method_6032() / this.method_6063());
        this.trackDungeon();
        this.checkIceCrystals();
        if (this.getFrozenDuration() > 0) {
            this.setFrozenDuration(this.getFrozenDuration() - 1);
        } else {
            this.setFrozen(false);
        }
    }

    private void checkIceCrystals() {
        for (IceCrystal iceCrystal : this.method_37908().method_18467(IceCrystal.class, this.method_5829().method_1014(0.1))) {
            iceCrystal.doDamage((class_1297)this);
        }
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_37908().method_8608() && !this.isBossFight() && this.getChatCooldown() <= 0) {
            this.setChatCooldown(14);
            if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((class_1297)player)) {
                if (this.method_37908().method_8407() != class_1267.field_5801) {
                    if (!((Boolean)AetherConfig.COMMON.repeat_sun_spirit_dialogue.get()).booleanValue() && ((AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER)).hasSeenSunSpiritDialogue() && this.chatLine == 0) {
                        this.chatLine = 10;
                    }
                    if (this.chatLine < 9) {
                        this.method_5783(this.getInteractSound(), 1.0f, this.method_6017());
                    }
                    switch (this.chatLine++) {
                        case 0: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line0").method_27692(class_124.field_1061));
                            break;
                        }
                        case 1: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line1").method_27692(class_124.field_1061));
                            break;
                        }
                        case 2: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line2").method_27692(class_124.field_1061));
                            break;
                        }
                        case 3: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line3").method_27692(class_124.field_1061));
                            break;
                        }
                        case 4: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line4").method_27692(class_124.field_1061));
                            break;
                        }
                        case 5: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line5.1").method_27692(class_124.field_1061));
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line5.2").method_27692(class_124.field_1061));
                            break;
                        }
                        case 6: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line6.1").method_27692(class_124.field_1061));
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line6.2").method_27692(class_124.field_1061));
                            break;
                        }
                        case 7: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line7.1").method_27692(class_124.field_1061));
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line7.2").method_27692(class_124.field_1061));
                            break;
                        }
                        case 8: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line8").method_27692(class_124.field_1061));
                            break;
                        }
                        case 9: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line9").method_27692(class_124.field_1065));
                            this.method_6033(this.method_6063());
                            this.setBossFight(true);
                            if (this.getDungeon() != null) {
                                this.closeRoom();
                            }
                            this.method_5783(this.getActivateSound(), 1.0f, this.method_6017());
                            AetherEventDispatch.onBossFightStart((class_1297)this, this.getDungeon());
                            ((AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER)).setSeenSunSpiritDialogue(true);
                            break;
                        }
                        default: {
                            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line10").method_27692(class_124.field_1061));
                            this.chatLine = 9;
                            break;
                        }
                    }
                } else {
                    this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.line1").method_27692(class_124.field_1061));
                }
            } else {
                this.displayTooFarMessage(player);
            }
        }
        return super.method_5992(player, hand);
    }

    protected void chatWithNearby(class_2561 message) {
        class_238 room = this.getDungeon() == null ? this.method_5829().method_1014(16.0) : this.getDungeon().roomBounds();
        this.method_37908().method_18464(NON_COMBAT, (class_1309)this, room).forEach(player -> player.method_43496(message));
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972;
        boolean flag = super.method_5643(source, amount);
        if (!this.method_37908().method_8608() && flag && this.method_6032() > 0.0f && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            if (source.method_5526() instanceof IceCrystal) {
                if (this.getDisplayWeakMessage()) {
                    this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.message.attack.weakened"));
                    this.setDisplayWeakMessage(false);
                }
                this.setFrozen(true);
                this.setFrozenDuration(175);
                FireMinion minion = new FireMinion(AetherEntityTypes.FIRE_MINION.get(), this.method_37908());
                minion.method_33574(this.method_19538());
                minion.method_5980(entity);
                this.method_37908().method_8649((class_1297)minion);
            }
        }
        return flag;
    }

    public void reset() {
        this.setBossFight(false);
        this.method_5980(null);
        if (this.dungeon != null) {
            this.openRoom();
        }
        AetherEventDispatch.onBossFightStop((class_1297)this, this.getDungeon());
    }

    public void method_6078(class_1282 source) {
        if (!this.method_37908().method_8608()) {
            this.setFrozen(true);
            this.bossFight.method_5408(this.method_6032() / this.method_6063());
            this.chatWithNearby((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.dead").method_27692(class_124.field_1075));
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(source);
                this.tearDownRoom();
            }
            if (this.method_37908().hasAttached(AetherDataAttachments.AETHER_TIME)) {
                AetherTimeAttachment data = (AetherTimeAttachment)this.method_37908().getAttached(AetherDataAttachments.AETHER_TIME);
                data.setEternalDay(false);
                data.updateEternalDay(this.method_37908());
                if (((Boolean)AetherConfig.SERVER.sync_aether_time.get()).booleanValue()) {
                    data.setSynched(-1, INBTSynchable.Direction.DIMENSION, "setShouldWait", true, this.method_37908());
                }
            }
        }
        super.method_6078(source);
    }

    public void method_6005(double strength, double x, double z) {
    }

    public void method_5762(double x, double y, double z) {
    }

    public boolean method_6049(class_1293 pEffectInstance) {
        return false;
    }

    public void method_5982() {
    }

    @Nullable
    public class_2680 convertBlock(class_2680 state) {
        return DUNGEON_BLOCK_CONVERSIONS.getOrDefault(state.method_26204(), blockState -> null).apply(state);
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        PacketDistributor.sendToPlayer(player, new BossInfoPacket.Display(this.bossFight.method_5407(), this.method_5628()), new class_8710[0]);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((class_1657)player)) {
            this.bossFight.method_14088(player);
            AetherEventDispatch.onBossFightPlayerAdd((class_1297)this, this.getDungeon(), player);
        }
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        PacketDistributor.sendToPlayer(player, new BossInfoPacket.Remove(this.bossFight.method_5407(), this.method_5628()), new class_8710[0]);
        this.bossFight.method_14089(player);
        AetherEventDispatch.onBossFightPlayerRemove((class_1297)this, this.getDungeon(), player);
    }

    public void onDungeonPlayerAdded(@Nullable class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.bossFight.method_14088(serverPlayer);
            AetherEventDispatch.onBossFightPlayerAdd((class_1297)this, this.getDungeon(), serverPlayer);
        }
    }

    public void onDungeonPlayerRemoved(@Nullable class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.bossFight.method_14089(serverPlayer);
            if (!serverPlayer.method_5805()) {
                serverPlayer.method_43496((class_2561)class_2561.method_43471((String)"gui.aether.sun_spirit.playerdeath").method_27692(class_124.field_1061));
            }
            AetherEventDispatch.onBossFightPlayerRemove((class_1297)this, this.getDungeon(), serverPlayer);
        }
    }

    public boolean isFrozen() {
        return (Boolean)this.method_5841().method_12789(DATA_IS_FROZEN);
    }

    public void setFrozen(boolean frozen) {
        this.method_5841().method_12778(DATA_IS_FROZEN, (Object)frozen);
    }

    public int getFrozenDuration() {
        return (Integer)this.method_5841().method_12789(DATA_FROZEN_DURATION);
    }

    public void setFrozenDuration(int duration) {
        this.method_5841().method_12778(DATA_FROZEN_DURATION, (Object)duration);
    }

    public class_2561 getBossName() {
        return (class_2561)this.method_5841().method_12789(DATA_BOSS_NAME);
    }

    public void setBossName(class_2561 component) {
        this.method_5841().method_12778(DATA_BOSS_NAME, (Object)component);
        this.bossFight.method_5413(component);
    }

    public boolean getDisplayWeakMessage() {
        return (Boolean)this.method_5841().method_12789(DATA_DISPLAY_WEAK_MESSAGE);
    }

    public void setDisplayWeakMessage(boolean display) {
        this.method_5841().method_12778(DATA_DISPLAY_WEAK_MESSAGE, (Object)display);
    }

    @Nullable
    public BossRoomTracker<SunSpirit> getDungeon() {
        return this.dungeon;
    }

    public void setDungeon(@Nullable BossRoomTracker<SunSpirit> dungeon) {
        this.dungeon = dungeon;
        if (dungeon != null) {
            this.origin = dungeon.originCoordinates();
            this.xMax = this.zMax = class_3532.method_15357((double)(dungeon.roomBounds().method_17939() / 2.0 - 5.0));
        } else {
            this.origin = this.method_19538();
            this.xMax = 9;
            this.zMax = 9;
        }
    }

    public boolean isBossFight() {
        return this.bossFight.method_14093();
    }

    public void setBossFight(boolean isFighting) {
        this.bossFight.method_14091(isFighting);
    }

    @Override
    @Nullable
    public class_2960 getBossBarTexture() {
        return class_2960.method_60655((String)"aether", (String)"boss_bar/sun_spirit");
    }

    @Override
    @Nullable
    public class_2960 getBossBarBackgroundTexture() {
        return class_2960.method_60655((String)"aether", (String)"boss_bar/sun_spirit_background");
    }

    @Override
    @Nullable
    public class_5195 getBossMusic() {
        return SUN_SPIRIT_MUSIC;
    }

    public int getChatCooldown() {
        return this.chatCooldown;
    }

    public void setChatCooldown(int cooldown) {
        this.chatCooldown = cooldown;
    }

    public int getDeathScore() {
        return this.field_6232;
    }

    public boolean method_5679(class_1282 source) {
        if (this.method_31481()) {
            return true;
        }
        if (this.isFrozen()) {
            return !(source.method_5529() instanceof class_1309) || source.method_5529() instanceof SunSpirit;
        }
        return !source.method_48789(class_8103.field_42242) && !source.method_48789(AetherTags.DamageTypes.IS_COLD);
    }

    protected class_3414 getInteractSound() {
        return AetherSoundEvents.ENTITY_SUN_SPIRIT_INTERACT.get();
    }

    protected class_3414 getActivateSound() {
        return AetherSoundEvents.ENTITY_SUN_SPIRIT_ACTIVATE.get();
    }

    protected class_3414 getShootFireSound() {
        return AetherSoundEvents.ENTITY_SUN_SPIRIT_SHOOT_FIRE.get();
    }

    protected class_3414 getShootIceSound() {
        return AetherSoundEvents.ENTITY_SUN_SPIRIT_SHOOT_ICE.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return AetherSoundEvents.ENTITY_SUN_SPIRIT_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return AetherSoundEvents.ENTITY_SUN_SPIRIT_DEATH.get();
    }

    protected float method_6107() {
        return 3.0f;
    }

    public boolean method_5659(class_1927 explosion) {
        return true;
    }

    public boolean method_5740() {
        return true;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        this.addBossSaveData(tag, (class_7225.class_7874)this.method_56673());
        tag.method_10569("ChatLine", this.chatLine);
        tag.method_10549("OffsetX", this.origin.method_10216() - this.method_23317());
        tag.method_10549("OffsetY", this.origin.method_10214() - this.method_23318());
        tag.method_10549("OffsetZ", this.origin.method_10215() - this.method_23321());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.readBossSaveData(tag, (class_7225.class_7874)this.method_56673());
        if (tag.method_10545("ChatLine")) {
            this.chatLine = tag.method_10550("ChatLine");
        }
        if (tag.method_10545("OffsetX")) {
            double offsetX = this.method_23317() + tag.method_10574("OffsetX");
            double offsetY = this.method_23318() + tag.method_10574("OffsetY");
            double offsetZ = this.method_23321() + tag.method_10574("OffsetZ");
            this.origin = new class_243(offsetX, offsetY, offsetZ);
        } else {
            this.origin = this.method_19538();
        }
    }

    @Override
    public void writeSpawnData(class_9129 buffer) {
        class_2487 tag = new class_2487();
        this.addBossSaveData(tag, (class_7225.class_7874)this.method_56673());
        buffer.method_10794((class_2520)tag);
    }

    @Override
    public void readSpawnData(class_9129 additionalData) {
        class_2487 tag = additionalData.method_10798();
        if (tag != null) {
            this.readBossSaveData(tag, (class_7225.class_7874)this.method_56673());
        }
    }

    public static class DoNothingGoal
    extends class_1352 {
        private final SunSpirit sunSpirit;

        public DoNothingGoal(SunSpirit sunSpirit) {
            this.sunSpirit = sunSpirit;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
        }

        public boolean method_6264() {
            return !this.sunSpirit.isBossFight();
        }

        public void method_6269() {
            this.sunSpirit.method_18799(class_243.field_1353);
            this.sunSpirit.method_5814(this.sunSpirit.origin.method_10216(), this.sunSpirit.origin.method_10214(), this.sunSpirit.origin.method_10215());
        }
    }

    public static class SunSpiritLookGoal
    extends class_1361 {
        public SunSpiritLookGoal(class_1308 mob, Class<? extends class_1309> lookAtType, float lookDistance, float probability) {
            this(mob, lookAtType, lookDistance, probability, false);
        }

        public SunSpiritLookGoal(class_1308 mob, Class<? extends class_1309> lookAtType, float lookDistance, float probability, boolean onlyHorizontal) {
            super(mob, lookAtType, lookDistance, probability, onlyHorizontal);
            class_4051 conditions = lookAtType == class_1657.class ? class_4051.method_36626().method_18424().method_18418((double)lookDistance).method_18420(entity -> class_1301.method_5913((class_1297)mob).test(entity)) : class_4051.method_36626().method_18424().method_18418((double)lookDistance);
            ((LookAtPlayerGoalAccessor)((Object)this)).aether$setLookAtContext(conditions);
        }
    }

    public static class ShootFireballGoal
    extends class_1352 {
        private final SunSpirit sunSpirit;
        private int shootCrystalInterval;
        private int crystalCount;

        public ShootFireballGoal(SunSpirit sunSpirit) {
            this.sunSpirit = sunSpirit;
            this.shootCrystalInterval = 50;
            this.crystalCount = 5;
        }

        public boolean method_6264() {
            return this.sunSpirit.isBossFight() && --this.shootCrystalInterval <= 0;
        }

        public void method_6269() {
            AbstractCrystal crystal;
            if (--this.crystalCount <= 0) {
                crystal = new IceCrystal(this.sunSpirit.method_37908(), (class_1297)this.sunSpirit);
                this.crystalCount = 5;
                this.sunSpirit.method_5783(this.sunSpirit.getShootIceSound(), 3.0f, this.sunSpirit.method_37908().method_8409().method_43057() - this.sunSpirit.method_37908().method_8409().method_43057() * 0.2f + 1.2f);
            } else {
                crystal = new FireCrystal(this.sunSpirit.method_37908(), (class_1297)this.sunSpirit);
                this.sunSpirit.method_5783(this.sunSpirit.getShootFireSound(), 3.0f, this.sunSpirit.method_37908().method_8409().method_43057() - this.sunSpirit.method_37908().method_8409().method_43057() * 0.2f + 1.2f);
            }
            this.sunSpirit.method_37908().method_8649((class_1297)crystal);
            this.shootCrystalInterval = 50;
        }

        public boolean method_38846() {
            return true;
        }
    }

    public static class SummonFireGoal
    extends class_1352 {
        private final SunSpirit sunSpirit;
        private int summonFireInterval;

        public SummonFireGoal(SunSpirit sunSpirit) {
            this.sunSpirit = sunSpirit;
            this.summonFireInterval = 35;
        }

        public boolean method_6264() {
            return this.sunSpirit.isBossFight() && --this.summonFireInterval <= 0;
        }

        public void method_6269() {
            class_2338 pos = class_2338.method_49637((double)this.sunSpirit.method_23317(), (double)this.sunSpirit.method_23318(), (double)this.sunSpirit.method_23321());
            for (int i = 0; i <= 3; ++i) {
                if (this.sunSpirit.method_37908().method_22347(pos) && !this.sunSpirit.method_37908().method_22347(pos.method_10074())) {
                    this.sunSpirit.method_37908().method_8652(pos, class_2246.field_10036.method_9564(), 11);
                    break;
                }
                pos = pos.method_10074();
            }
            this.summonFireInterval = 35;
        }

        public boolean method_38846() {
            return true;
        }
    }

    public static class FlyAroundGoal
    extends class_1352 {
        private final SunSpirit sunSpirit;
        private float rotation;
        private int courseChangeTimer;

        public FlyAroundGoal(SunSpirit sunSpirit) {
            this.sunSpirit = sunSpirit;
            this.rotation = sunSpirit.field_5974.method_43057() * 360.0f;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public void method_6268() {
            boolean changedCourse = this.outOfBounds();
            double x = (double)class_3532.method_15374((float)(this.rotation * ((float)Math.PI / 180))) * this.sunSpirit.method_45325(class_5134.field_23719) * this.sunSpirit.speedModifier;
            double z = (double)(-class_3532.method_15362((float)(this.rotation * ((float)Math.PI / 180)))) * this.sunSpirit.method_45325(class_5134.field_23719) * this.sunSpirit.speedModifier;
            this.sunSpirit.method_18800(x, 0.0, z);
            if (changedCourse || ++this.courseChangeTimer >= 20) {
                if (this.sunSpirit.method_59922().method_43048(3) == 0) {
                    this.rotation += this.sunSpirit.method_59922().method_43057() - this.sunSpirit.method_59922().method_43057() * 60.0f;
                }
                this.rotation = class_3532.method_15393((float)this.rotation);
                this.courseChangeTimer = 0;
            }
        }

        protected boolean outOfBounds() {
            boolean flag = false;
            if (this.sunSpirit.method_18798().method_10216() >= 0.0 && this.sunSpirit.method_23317() >= this.sunSpirit.origin.method_10216() + (double)this.sunSpirit.xMax || this.sunSpirit.method_18798().method_10216() <= 0.0 && this.sunSpirit.method_23317() <= this.sunSpirit.origin.method_10216() - (double)this.sunSpirit.xMax) {
                this.rotation = 360.0f - this.rotation;
                flag = true;
            }
            if (this.sunSpirit.method_18798().method_10215() >= 0.0 && this.sunSpirit.method_23321() >= this.sunSpirit.origin.method_10215() + (double)this.sunSpirit.zMax || this.sunSpirit.method_18798().method_10215() <= 0.0 && this.sunSpirit.method_23321() <= this.sunSpirit.origin.method_10215() - (double)this.sunSpirit.zMax) {
                this.rotation = 180.0f - this.rotation;
                flag = true;
            }
            return flag;
        }

        public boolean method_6264() {
            return this.sunSpirit.isBossFight();
        }

        public boolean method_38846() {
            return true;
        }
    }
}

