/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.poolelement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.Lithostitched;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.placementcondition.PlacementCondition;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3784;
import net.minecraft.class_5699;
import net.minecraft.class_5847;
import net.minecraft.class_6497;

public record DelegatingConfig(class_3784 delegate, Optional<class_2960> name, Optional<PlacementCondition> placementCondition, Optional<class_6497<Integer>> allowedDepth, Optional<Integer> forcedCount, Optional<Integer> maxCount, boolean allowBoundingBoxCollisions, boolean otherPiecesCanIntersect, Optional<class_5847> overrideTerrainAdaption) {
    public static final MapCodec<DelegatingConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_3784.field_24953.fieldOf("delegate").forGetter(DelegatingConfig::delegate), (App)class_2960.field_25139.optionalFieldOf("name").forGetter(DelegatingConfig::name), (App)PlacementCondition.CODEC.optionalFieldOf("condition").forGetter(DelegatingConfig::placementCondition), (App)LithostitchedCodecs.INT_RANGE.optionalFieldOf("allowed_depth").forGetter(DelegatingConfig::allowedDepth), (App)class_5699.field_33442.optionalFieldOf("forced_count").forGetter(DelegatingConfig::forcedCount), (App)class_5699.field_33441.optionalFieldOf("max_count").forGetter(DelegatingConfig::maxCount), (App)Codec.BOOL.optionalFieldOf("allow_bounding_box_collisions", (Object)false).forGetter(DelegatingConfig::allowBoundingBoxCollisions), (App)Codec.BOOL.optionalFieldOf("other_pieces_can_intersect", (Object)false).forGetter(DelegatingConfig::otherPiecesCanIntersect), (App)class_5847.field_38433.optionalFieldOf("override_terrain_adaption").forGetter(DelegatingConfig::overrideTerrainAdaption)).apply((Applicative)instance, DelegatingConfig::new)).validate(DelegatingConfig::validate);

    public DelegatingConfig(class_3784 delegate) {
        this(delegate, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false, false, Optional.empty());
    }

    private static DataResult<DelegatingConfig> validate(DelegatingConfig config) {
        if (config.forcedCount.isPresent() && config.maxCount.isPresent()) {
            return DataResult.error(() -> "forced_count and max_count cannot both be present.");
        }
        return DataResult.success((Object)config);
    }

    public class_2960 getName() {
        return this.name.orElseGet(() -> Lithostitched.id("generated/" + this.delegate.hashCode()));
    }

    public boolean shouldCancelPlacement(class_3195.class_7149 context, class_2338 pos, int depth, int count) {
        boolean validDepth = this.allowedDepth.map(range -> range.method_37955((Comparable)Integer.valueOf(depth))).orElse(true);
        boolean validCount = this.forcedCount.map(forced -> count < forced).orElse(true) != false && this.maxCount.map(max -> count < max).orElse(true) != false;
        boolean validCondition = this.placementCondition.map(condition -> condition.test(context, pos)).orElse(true);
        return !validDepth || !validCount || !validCondition;
    }
}

