/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.init;

import com.mojang.serialization.Codec;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.creeperhost.polylib.PolyLib;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9279;
import net.minecraft.class_9331;

public class DataComps {
    private static final DeferredRegister<class_9331<?>> DATA = DeferredRegister.create((String)"polylib", (class_5321)class_7924.field_49659);
    private static RegistrySupplier<class_9331<Boolean>> ITEM_TOGGLE_ACTIVE;
    private static RegistrySupplier<class_9331<Long>> ITEM_ENERGY;
    private static RegistrySupplier<class_9331<class_9279>> ITEM_TILE_DATA;
    private static boolean dataEnabled;
    private static boolean activatedByMod;

    public static void init() {
        if (!PolyLib.configData.serverOnlySupport) {
            DataComps._registerData();
        }
    }

    public static void registerData() {
        activatedByMod = true;
        DataComps._registerData();
    }

    private static void _registerData() {
        if (dataEnabled) {
            return;
        }
        dataEnabled = true;
        DATA.register();
        ITEM_TOGGLE_ACTIVE = DATA.register("item_toggle_active", () -> class_9331.method_57873().method_57881((Codec)Codec.BOOL).method_57882(class_9135.field_48547).method_57880());
        ITEM_ENERGY = DATA.register("item_energy", () -> class_9331.method_57873().method_57881((Codec)Codec.LONG).method_57882(class_9135.field_48551).method_57880());
        ITEM_TILE_DATA = DATA.register("item_tile_data", () -> class_9331.method_57873().method_57881(class_9279.field_49303).method_57880());
    }

    private static void checkEnabled() {
        if (!dataEnabled) {
            throw new RuntimeException("A mod is attempting to use PolyLib's Item Data, But Item data has not been enabled. The offending mod needs to call PolyLib.initPolyItemData() in its init.\nYou can work around this issue by setting serverOnlySupport to false in PolyLib's Config.");
        }
        if (!activatedByMod) {
            PolyLib.LOGGER.warn("A mod is using PolyLib's Item Data system without calling PolyLib.initPolyItemData() in its init method. This will break in later versions.");
        }
    }

    public static class_9331<Boolean> getItemToggleActive() {
        DataComps.checkEnabled();
        return (class_9331)ITEM_TOGGLE_ACTIVE.get();
    }

    public static class_9331<Long> getItemEnergy() {
        DataComps.checkEnabled();
        return (class_9331)ITEM_ENERGY.get();
    }

    public static class_9331<class_9279> getItemTileData() {
        DataComps.checkEnabled();
        return (class_9331)ITEM_TILE_DATA.get();
    }

    static {
        dataEnabled = false;
        activatedByMod = false;
    }
}

