/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.fabric.inventory.fluid;

import dev.architectury.fluid.FluidStack;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_3611;

public class PolyFabricFluidWrapper
extends SnapshotParticipant<ResourceAmount<FluidVariant>>
implements SingleSlotStorage<FluidVariant> {
    private final PolyFluidHandler handler;
    private final int tank;

    public PolyFabricFluidWrapper(PolyFluidHandler handler, int tank) {
        this.handler = handler;
        this.tank = tank;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        FluidStack stack = FluidStack.create((class_3611)resource.getFluid(), (long)maxAmount);
        long insertedAmount = this.handler.fill(stack, true);
        if (insertedAmount > 0L) {
            this.updateSnapshots(transaction);
            return this.handler.fill(stack, false);
        }
        return 0L;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        FluidStack stack = FluidStack.create((class_3611)resource.getFluid(), (long)maxAmount);
        long extractedAmount = this.handler.drain(stack, true).getAmount();
        if (extractedAmount > 0L) {
            this.updateSnapshots(transaction);
            return this.handler.drain(stack, false).getAmount();
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.handler.getFluidInTank(this.tank).isEmpty();
    }

    public FluidVariant getResource() {
        return FluidVariant.of((class_3611)this.handler.getFluidInTank(this.tank).getFluid());
    }

    public long getAmount() {
        return this.handler.getFluidInTank(this.tank).getAmount();
    }

    public long getCapacity() {
        return this.handler.getTankCapacity(this.tank);
    }

    protected ResourceAmount<FluidVariant> createSnapshot() {
        return new ResourceAmount((Object)FluidVariant.of((class_3611)this.handler.getFluidInTank(this.tank).getFluid()), this.handler.getFluidInTank(this.tank).getAmount());
    }

    protected void readSnapshot(ResourceAmount<FluidVariant> snapshot) {
        this.handler._setFluidInTank(this.tank, FluidStack.create((class_3611)((FluidVariant)snapshot.resource()).getFluid(), (long)snapshot.amount()));
    }
}

