/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.screen.widget.buttons;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.creeperhost.polylib.client.screen.widget.buttons.PolyButton;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import org.jetbrains.annotations.NotNull;

public class DropdownButton<E extends IDropdownOption>
extends PolyButton {
    public boolean dropdownOpen;
    private E selected;
    private List<E> possibleVals;
    private class_2561 baseButtonText;
    private final boolean dynamic;
    private final boolean drawHeader;
    public boolean wasJustClosed = false;
    class_310 minecraft = class_310.method_1551();
    public boolean flipped = false;

    public DropdownButton(int x, int y, int widthIn, int heightIn, class_2561 buttonText, E def, boolean dynamic, boolean drawHeader, class_4185.class_4241 onPress) {
        super(x, y, widthIn, heightIn, buttonText, onPress, field_40754);
        this.selected = def;
        this.possibleVals = def.getPossibleVals();
        this.baseButtonText = buttonText;
        this.dynamic = dynamic;
        this.drawHeader = drawHeader;
    }

    public DropdownButton(int x, int y, int widthIn, int heightIn, class_2561 buttonText, E def, boolean dynamic, class_4185.class_4241 onPress) {
        this(x, y, widthIn, heightIn, buttonText, def, dynamic, true, onPress);
    }

    public DropdownButton(int x, int y, class_2561 buttonText, E def, boolean dynamic, class_4185.class_4241 onPress) {
        this(x, y, 200, 20, buttonText, def, dynamic, onPress);
    }

    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22764) {
            int drawY = this.method_46427();
            class_327 fontrenderer = this.minecraft.field_1772;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_22762 = mouseX >= this.method_46426() && mouseY >= drawY && mouseX < this.method_46426() + this.field_22758 && mouseY < drawY + this.field_22759;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            if (this.drawHeader) {
                guiGraphics.method_52706(SPRITES.method_52729(this.field_22763, this.method_25367()), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
                int j = 0xE0E0E0;
                if (!this.field_22763) {
                    j = 0xA0A0A0;
                } else if (this.field_22762) {
                    j = 0xFFFFA0;
                }
                guiGraphics.method_27534(fontrenderer, this.baseButtonText, this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, j);
            }
            if (this.dropdownOpen) {
                ++drawY;
                int yOffset = this.field_22759 - 2;
                if (this.flipped) {
                    yOffset = -yOffset;
                    --drawY;
                }
                int possibleValsSize = this.possibleVals.size();
                for (int j = 0; j < possibleValsSize; ++j) {
                    IDropdownOption e = (IDropdownOption)this.possibleVals.get(j);
                    boolean ourHovered = mouseX >= this.method_46426() && mouseY >= (drawY += yOffset) && mouseX < this.method_46426() + this.field_22758 && mouseY < drawY + this.field_22759 - 2;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    guiGraphics.method_52706(SPRITES.method_52729(this.field_22763, ourHovered), this.method_46426(), drawY, this.method_25368(), this.method_25364());
                    String name = class_1074.method_4662((String)e.getTranslate((IDropdownOption)this.selected, true), (Object[])new Object[0]);
                    int textColour = 0xE0E0E0;
                    guiGraphics.method_25300(fontrenderer, name, this.method_46426() + this.field_22758 / 2, drawY + (this.field_22759 - 10) / 2, textColour);
                }
            }
        }
    }

    protected int getHoverState(boolean mouseOver) {
        return mouseOver ? 2 : (this.field_22763 ? (this.dropdownOpen ? 2 : 1) : 0);
    }

    public boolean method_25402(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        boolean pressed = super.method_25402(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.dropdownOpen) {
            if (this.drawHeader && pressed) {
                this.close();
                return false;
            }
            E clickedElement = this.getClickedElement(p_mouseClicked_1_, p_mouseClicked_3_);
            if (clickedElement != null) {
                this.setSelected(clickedElement);
                try {
                    this.ourOnPress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.close();
                return true;
            }
            this.close();
            return false;
        }
        if (pressed && this.drawHeader) {
            this.dropdownOpen = true;
            if (this.dynamic) {
                this.selected.updateDynamic();
                this.possibleVals = this.selected.getPossibleVals();
            }
        }
        return false;
    }

    public void ourOnPress() {
    }

    public void method_25306() {
    }

    public void close() {
        this.dropdownOpen = false;
        this.wasJustClosed = true;
    }

    public E getSelected() {
        return this.selected;
    }

    public void setSelected(E selected) {
        try {
            this.selected = selected;
            this.updateDisplayString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDisplayString() {
        this.baseButtonText = class_2561.method_43469((String)this.selected.getTranslate((IDropdownOption)this.selected, false), (Object[])new Object[]{this.baseButtonText});
    }

    private E getClickedElement(double mouseX, double mouseY) {
        IDropdownOption clickedElement = null;
        int y = this.method_46427() + 1;
        int yOffset = this.field_22759 - 2;
        if (this.flipped) {
            yOffset = -yOffset;
            --y;
        }
        for (IDropdownOption e : this.possibleVals) {
            y += yOffset;
            if (!(mouseX >= (double)this.method_46426()) || !(mouseY >= (double)y) || !(mouseX < (double)(this.method_46426() + this.field_22758)) || !(mouseY < (double)(y + this.field_22759 - 2))) continue;
            clickedElement = e;
            break;
        }
        return (E)clickedElement;
    }

    public List<E> getPossibleVals() {
        return this.possibleVals;
    }

    public static interface IDropdownOption {
        public List<IDropdownOption> getPossibleVals();

        public String getTranslate(IDropdownOption var1, boolean var2);

        default public void updateDynamic() {
        }
    }
}

