/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Deque;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScissorHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    private final Deque<ScissorState> stack = Queues.newArrayDeque();

    public void pushGuiScissor(double x, double y, double width, double height) {
        class_1041 window = class_310.method_1551().method_22683();
        int windowHeight = window.method_4506();
        double scale = window.method_4495();
        double scX = x * scale;
        double scY = (double)windowHeight - (y + height) * scale;
        double scW = Math.max(width * scale, 0.0);
        double scH = Math.max(height * scale, 0.0);
        this.pushScissor((int)scX, (int)scY, (int)scW, (int)scH);
    }

    public void pushScissor(int x, int y, int width, int height) {
        int xMax = x + width;
        int yMax = y + height;
        this.stack.addLast(new ScissorState(x, y, xMax, yMax, this.stack.peekLast()).apply());
    }

    public void popScissor() {
        if (this.stack.isEmpty()) {
            LOGGER.error("Scissor stack underflow");
        }
        this.stack.removeLast();
        ScissorState active = this.stack.peekLast();
        if (active != null) {
            active.apply();
        } else {
            RenderSystem.disableScissor();
        }
    }

    private static class ScissorState {
        private int x;
        private int y;
        private int xMax;
        private int yMax;

        private ScissorState(int x, int y, int xMax, int yMax, ScissorState prevState) {
            if (prevState != null) {
                this.x = Math.max(prevState.x, x);
                this.y = Math.max(prevState.y, y);
                this.xMax = Math.min(prevState.xMax, xMax);
                this.yMax = Math.min(prevState.yMax, yMax);
                class_310 mc = class_310.method_1551();
                if (this.x < 0) {
                    this.x = 0;
                }
                if (this.y < 0) {
                    this.y = 0;
                }
                if (this.xMax > mc.method_22683().method_4480()) {
                    this.xMax = mc.method_22683().method_4480();
                }
                if (this.yMax > mc.method_22683().method_4507()) {
                    this.yMax = mc.method_22683().method_4507();
                }
                if (this.xMax < this.x) {
                    this.xMax = this.x;
                }
                if (this.yMax < this.y) {
                    this.yMax = this.y;
                }
            } else {
                this.x = x;
                this.y = y;
                this.xMax = xMax;
                this.yMax = yMax;
            }
        }

        private ScissorState apply() {
            RenderSystem.enableScissor((int)this.x, (int)this.y, (int)(this.xMax - this.x), (int)(this.yMax - this.y));
            return this;
        }
    }
}

