/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import java.util.Locale;
import net.minecraft.class_2919;
import org.betterx.bclib.util.WeightedList;

public class WeighTree<T> {
    private final float maxWeight;
    private final Node root;

    public WeighTree(WeightedList<T> list) {
        this.maxWeight = list.getMaxWeight();
        this.root = this.getNode(list);
    }

    public T get(class_2919 random) {
        return this.root.get(random.method_43057() * this.maxWeight);
    }

    private Node getNode(WeightedList<T> list) {
        int size = list.size();
        if (size == 1) {
            return new Leaf(this, list.get(0));
        }
        if (size == 2) {
            T first = list.get(0);
            return new Branch(this, list.getWeight(0), new Leaf(this, first), new Leaf(this, list.get(1)));
        }
        int index = size >> 1;
        float separator = list.getWeight(index);
        Node a = this.getNode(list.subList(0, index + 1));
        Node b = this.getNode(list.subList(index, size));
        return new Branch(this, separator, a, b);
    }

    public String toString() {
        return this.root.toString();
    }

    private abstract class Node {
        private Node(WeighTree weighTree) {
        }

        abstract T get(float var1);
    }

    private class Leaf
    extends Node {
        final T biome;

        Leaf(WeighTree weighTree, T value) {
            super(weighTree);
            this.biome = value;
        }

        @Override
        T get(float value) {
            return this.biome;
        }

        public String toString() {
            return String.format(Locale.ROOT, "[%s]", this.biome.toString());
        }
    }

    private class Branch
    extends Node {
        final float separator;
        final Node min;
        final Node max;

        public Branch(WeighTree weighTree, float separator, Node min, Node max) {
            super(weighTree);
            this.separator = separator;
            this.min = min;
            this.max = max;
        }

        @Override
        T get(float value) {
            return value < this.separator ? this.min.get(value) : this.max.get(value);
        }

        public String toString() {
            return String.format(Locale.ROOT, "[%f, %s, %s]", Float.valueOf(this.separator), this.min.toString(), this.max.toString());
        }
    }
}

