/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9285;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class ItemUtil {
    public static MapCodec<class_1799> CODEC_ITEM_STACK_WITH_NBT = ItemUtil.codecItemStackWithNBT(Function.identity(), Function.identity());
    private static final Codec<class_1856.class_1857> ITEM_VALUE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CODEC_ITEM_STACK_WITH_NBT.fieldOf("item").forGetter(class_1856.class_1857::comp_1930)).apply((Applicative)instance, class_1856.class_1857::new));
    public static final Codec<class_1856.class_1858> TAG_VALUE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("tag").forGetter(class_1856.class_1858::comp_1931)).apply((Applicative)instance, class_1856.class_1858::new));
    private static final Codec<class_1856.class_1859> VALUE_CODEC = Codec.xor(ITEM_VALUE_CODEC, TAG_VALUE_CODEC).xmap(either -> (class_1856.class_1859)either.map(itemValue -> itemValue, tagValue -> tagValue), value -> {
        if (value instanceof class_1856.class_1858) {
            class_1856.class_1858 tagValue = (class_1856.class_1858)value;
            return Either.right((Object)tagValue);
        }
        if (value instanceof class_1856.class_1857) {
            class_1856.class_1857 itemValue = (class_1856.class_1857)value;
            return Either.left((Object)itemValue);
        }
        throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
    });
    public static Codec<class_1856> CODEC_INGREDIENT_WITH_NBT = ItemUtil.codecIngredientWithNBT(false);
    public static Codec<class_1856> CODEC_LENIENT_INGREDIENT_WITH_NBT = ItemUtil.codecIngredientWithNBT(true);

    private static class_9323 getComponents(class_1799 stack) {
        class_9323 components = stack.method_57353().method_57828(c -> {
            class_9304 data;
            return c == class_9334.field_49633 ? (data = (class_9304)stack.method_57824(class_9334.field_49633)) != null && !data.method_57543() : (c == class_9334.field_49636 ? (data = (class_9285)stack.method_57824(class_9334.field_49636)) != null && !data.comp_2393().isEmpty() : c == class_9334.field_49643 && (data = (class_9304)stack.method_57824(class_9334.field_49643)) != null && !data.method_57543());
        });
        if (components.method_57837()) {
            return class_9323.field_49584;
        }
        return components;
    }

    public static <T> MapCodec<T> codecItemStackWithNBT(Function<T, class_1799> getter, Function<class_1799, T> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41178.method_40294().fieldOf("item").forGetter(o -> ((class_1799)getter.apply(o)).method_41409()), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(o -> ((class_1799)getter.apply(o)).method_7947()), (App)class_9323.field_50234.optionalFieldOf("nbt", (Object)class_9323.field_49584).forGetter(o -> ItemUtil.getComponents((class_1799)getter.apply(o)))).apply((Applicative)instance, (item, count, nbt) -> {
            class_1799 stack = new class_1799(item, count.intValue());
            if (nbt != null) {
                stack.method_57365(nbt);
            }
            return factory.apply(stack);
        }));
    }

    public static Codec<class_1856> codecIngredientWithNBT(boolean lenient) {
        Codec codec = Codec.list(VALUE_CODEC).comapFlatMap(list -> !lenient && list.isEmpty() ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)list.toArray(new class_1856.class_1859[0])), List::of);
        return Codec.either((Codec)codec, VALUE_CODEC).flatComapMap(either -> (class_1856)either.map(class_1856::new, value -> new class_1856(new class_1856.class_1859[]{value})), ingredient -> {
            if (ingredient.field_9019.length == 1) {
                return DataResult.success((Object)Either.right((Object)ingredient.field_9019[0]));
            }
            return ingredient.field_9019.length == 0 && !lenient ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)Either.left((Object)ingredient.field_9019));
        });
    }
}

