/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.AlloyingRecipeWorkstation;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.AlloyingRecipeInput;
import org.betterx.bclib.recipes.BCLBaseRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;
import org.betterx.wover.item.api.ItemStackHelper;
import org.betterx.wover.recipe.api.BaseRecipeBuilder;
import org.betterx.wover.recipe.api.BaseUnlockableRecipeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlloyingRecipe
implements class_1860<AlloyingRecipeInput>,
UnknownReceipBookCategory {
    public static final String GROUP = "alloying";
    public static final class_3956<AlloyingRecipe> TYPE = BCLRecipeManager.registerType(BCLib.MOD_ID, "alloying");
    public static final Serializer SERIALIZER = BCLRecipeManager.registerSerializer(BCLib.MOD_ID, "alloying", new Serializer());
    protected final class_3956<?> type;
    protected final class_1856 primaryInput;
    protected final class_1856 secondaryInput;
    protected final class_1799 output;
    protected final String group;
    protected final float experience;
    protected final int smeltTime;

    private AlloyingRecipe(List<class_1856> inputs, Optional<String> group, class_1799 output, float experience, int smeltTime) {
        this(group.orElse(""), !inputs.isEmpty() ? inputs.get(0) : null, inputs.size() > 1 ? inputs.get(1) : null, output, experience, smeltTime);
    }

    private AlloyingRecipe(@NotNull String group, class_1856 primaryInput, class_1856 secondaryInput, class_1799 output, float experience, int smeltTime) {
        this.group = group;
        this.primaryInput = primaryInput;
        this.secondaryInput = secondaryInput;
        this.output = ItemStackHelper.callItemStackSetupIfPossible((class_1799)output);
        this.experience = experience;
        this.smeltTime = smeltTime;
        this.type = TYPE;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getSmeltTime() {
        return this.smeltTime;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)this.primaryInput);
        defaultedList.add((Object)this.secondaryInput);
        return defaultedList;
    }

    public boolean matches(AlloyingRecipeInput inv, class_1937 level) {
        return this.primaryInput.method_8093(inv.method_59984(0)) && this.secondaryInput.method_8093(inv.method_59984(1)) || this.primaryInput.method_8093(inv.method_59984(1)) && this.secondaryInput.method_8093(inv.method_59984(0));
    }

    public class_1799 assemble(AlloyingRecipeInput recipeInput, class_7225.class_7874 provider) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 provider) {
        return this.output;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    @Environment(value=EnvType.CLIENT)
    public String method_8112() {
        return this.group;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 method_17447() {
        return AlloyingRecipeWorkstation.getWorkstationIcon();
    }

    public static void register() {
    }

    public static class Serializer
    implements class_1865<AlloyingRecipe> {
        public static final MapCodec<AlloyingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)class_1856.field_46096).fieldOf("ingredients").forGetter(recipe -> List.of(recipe.primaryInput, recipe.secondaryInput)), (App)Codec.STRING.lenientOptionalFieldOf("group").forGetter(recipe -> recipe.group == null || recipe.group.isEmpty() ? Optional.empty() : Optional.ofNullable(recipe.group)), (App)ItemUtil.CODEC_ITEM_STACK_WITH_NBT.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.optionalFieldOf("smelttime", (Object)350).forGetter(recipe -> recipe.smeltTime)).apply((Applicative)instance, AlloyingRecipe::new));
        public static final class_9139<class_9129, AlloyingRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<AlloyingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, AlloyingRecipe> method_56104() {
            return STREAM_CODEC;
        }

        @NotNull
        public static AlloyingRecipe fromNetwork(class_9129 packetBuffer) {
            String group = packetBuffer.method_19772();
            class_1856 primary = (class_1856)class_1856.field_48355.decode((Object)packetBuffer);
            class_1856 secondary = (class_1856)class_1856.field_48355.decode((Object)packetBuffer);
            class_1799 output = (class_1799)class_1799.field_48349.decode((Object)packetBuffer);
            float experience = packetBuffer.readFloat();
            int smeltTime = packetBuffer.method_10816();
            return new AlloyingRecipe(group == null ? "" : group, primary, secondary, output, experience, smeltTime);
        }

        public static void toNetwork(class_9129 packetBuffer, AlloyingRecipe recipe) {
            packetBuffer.method_10814(recipe.group);
            class_1856.field_48355.encode((Object)packetBuffer, (Object)recipe.primaryInput);
            class_1856.field_48355.encode((Object)packetBuffer, (Object)recipe.secondaryInput);
            class_1799.field_48349.encode((Object)packetBuffer, (Object)recipe.output);
            packetBuffer.method_52941(recipe.experience);
            packetBuffer.method_10804(recipe.smeltTime);
        }
    }

    public static class BuilderImpl
    extends BCLBaseRecipeBuilder<Builder, AlloyingRecipe>
    implements Builder {
        private float experience = 0.0f;
        private int smeltTime = 350;

        private BuilderImpl(class_2960 id, class_1935 output) {
            super(id, output, true);
        }

        @Override
        public Builder setOutputTag(class_2487 tag) {
            return (Builder)super.setOutputTag(tag);
        }

        @Override
        public Builder setInput(class_1935 primaryInput, class_1935 secondaryInput) {
            this.setPrimaryInput(primaryInput);
            this.setSecondaryInput(secondaryInput);
            return this;
        }

        @Override
        public Builder setInput(class_6862<class_1792> primaryInput, class_6862<class_1792> secondaryInput) {
            this.setPrimaryInput(primaryInput);
            this.setSecondaryInput(secondaryInput);
            return this;
        }

        @Override
        public Builder setExperience(float amount) {
            this.experience = amount;
            return this;
        }

        @Override
        public Builder setSmeltTime(int time) {
            this.smeltTime = time;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.smeltTime < 0) {
                this.throwIllegalStateException("Smelt-time for recipe {} most be positive!");
            }
        }

        @Override
        protected AlloyingRecipe createRecipe(class_2960 id) {
            return new AlloyingRecipe(this.group == null ? "" : this.group, this.primaryInput, this.secondaryInput, this.output, this.experience, this.smeltTime);
        }
    }

    public static interface Builder
    extends BaseRecipeBuilder<Builder>,
    BaseUnlockableRecipeBuilder<Builder> {
        public Builder group(@Nullable String var1);

        public Builder outputCount(int var1);

        public Builder setInput(class_1935 var1, class_1935 var2);

        public Builder setInput(class_6862<class_1792> var1, class_6862<class_1792> var2);

        public Builder setExperience(float var1);

        public Builder setSmeltTime(int var1);

        public static Builder create(class_2960 id, class_1935 output) {
            return new BuilderImpl(id, output);
        }
    }
}

