/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.betterx.bclib.integration.emi.EMIPlugin;

public abstract class EMIAbstractAlloyingRecipe<C extends class_9695, T extends class_1860<C>>
implements EmiRecipe {
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    protected final T recipe;
    private final int fuelMultiplier;
    private final boolean infiniBurn;

    public EMIAbstractAlloyingRecipe(class_8786<T> recipe, class_2960 id, int fuelMultiplier, boolean infiniBurn) {
        this.recipe = recipe.comp_1933();
        this.id = id;
        this.input = List.of(EmiIngredient.of((class_1856)((class_1856)this.recipe.method_8117().get(0))), this.recipe.method_8117().size() > 1 ? EmiIngredient.of((class_1856)((class_1856)this.recipe.method_8117().get(1))) : EmiIngredient.of((class_1856)class_1856.field_9017));
        this.output = List.of(EmiStack.of((class_1799)this.recipe.method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349())));
        this.fuelMultiplier = fuelMultiplier;
        this.infiniBurn = infiniBurn;
    }

    protected abstract int getSmeltTime();

    protected abstract float getExperience();

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.END_ALLOYING_CATEGORY;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    protected int getXOffset() {
        return 22;
    }

    public int getDisplayWidth() {
        return 82 + this.getXOffset();
    }

    public int getDisplayHeight() {
        return 38;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addFillingArrow(24 + this.getXOffset(), 5, 50 * this.getSmeltTime()).tooltip((mx, my) -> List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)this.getSmeltTime() / 20.0f)}).method_30937())));
        if (this.infiniBurn) {
            widgets.addTexture(EmiTexture.FULL_FLAME, 1, 24);
        } else {
            widgets.addTexture(EmiTexture.EMPTY_FLAME, 1, 24);
            widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 1, 24, 4000 / this.fuelMultiplier, false, true, true);
        }
        widgets.addSlot(this.input.get(0), 0, 4);
        widgets.addSlot(this.input.size() > 1 ? this.input.get(1) : null, 20, 4);
        widgets.addText(class_2561.method_43469((String)"emi.cooking.experience", (Object[])new Object[]{Float.valueOf(this.getExperience())}).method_30937(), 24 + this.getXOffset(), 28, -1, true);
        widgets.addSlot((EmiIngredient)this.output.get(0), 56 + this.getXOffset(), 0).large(true).recipeContext((EmiRecipe)this);
    }

    public boolean supportsRecipeTree() {
        return true;
    }
}

