/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.ambertation.wunderlib.math.Float3;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2277;
import net.minecraft.class_2278;

public class Float3ArgumentType
implements ArgumentType<Float3> {
    private static final Collection<String> EXAMPLES = List.of("0 0 0");
    private final double minimum;
    private final double maximum;
    private final boolean asInt;

    Float3ArgumentType(int minimum, int maximum) {
        this(true, minimum, maximum);
    }

    Float3ArgumentType(double minimum, double maximum) {
        this(false, minimum, maximum);
    }

    Float3ArgumentType(boolean asInt, double minimum, double maximum) {
        this.asInt = asInt;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public boolean isInt() {
        return this.asInt;
    }

    public Float3 parse(StringReader reader) throws CommandSyntaxException {
        double y;
        double x;
        int i = reader.getCursor();
        double d = x = this.asInt ? this.parseInt(reader) : this.parseDouble(reader);
        if (!reader.canRead() || reader.peek() != ' ') {
            reader.setCursor(i);
            throw class_2277.field_10755.createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        double d2 = y = this.asInt ? this.parseInt(reader) : this.parseDouble(reader);
        if (!reader.canRead() || reader.peek() != ' ') {
            reader.setCursor(i);
            throw class_2277.field_10755.createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        double z = this.asInt ? this.parseInt(reader) : this.parseDouble(reader);
        return Float3.of((double)x, (double)y, (double)z);
    }

    private double parseDouble(StringReader reader) throws CommandSyntaxException {
        double result;
        if (!reader.canRead()) {
            throw class_2278.field_10759.createWithContext((ImmutableStringReader)reader);
        }
        int start = reader.getCursor();
        double d = result = reader.canRead() && reader.peek() != ' ' ? reader.readDouble() : 0.0;
        if (result < this.minimum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.doubleTooLow().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.minimum);
        }
        if (result > this.maximum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.doubleTooHigh().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.maximum);
        }
        return result;
    }

    private double parseInt(StringReader reader) throws CommandSyntaxException {
        int result;
        if (!reader.canRead()) {
            throw class_2278.field_10759.createWithContext((ImmutableStringReader)reader);
        }
        int start = reader.getCursor();
        int n = result = reader.canRead() && reader.peek() != ' ' ? reader.readInt() : 0;
        if ((double)result < this.minimum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooLow().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.minimum);
        }
        if ((double)result > this.maximum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.maximum);
        }
        return result;
    }

    public static Float3ArgumentType int3() {
        return new Float3ArgumentType(-1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static Float3ArgumentType int3(int min) {
        return new Float3ArgumentType((double)min, Double.MAX_VALUE);
    }

    public static Float3ArgumentType int3(int min, int max) {
        return new Float3ArgumentType(min, max);
    }

    public static Float3ArgumentType float3() {
        return new Float3ArgumentType(-1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static Float3ArgumentType float3(double min) {
        return new Float3ArgumentType(min, Double.MAX_VALUE);
    }

    public static Float3ArgumentType float3(double min, double max) {
        return new Float3ArgumentType(min, max);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        return class_2172.method_9260((String)remaining, List.of(new class_2172.class_2173("8", "8", "8")), (SuggestionsBuilder)builder, (Predicate)class_2170.method_9238(this::parse));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static Float3 getFloat3(CommandContext<class_2168> commandContext, String string) {
        return (Float3)commandContext.getArgument(string, Float3.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Float3ArgumentType)) {
            return false;
        }
        Float3ArgumentType that = (Float3ArgumentType)o;
        return Double.compare(that.minimum, this.minimum) == 0 && Double.compare(that.maximum, this.maximum) == 0 && this.asInt == that.asInt;
    }

    public int hashCode() {
        return Objects.hash(this.minimum, this.maximum, this.asInt);
    }

    public String toString() {
        if (this.asInt) {
            if (this.minimum == -1.7976931348623157E308 && this.maximum == Double.MAX_VALUE) {
                return "int3()";
            }
            if (this.maximum == Double.MAX_VALUE) {
                return "int3(" + (int)this.minimum + ")";
            }
            return "int3(" + (int)this.minimum + ", " + (int)this.maximum + ")";
        }
        if (this.minimum == -1.7976931348623157E308 && this.maximum == Double.MAX_VALUE) {
            return "float3()";
        }
        if (this.maximum == Double.MAX_VALUE) {
            return "float3(" + (int)this.minimum + ")";
        }
        return "float3(" + (int)this.minimum + ", " + (int)this.maximum + ")";
    }
}

