/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_5819;
import org.betterx.bclib.behaviours.interfaces.BehaviourVine;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVineBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
class_2256,
BehaviourVine,
BlockLootProvider,
BlockModelProvider {
    private static final class_265 VOXEL_SHAPE = AbstractVineBlock.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected final int maxGrowLength;
    protected final int spaceBeneath;
    protected final int growChance;

    private static class_4970.class_2251 makeProps(class_4970.class_2251 properties, int growChance) {
        if (growChance > 0) {
            return properties.method_9640();
        }
        return properties;
    }

    protected AbstractVineBlock(class_4970.class_2251 properties, int maxGrowLength, int spaceBeneath, int growChance) {
        super(AbstractVineBlock.makeProps(properties, growChance));
        this.spaceBeneath = Math.max(0, spaceBeneath);
        this.maxGrowLength = Math.max(1, maxGrowLength);
        this.growChance = growChance;
    }

    protected abstract void method_9515(class_2689.class_2690<class_2248, class_2680> var1);

    protected abstract class_2680 makeBottomState(class_2680 var1);

    protected abstract class_2680 makeMiddleState(class_2680 var1);

    protected abstract class_2680 makeTopState(class_2680 var1);

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
        class_243 vec3d = state.method_26226(view, pos);
        return VOXEL_SHAPE.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    }

    public boolean canGenerate(class_2680 state, class_4538 world, class_2338 pos) {
        return this.isSupport(state, world, pos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return this.isSupport(state, world, pos);
    }

    protected boolean isSupport(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 up = world.method_8320(pos.method_10084());
        return up.method_27852((class_2248)this) || up.method_26164(class_3481.field_15503) || AbstractVineBlock.method_20044((class_4538)world, (class_2338)pos.method_10084(), (class_2350)class_2350.field_11033);
    }

    public final class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!this.method_9558(state, (class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        if (world.method_8320(pos.method_10074()).method_26204() != this) {
            return this.makeBottomState(state);
        }
        if (world.method_8320(pos.method_10084()).method_26204() != this) {
            return this.makeTopState(state);
        }
        return this.makeMiddleState(state);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public boolean method_9651(class_4538 level, class_2338 pos, class_2680 state) {
        return this.canGrow(level, pos, null);
    }

    protected boolean canGrow(class_4538 level, class_2338 pos, @Nullable class_2338 bottomOrNull) {
        class_2338 bottom;
        class_2338 class_23382 = bottom = bottomOrNull == null ? pos : bottomOrNull;
        while (bottomOrNull == null && level.method_8320(bottom).method_26204() == this) {
            bottom = bottom.method_10074();
        }
        for (int i = 0; i <= this.spaceBeneath; ++i) {
            if (level.method_8320(bottom.method_10087(i)).method_26215()) continue;
            return false;
        }
        class_2338 top = pos;
        while (level.method_8320(top).method_26204() == this) {
            top = top.method_10084();
        }
        return top.method_10264() - bottom.method_10264() <= this.maxGrowLength;
    }

    protected void grow(class_3218 level, class_2338 pos) {
        if (level.method_8320(pos.method_10084()).method_26204() != this) {
            BlocksHelper.setWithoutUpdate((class_1936)level, pos, this.makeTopState(this.method_9564()));
        } else {
            BlocksHelper.setWithoutUpdate((class_1936)level, pos, this.makeMiddleState(this.method_9564()));
        }
        while (level.method_8320(pos).method_26204() == this) {
            pos = pos.method_10074();
        }
        BlocksHelper.setWithUpdate((class_1936)level, pos, this.method_9564());
    }

    public boolean method_9650(class_1937 level, class_5819 random, class_2338 pos, class_2680 state) {
        return this.canGrow((class_4538)level, pos, null);
    }

    public void method_9652(class_3218 level, class_5819 random, class_2338 pos, class_2680 state) {
        this.grow(level, pos);
    }

    @Override
    public class_52.class_53 registerBlockLoot(@NotNull class_2960 location, @NotNull LootLookupProvider provider, @NotNull class_5321<class_52> tableKey) {
        return provider.dropWithSilkTouchOrHoeOrShears((class_1935)this, (class_5658)class_5662.method_32462((float)1.0f, (float)2.0f));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createCubeModel((class_2248)this);
        generator.createFlatItem((class_2248)this);
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        super.method_9514(state, level, pos, random);
        if (this.growChance > 0 && random.method_43048(this.growChance) == 0 && this.canGrow((class_4538)level, pos, pos.method_10074())) {
            this.grow(level, pos);
        }
    }
}

