/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util.client;

import dev.architectury.event.EventActor;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.fluid.FluidStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.util.client.fabric.ClientUtilsImpl;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.class_151;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class ClientUtils {
    public static final BooleanSupplier IS_CLIENT_OP = () -> class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_5687(1);
    public static final List<Runnable> RUN_LATER = new ArrayList<Runnable>();
    private static final MethodType EMPTY_METHOD_TYPE = MethodType.methodType(Void.TYPE);
    private static final HashMap<String, Optional<MethodHandle>> staticMethodCache = new HashMap();

    public static void execClientCommand(String command, boolean printChat) {
        EventResult res;
        if (!command.isEmpty() && class_310.method_1551().field_1724 != null && !(res = ((ClientChatEvent.Send)ClientChatEvent.SEND.invoker()).send(command, null)).interruptsFurtherEvaluation()) {
            if (printChat) {
                class_310.method_1551().field_1705.method_1743().method_1803(command);
            }
            class_310.method_1551().field_1724.field_3944.method_45730(command.replace("/", ""));
        }
    }

    public static void runLater(Runnable runnable) {
        RUN_LATER.add(runnable);
    }

    @Nullable
    public static <T> T getGuiAs(class_437 gui, Class<T> clazz) {
        IScreenWrapper wrapper;
        BaseScreen guiBase;
        if (gui instanceof IScreenWrapper && clazz.isAssignableFrom((guiBase = (wrapper = (IScreenWrapper)gui).getGui()).getClass())) {
            return (T)guiBase;
        }
        return (T)(clazz.isAssignableFrom(gui.getClass()) ? class_310.method_1551().field_1755 : null);
    }

    @Nullable
    public static <T> T getCurrentGuiAs(Class<T> clazz) {
        return class_310.method_1551().field_1755 == null ? null : (T)ClientUtils.getGuiAs(class_310.method_1551().field_1755, clazz);
    }

    public static boolean handleClick(String scheme, String path) {
        switch (scheme) {
            case "http": 
            case "https": {
                String uriStr = scheme + ":" + path;
                try {
                    URI uri = new URI(uriStr);
                    if (((Boolean)class_310.method_1551().field_1690.method_42431().method_41753()).booleanValue()) {
                        class_437 currentScreen = class_310.method_1551().field_1755;
                        class_310.method_1551().method_1507((class_437)new class_407(accepted -> {
                            if (accepted) {
                                class_156.method_668().method_673(uri);
                            }
                            class_310.method_1551().method_1507(currentScreen);
                        }, uriStr, false));
                    } else {
                        class_156.method_668().method_673(uri);
                    }
                    return true;
                }
                catch (Exception ex) {
                    ClientUtils.logHandleClickFailure(scheme, uriStr, ex);
                    FTBLibrary.LOGGER.warn("handleClick: unexpected exception handling http/https action {}: {}", (Object)uriStr, (Object)ex.getMessage());
                    return false;
                }
            }
            case "file": {
                try {
                    class_156.method_668().method_673(new URI("file:" + path));
                    return true;
                }
                catch (Exception ex) {
                    ClientUtils.logHandleClickFailure(scheme, path, ex);
                    return false;
                }
            }
            case "command": {
                ClientUtils.execClientCommand(path, false);
                return true;
            }
            case "static_method": {
                return staticMethodCache.computeIfAbsent(path, k -> {
                    String[] s = path.split(":", 2);
                    try {
                        Class<?> cls = Class.forName(s[0]);
                        return Optional.ofNullable(MethodHandles.publicLookup().findStatic(cls, s[1], EMPTY_METHOD_TYPE));
                    }
                    catch (ArrayIndexOutOfBoundsException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException ex) {
                        ClientUtils.logHandleClickFailure(scheme, path, ex);
                        return Optional.empty();
                    }
                }).map(handle -> {
                    try {
                        handle.invoke();
                        return true;
                    }
                    catch (Throwable ex) {
                        ClientUtils.logHandleClickFailure(scheme, path, ex);
                        return false;
                    }
                }).orElse(false);
            }
            case "custom": {
                return ClientUtils.trySendCustomClickEvent(path);
            }
        }
        return ClientUtils.trySendCustomClickEvent(scheme + ":" + path);
    }

    private static boolean trySendCustomClickEvent(String name) {
        try {
            class_2960 rl = class_2960.method_60654((String)name);
            return ((EventActor)CustomClickEvent.EVENT.invoker()).act((Object)new CustomClickEvent(rl)).isPresent();
        }
        catch (class_151 ex) {
            ClientUtils.logHandleClickFailure("custom", name, ex);
            return false;
        }
    }

    private static void logHandleClickFailure(String scheme, String path, Throwable ex) {
        FTBLibrary.LOGGER.warn("handleClick: unexpected exception handling action {} / {}: {}", (Object)scheme, (Object)path, (Object)ex.getMessage());
    }

    public static class_7225.class_7874 registryAccess() {
        return Objects.requireNonNull(class_310.method_1551().field_1687).method_30349();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2960 getStillTexture(FluidStack stack) {
        return ClientUtilsImpl.getStillTexture(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getFluidColor(FluidStack stack) {
        return ClientUtilsImpl.getFluidColor(stack);
    }
}

