/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.core.mixin.common.MultilineTextFieldAccess;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.IFocusableWidget;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_7530;
import net.minecraft.class_7533;

public class MultilineTextBox
extends Widget
implements IFocusableWidget {
    private final class_327 font;
    private boolean isFocused = false;
    private class_7530 textField;
    private class_2561 placeHolder = class_2561.method_43473();
    private int frame;
    private Consumer<String> valueListener = str -> {};

    public MultilineTextBox(Panel panel) {
        super(panel);
        this.font = this.getGui().getTheme().getFont();
        this.createTextField("", 100);
    }

    @Override
    public void setWidth(int v) {
        super.setWidth(v);
        this.createTextField(this.textField.method_44421(), this.width);
        this.recalculateHeight();
    }

    private void createTextField(String text, int width) {
        this.textField = new class_7530(this.font, width);
        this.textField.method_44413(this::scrollToCursor);
        this.textField.method_44414(text);
        this.textField.method_44415(this.valueListener);
    }

    public void setValueListener(Consumer<String> valueListener) {
        this.valueListener = valueListener;
        this.textField.method_44415(valueListener);
    }

    @Override
    public final boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public final void setFocused(boolean focused) {
        this.isFocused = focused;
        if (focused) {
            this.getGui().setFocusedWidget(this);
        }
    }

    public String getText() {
        return this.textField.method_44421();
    }

    public void setText(String text) {
        this.textField.method_44414(text);
        this.recalculateHeight();
    }

    private void recalculateHeight() {
        int n = this.innerPadding() * 2;
        int n2 = this.textField.method_44430();
        Objects.requireNonNull(this.font);
        this.height = n + n2 * 9;
    }

    public void seekCursor(class_7533 whence, int pos) {
        this.textField.method_44412(whence, pos);
    }

    public void setPlaceHolder(class_2561 placeHolder) {
        this.placeHolder = placeHolder;
    }

    public void setSelecting(boolean selecting) {
        this.textField.method_44417(selecting);
    }

    public boolean hasSelection() {
        return this.textField.method_44435();
    }

    public String getSelectedText() {
        return this.textField.method_44436();
    }

    public void insertText(String toInsert) {
        this.textField.method_44420(toInsert);
        this.recalculateHeight();
    }

    public int cursorPos() {
        return this.textField.method_44424();
    }

    public void selectCurrentLine() {
        class_7530.class_7531 view = this.textField.method_44422(this.textField.method_44432());
        this.textField.method_44417(false);
        this.textField.method_44412(class_7533.field_39535, view.comp_862());
        this.textField.method_44417(true);
        this.textField.method_44412(class_7533.field_39535, view.comp_863());
    }

    public StringExtents getLineView() {
        return StringExtents.of(this.textField.method_44422(this.textField.method_44432()));
    }

    public StringExtents getLineView(int line) {
        return StringExtents.of(this.textField.method_44422(line));
    }

    public StringExtents getSelected() {
        return StringExtents.of(this.textField.method_44427());
    }

    @Override
    public void tick() {
        ++this.frame;
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (this.isMouseOver()) {
            if (button.isLeft()) {
                this.setFocused(true);
                this.textField.method_44417(class_437.method_25442());
                this.setCursorPos(this.getMouseX(), (int)((double)this.getMouseY() - this.parent.getScrollY()));
            }
            return true;
        }
        this.setFocused(false);
        return false;
    }

    @Override
    public boolean mouseDoubleClicked(MouseButton button) {
        if (super.mouseDoubleClicked(button)) {
            return true;
        }
        if (this.isMouseOver() && button.isLeft()) {
            this.setCursorPos(this.getMouseX(), (int)((double)this.getMouseY() - this.parent.getScrollY()));
            class_7530.class_7531 view = this.textField.method_44437();
            this.textField.method_44412(class_7533.field_39535, view.comp_862());
            ((MultilineTextFieldAccess)this.textField).setSelectCursor(view.comp_863());
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int button, double dragX, double dragY) {
        if (super.mouseDragged(button, dragX, dragY)) {
            return true;
        }
        if (this.isMouseOver()) {
            this.textField.method_44417(true);
            this.setCursorPos(this.getMouseX(), (int)((double)this.getMouseY() - this.parent.getScrollY()));
            this.textField.method_44417(class_437.method_25442());
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(Key key) {
        boolean res = this.textField.method_44428(key.keyCode);
        this.recalculateHeight();
        return this.isFocused() && !key.esc() || res;
    }

    @Override
    public boolean charTyped(char c, KeyModifiers modifiers) {
        if (this.isFocused() && class_3544.method_57175((char)c)) {
            this.textField.method_44420(Character.toString(c));
            this.recalculateHeight();
            return true;
        }
        return false;
    }

    @Override
    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        String s = this.getText();
        if (s.isEmpty() && !this.isFocused()) {
            theme.drawString(graphics, this.placeHolder, x + 4, y + 4, 1);
            return;
        }
        int cursorPos = this.textField.method_44424();
        boolean drawCursor = this.isFocused() && this.frame / 6 % 2 == 0;
        boolean cursorInRange = cursorPos < s.length();
        int xPos = 0;
        int k = 0;
        int yPos = this.getY() + this.innerPadding();
        for (class_7530.class_7531 stringview : this.textField.method_44434()) {
            Objects.requireNonNull(this.font);
            boolean shouldDrawLine = this.withinContentArea(yPos, yPos + 9);
            if (drawCursor && cursorInRange && cursorPos >= stringview.comp_862() && cursorPos <= stringview.comp_863()) {
                if (shouldDrawLine) {
                    xPos = theme.drawString(graphics, s.substring(stringview.comp_862(), cursorPos), this.getX() + this.innerPadding(), yPos, Color4I.rgb(0xE0E0E0), 0);
                    Color4I color4I = Color4I.rgb(0xA0A0A0);
                    Objects.requireNonNull(this.font);
                    color4I.draw(graphics, xPos - 1, yPos, 1, 9);
                    theme.drawString(graphics, s.substring(cursorPos, stringview.comp_863()), xPos, yPos, Color4I.rgb(0xE0E0E0), 0);
                }
            } else {
                if (shouldDrawLine) {
                    xPos = theme.drawString(graphics, s.substring(stringview.comp_862(), stringview.comp_863()), this.getX() + this.innerPadding(), yPos, Color4I.rgb(0xE0E0E0), 0);
                }
                k = yPos;
            }
            Objects.requireNonNull(this.font);
            yPos += 9;
        }
        if (drawCursor && !cursorInRange && this.withinContentArea(k, k + 9)) {
            theme.drawString(graphics, "_", xPos, k, Color4I.rgb(0xA0A0A0), 0);
        }
        if (this.textField.method_44435()) {
            class_7530.class_7531 stringView = this.textField.method_44427();
            int xPos1 = this.getX() + this.innerPadding();
            yPos = this.getY() + this.innerPadding();
            for (class_7530.class_7531 stringView1 : this.textField.method_44434()) {
                if (stringView.comp_862() <= stringView1.comp_863()) {
                    if (stringView1.comp_862() > stringView.comp_863()) break;
                    if (this.withinContentArea(yPos, yPos + 9)) {
                        int xOff1 = this.font.method_1727(s.substring(stringView1.comp_862(), Math.max(stringView.comp_862(), stringView1.comp_862())));
                        int xOff2 = stringView.comp_863() > stringView1.comp_863() ? this.width - this.innerPadding() : this.font.method_1727(s.substring(stringView1.comp_862(), stringView.comp_863()));
                        Objects.requireNonNull(this.font);
                        this.renderHighlight(graphics, xPos1 + xOff1, yPos, xPos1 + xOff2, yPos + 9);
                    }
                }
                Objects.requireNonNull(this.font);
                yPos += 9;
            }
        }
    }

    private void renderHighlight(class_332 graphics, int x1, int y1, int x2, int y2) {
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        Color4I.rgb(255).draw(graphics, x1, y1, x2 - x1, y2 - y1);
        RenderSystem.disableColorLogicOp();
    }

    private boolean withinContentArea(int y1, int y2) {
        return (double)y1 - this.parent.getScrollY() >= (double)this.getY() && (double)y2 - this.parent.getScrollY() <= (double)(this.getY() + this.height);
    }

    private void setCursorPos(int mouseX, int mouseY) {
        double x = (double)mouseX - (double)this.getX() - (double)this.innerPadding();
        double y = (double)mouseY - (double)this.getY() - (double)this.innerPadding() + this.parent.getScrollY();
        this.seekCursorToPoint(x, y);
    }

    public void seekCursorToPoint(double x, double y) {
        int x1 = class_3532.method_15357((double)x);
        int y1 = class_3532.method_15357((double)(y / 9.0));
        class_7530.class_7531 stringView = this.textField.method_44422(class_3532.method_15340((int)y1, (int)0, (int)(this.textField.method_44430() - 1)));
        String lineSection = this.font.method_27523(this.textField.method_44421().substring(stringView.comp_862(), stringView.comp_863()), x1);
        int k = lineSection.length();
        this.textField.method_44412(class_7533.field_39535, stringView.comp_862() + k);
        if (this.textField.method_44424() < this.textField.method_44421().length()) {
            String c;
            int w2;
            int w1 = this.font.method_1727(lineSection);
            if (x1 <= this.font.method_1727(this.textField.method_44421().substring(stringView.comp_862(), stringView.comp_863())) && x1 - w1 >= (w2 = this.font.method_1727(c = String.valueOf(this.textField.method_44421().charAt(this.textField.method_44424()))) / 2)) {
                this.textField.method_44412(class_7533.field_39536, 1);
            }
        }
    }

    private void scrollToCursor() {
        Objects.requireNonNull(this.font);
        int lh = 9;
        double d0 = this.parent.getScrollY();
        class_7530.class_7531 stringView = this.textField.method_44422((int)(d0 / (double)lh));
        if (this.textField.method_44424() <= stringView.comp_862()) {
            d0 = this.textField.method_44432() * lh;
        } else {
            class_7530.class_7531 stringView1 = this.textField.method_44422((int)((d0 + (double)this.parent.height) / (double)lh) - 1);
            if (this.textField.method_44424() > stringView1.comp_863()) {
                d0 = this.textField.method_44432() * lh - this.parent.height + lh + this.innerPadding() * 2;
            }
        }
        this.parent.setScrollY(d0);
    }

    private int innerPadding() {
        return 4;
    }

    public record StringExtents(int start, int end) {
        public static StringExtents of(class_7530.class_7531 view) {
            return new StringExtents(view.comp_862(), view.comp_863());
        }
    }
}

