/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.ContextButton;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.PopupMenu;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class DropDownMenu
extends ModalPanel
implements PopupMenu {
    private final ScrollBar scrollBar;
    private final Panel mainPanel;
    private final TextBox textBox = new TextBox(this){

        @Override
        public void onTextChanged() {
            DropDownMenu.this.refreshWidgets();
            DropDownMenu.this.scrollBar.setValue(0.0);
            super.onTextChanged();
        }
    };
    private float maxHeightPercent = 0.5f;

    public DropDownMenu(Panel panel, List<ContextMenuItem> i) {
        super(panel);
        this.textBox.ghostText = class_2561.method_43471((String)"ftblibrary.gui.search").getString();
        boolean hasIcons = i.stream().anyMatch(item -> !item.getIcon().isEmpty());
        this.mainPanel = new MainPanel(this, i, hasIcons, this.textBox::getText);
        this.scrollBar = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, this.mainPanel);
    }

    @Override
    public boolean scrollPanel(double scroll) {
        return super.scrollPanel(scroll);
    }

    @Override
    public void addWidgets() {
        this.add(this.textBox);
        this.add(this.mainPanel);
        this.add(this.scrollBar);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        boolean pressed = super.mousePressed(button);
        if (!pressed && !this.isMouseOver()) {
            this.closeContextMenu();
            return true;
        }
        return pressed;
    }

    @Override
    public void alignWidgets() {
        this.mainPanel.setPos(0, 14);
        this.mainPanel.alignWidgets();
        this.mainPanel.setHeight(this.mainPanel.getHeight() + 14);
        this.setWidth(this.mainPanel.width + 14);
        this.setHeight(this.mainPanel.height + 14);
        this.scrollBar.setPosAndSize(this.width - 14, 12, 14, this.height - 12);
        this.textBox.setPosAndSize(0, 0, this.width, 12);
    }

    @Override
    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        theme.drawContextMenuBackground(graphics, x, y, w, h);
    }

    @Override
    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        GuiHelper.setupDrawing();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 900.0f);
        Color4I.BLACK.withAlpha(45).draw(graphics, x + 3, y + 3, w, h);
        super.draw(graphics, theme, x, y, w, h);
        graphics.method_51448().method_22909();
    }

    public void setMaxHeightPercent(float maxHeightPercent) {
        this.maxHeightPercent = maxHeightPercent;
    }

    @Override
    public ModalPanel getModalPanel() {
        return this;
    }

    public class MainPanel
    extends Panel {
        private final List<ContextMenuItem> items;
        private List<ContextButton> activeWidgets;
        private final boolean hasIcons;
        private final Supplier<String> filter;

        public MainPanel(Panel panel, List<ContextMenuItem> items, boolean hasIcons, Supplier<String> filter) {
            super(panel);
            this.items = items;
            this.hasIcons = hasIcons;
            this.filter = filter;
        }

        @Override
        public void addWidgets() {
            List<ContextButton> list = this.items.stream().filter(item -> {
                String string = item.getTitle().getString().toLowerCase();
                String lowerCase = this.filter.get().toLowerCase();
                return string.contains(lowerCase);
            }).map(item -> new ContextButton((Panel)this, (ContextMenuItem)item, this.hasIcons)).toList();
            this.activeWidgets = list;
            this.addAll(list);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void alignWidgets() {
            void var4_7;
            int totalHeight = 0;
            int maxWidth = 0;
            for (Widget widget : this.activeWidgets) {
                maxWidth = Math.max(maxWidth, widget.width);
                totalHeight += widget.height;
            }
            this.setWidth(Math.max(maxWidth + 12, 128));
            int wantedHeight = (int)Math.min((float)totalHeight, (float)this.getWindow().method_4502() * DropDownMenu.this.maxHeightPercent);
            this.setHeight(Math.max(wantedHeight, 32));
            boolean bl = false;
            while (var4_7 < this.activeWidgets.size()) {
                Widget widget = this.activeWidgets.get((int)var4_7);
                widget.setPosAndSize(0, (int)(var4_7 * 12), widget.width, widget.height);
                ++var4_7;
            }
        }
    }
}

