/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PopupMenu;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.List;
import net.minecraft.class_332;

public class ContextMenu
extends ModalPanel
implements PopupMenu {
    private static final int MARGIN = 3;
    private final List<ContextMenuItem> items;
    private final boolean hasIcons;
    private int nColumns;
    private int columnWidth;
    private int maxRows;
    private boolean drawVerticalSeparators = true;

    public ContextMenu(Panel panel, List<ContextMenuItem> i) {
        super(panel);
        this.items = i;
        this.hasIcons = this.items.stream().anyMatch(item -> !item.getIcon().isEmpty());
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setDrawVerticalSeparators(boolean drawVerticalSeparators) {
        this.drawVerticalSeparators = drawVerticalSeparators;
    }

    @Override
    public void addWidgets() {
        this.items.forEach(item -> this.add(item.createWidget(this)));
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        boolean pressed = super.mousePressed(button);
        if (!pressed && !this.isMouseOver()) {
            this.closeContextMenu();
            return true;
        }
        return pressed;
    }

    @Override
    public void alignWidgets() {
        this.setWidth(0);
        int totalHeight = 0;
        int maxWidth = 0;
        for (Widget widget : this.widgets) {
            maxWidth = Math.max(maxWidth, widget.width);
            totalHeight += widget.height + 1;
        }
        int n = this.nColumns = this.getWindow().method_4502() > 0 ? (totalHeight += 6) / this.getWindow().method_4502() + 1 : 1;
        if (this.maxRows > 0) {
            this.nColumns = Math.max(this.nColumns, (int)Math.ceil((double)this.widgets.size() / (double)this.maxRows));
        }
        int nRows = (int)Math.ceil((double)this.widgets.size() / (double)this.nColumns);
        this.columnWidth = maxWidth + 6;
        this.setWidth(this.columnWidth * this.nColumns);
        int yPos = 3;
        int prevCol = 0;
        int maxHeight = 0;
        for (int i = 0; i < this.widgets.size(); ++i) {
            int col = i / nRows;
            if (prevCol != col) {
                yPos = 3;
                prevCol = col;
            }
            Widget widget = (Widget)this.widgets.get(i);
            widget.setPosAndSize(3 + this.columnWidth * col, yPos, maxWidth, widget.height);
            maxHeight = Math.max(maxHeight, yPos + widget.height + 1);
            yPos += widget.height + 1;
        }
        this.setHeight(maxHeight + 3 - 1);
    }

    @Override
    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        theme.drawContextMenuBackground(graphics, x, y, w, h);
    }

    @Override
    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        GuiHelper.setupDrawing();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 900.0f);
        Color4I.BLACK.withAlpha(45).draw(graphics, x + 3, y + 3, w, h);
        super.draw(graphics, theme, x, y, w, h);
        if (this.drawVerticalSeparators) {
            for (int i = 1; i < this.nColumns; ++i) {
                Color4I.WHITE.withAlpha(130).draw(graphics, x + this.columnWidth * i, y + 3, 1, this.height - 6);
            }
        }
        graphics.method_51448().method_22909();
    }

    @Override
    public ModalPanel getModalPanel() {
        return this;
    }

    public boolean hasIcons() {
        return this.hasIcons;
    }

    public static class CSeparator
    extends Button {
        public CSeparator(Panel panel) {
            super(panel);
            this.setHeight(5);
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            theme.getContentColor(WidgetType.NORMAL).withAlpha(100).draw(graphics, x + 2, y + 2, this.parent.width - 10, 1);
            theme.getContentColor(WidgetType.DISABLED).withAlpha(100).draw(graphics, x + 3, y + 3, this.parent.width - 10, 1);
        }

        @Override
        public void onClicked(MouseButton button) {
        }
    }
}

