/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.google.common.primitives.Ints;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ColorSelectorPanel
extends ModalPanel {
    private static final Icon WHEEL = Icon.getIcon(FTBLibrary.rl("textures/gui/rgbcolorwheel.png"));
    private static final class_5250 ARGB = class_2561.method_43470((String)"ARGB");
    private static final class_5250 RGB = class_2561.method_43470((String)"RGB");
    private static final Map<String, List<Integer>> PRESETS = (Map)class_156.method_654(new LinkedHashMap(), ColorSelectorPanel::setupPalettes);
    private static String curPalette = "chat";
    private final ColorConfig config;
    private final ConfigCallback callback;
    private final BrightnessButton bButton;
    private final HueSaturationButton hsButton;
    private final AlphaButton aButton;
    private final RGBTextBox rgbBox;
    private final Button acceptBtn;
    private final Button cancelBtn;
    private final PaletteSelectorButton presetBtn;
    private final List<PaletteButton> paletteButtons = new ArrayList<PaletteButton>();
    private final float[] hsb = new float[3];
    private boolean allowAlphaEdit = false;

    public ColorSelectorPanel(Panel panel, ColorConfig config, ConfigCallback callback) {
        super(panel);
        this.config = config;
        this.callback = callback;
        this.setSize(224, 138);
        this.bButton = new BrightnessButton();
        this.hsButton = new HueSaturationButton();
        this.aButton = new AlphaButton();
        this.rgbBox = new RGBTextBox();
        this.presetBtn = new PaletteSelectorButton();
        this.acceptBtn = SimpleTextButton.accept(this, mb -> this.done(true), new class_2561[]{class_2561.method_43471((String)"gui.accept"), TextComponentUtils.hotkeyTooltip("\u21e7 + Enter")});
        this.cancelBtn = SimpleTextButton.cancel(this, mb -> this.done(false), new class_2561[]{class_2561.method_43471((String)"gui.cancel"), TextComponentUtils.hotkeyTooltip("ESC")});
        for (int i = 0; i < 16; ++i) {
            this.paletteButtons.add(new PaletteButton());
        }
        this.updateHSB((Color4I)config.getValue());
        this.selectPalette(curPalette);
    }

    public static ColorSelectorPanel popupAtMouse(BaseScreen gui, ColorConfig config, ConfigCallback callback) {
        ColorSelectorPanel selector = new ColorSelectorPanel(gui, config, callback);
        selector.setAllowAlphaEdit(config.isAllowAlphaEdit());
        int absX = Math.min(gui.getMouseX(), gui.getWindow().method_4486() - selector.width - 10);
        int absY = Math.min(gui.getMouseY(), gui.getWindow().method_4502() - selector.height - 10);
        selector.setPos(absX - selector.getParent().getX(), absY - selector.getParent().getY());
        gui.pushModalPanel(selector);
        return selector;
    }

    private static class_5250 getPaletteName(String palette) {
        return class_2561.method_43471((String)("ftblibrary.palette." + palette));
    }

    private static void setupPalettes(Map<String, List<Integer>> presetMap) {
        presetMap.put("chat", (List)class_156.method_654(new ArrayList(), l -> Arrays.stream(class_124.values()).filter(class_124::method_543).map(class_124::method_532).forEach(e -> l.add(e | 0xFF000000))));
        presetMap.put("dye", (List)class_156.method_654(new ArrayList(), l -> Arrays.stream(class_1767.values()).map(class_1767::method_16357).forEach(e -> l.add(e | 0xFF000000))));
        presetMap.put("nord", List.of(-13749184, -12893614, -12366754, -11774358, -2564375, -1709584, -1249292, -7357253, -7814960, -8281663, -10583636, -4234902, -3111056, -1324149, -6046068, -4944211));
        presetMap.put("reds", List.of(Integer.valueOf(-11137779), Integer.valueOf(-10743792), Integer.valueOf(-9502720), Integer.valueOf(-7077888), Integer.valueOf(-3997439), Integer.valueOf(-65536)));
        presetMap.put("greens", List.of(Integer.valueOf(-14789071), Integer.valueOf(-11757014), Integer.valueOf(-8996325), Integer.valueOf(-9913511), Integer.valueOf(-5972478), Integer.valueOf(-5447801)));
        presetMap.put("blues", List.of(Integer.valueOf(-16776961), Integer.valueOf(-16759553), Integer.valueOf(-16750849), Integer.valueOf(-13399809), Integer.valueOf(-11162881), Integer.valueOf(-8925953)));
        presetMap.put("recent", (List)class_156.method_654(new ArrayList(), l -> Arrays.stream((int[])FTBLibraryClientConfig.RECENT.get()).forEach(l::add)));
    }

    public void setAllowAlphaEdit(boolean allowAlphaEdit) {
        this.allowAlphaEdit = allowAlphaEdit;
    }

    @Override
    public void addWidgets() {
        this.addAll(List.of(this.bButton, this.hsButton, this.aButton, this.rgbBox, this.presetBtn, this.acceptBtn, this.cancelBtn));
        this.addAll(this.paletteButtons);
    }

    @Override
    public void alignWidgets() {
        this.bButton.setPosAndSize(5, 5, 16, 128);
        this.hsButton.setPosAndSize(26, 5, 96, 96);
        this.aButton.setPosAndSize(26, 106, 100, 27);
        this.rgbBox.setPosAndSize(159, 5, 60, 16);
        this.presetBtn.setPosAndSize(130, 26, 90, 16);
        this.acceptBtn.setPosAndSize(177, 113, 20, 20);
        this.cancelBtn.setPosAndSize(199, 113, 20, 20);
        for (int i = 0; i < this.paletteButtons.size(); ++i) {
            int x = i % 4;
            int y = i / 4;
            this.paletteButtons.get(i).setPosAndSize(132 + x * 12, 45 + y * 12, 10, 10);
        }
    }

    @Override
    public boolean keyPressed(Key key) {
        if (key.esc()) {
            this.done(false);
            return true;
        }
        if (key.enter() && BaseScreen.isShiftKeyDown()) {
            this.done(true);
            return true;
        }
        return super.keyPressed(key);
    }

    @Override
    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        theme.drawContextMenuBackground(graphics, x - 1, y - 1, w + 2, h + 2);
        Color4I.GRAY.withAlpha(40).draw(graphics, x + 130, y + 43, 50, 50);
    }

    @Override
    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        super.draw(graphics, theme, x, y, w, h);
        theme.drawString(graphics, this.allowAlphaEdit ? ARGB : RGB, x + 157 - theme.getStringWidth((class_5348)ARGB), y + 9);
    }

    private void done(boolean accept) {
        List l;
        if (accept && !(l = PRESETS.computeIfAbsent("recent", k -> new ArrayList())).contains(((Color4I)this.config.getValue()).rgba())) {
            l.add(((Color4I)this.config.getValue()).rgba());
            if (l.size() > 16) {
                l.removeFirst();
            }
            FTBLibraryClientConfig.RECENT.set(Ints.toArray((Collection)l));
            FTBLibraryClientConfig.save();
        }
        this.callback.save(accept);
        this.getGui().popModalPanel();
    }

    private void setColor(Color4I newColor) {
        if (this.config.setCurrentValue(newColor)) {
            this.rgbBox.setTextFromColor((Color4I)this.config.getValue());
        }
    }

    private void updateHSB(Color4I newColor) {
        Color4I.RGBtoHSB(newColor.redi(), newColor.greeni(), newColor.bluei(), this.hsb);
    }

    private void selectPalette(String paletteName) {
        if (PRESETS.containsKey(paletteName)) {
            curPalette = paletteName;
            this.presetBtn.setTitle((class_2561)ColorSelectorPanel.getPaletteName(curPalette).method_27693(" \u25bc"));
            List<Integer> cols = PRESETS.get(paletteName);
            this.paletteButtons.forEach(b -> b.setIcon(Color4I.empty()));
            for (int i = 0; i < this.paletteButtons.size() && i < cols.size(); ++i) {
                this.paletteButtons.get(i).setIcon(Color4I.rgba(cols.get(i)));
            }
        }
    }

    private class BrightnessButton
    extends SimpleButton {
        public BrightnessButton() {
            super((Panel)ColorSelectorPanel.this, (class_2561)class_2561.method_43473(), (Icon)Color4I.empty(), (SimpleButton b, MouseButton m) -> {});
        }

        @Override
        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            Color4I bg = Color4I.rgb(Color4I.HSBtoRGB(ColorSelectorPanel.this.hsb[0], ColorSelectorPanel.this.hsb[1], 1.0f));
            GuiHelper.drawGradientRect(graphics, x, y, w, h, bg, Color4I.BLACK);
            GuiHelper.drawHollowRect(graphics, x, y, w, h, Color4I.BLACK, false);
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            super.draw(graphics, theme, x, y, w, h);
            int yVal = (int)((float)y + (float)h * (1.0f - ColorSelectorPanel.this.hsb[2]));
            Color4I.BLACK.draw(graphics, x - 2, yVal, this.width + 4, 3);
            Color4I.GRAY.draw(graphics, x - 1, yVal + 1, this.width + 2, 1);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.adjustToMouseY();
        }

        @Override
        public boolean mouseDragged(int button, double dragX, double dragY) {
            if (this.isMouseOver) {
                this.adjustToMouseY();
                return true;
            }
            return false;
        }

        private void adjustToMouseY() {
            float newB;
            int yVal = this.getHeight() - 1 - (this.getMouseY() - this.getY());
            ColorSelectorPanel.this.hsb[2] = newB = class_3532.method_15363((float)((float)yVal / ((float)this.height - 1.0f)), (float)0.0f, (float)1.0f);
            ColorSelectorPanel.this.setColor(Color4I.rgb(Color4I.HSBtoRGB(ColorSelectorPanel.this.hsb[0], ColorSelectorPanel.this.hsb[1], ColorSelectorPanel.this.hsb[2])).withAlpha(((Color4I)ColorSelectorPanel.this.config.getValue()).alphai()));
        }
    }

    private class HueSaturationButton
    extends SimpleButton {
        public HueSaturationButton() {
            super((Panel)ColorSelectorPanel.this, (class_2561)class_2561.method_43473(), (Icon)Color4I.empty(), (SimpleButton b, MouseButton m) -> {});
        }

        private static double flippedAtan2(double y, double x) {
            double angle = Math.atan2(y, x);
            double flippedAngle = 1.5707963267948966 - angle;
            return flippedAngle >= 0.0 ? flippedAngle : flippedAngle + Math.PI * 2;
        }

        @Override
        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            WHEEL.draw(graphics, x, y, w, h);
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            super.draw(graphics, theme, x, y, w, h);
            int xc = this.getWidth() / 2;
            int yc = this.getHeight() / 2;
            double rad = 1.5707963267948966 - (double)ColorSelectorPanel.this.hsb[0] * Math.PI * 2.0;
            int dx = (int)((double)xc + (double)((float)xc * ColorSelectorPanel.this.hsb[1]) * Math.cos(rad));
            int dy = (int)((double)yc - (double)((float)yc * ColorSelectorPanel.this.hsb[1]) * Math.sin(rad));
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
            Color4I.BLACK.draw(graphics, dx - 1, dy - 5, 3, 11);
            Color4I.BLACK.draw(graphics, dx - 5, dy - 1, 11, 3);
            Color4I.GRAY.draw(graphics, dx, dy - 4, 1, 9);
            Color4I.GRAY.draw(graphics, dx - 4, dy, 9, 1);
            graphics.method_51448().method_22909();
        }

        @Override
        public void onClicked(MouseButton button) {
            this.adjustToMouseXY();
        }

        private boolean adjustToMouseXY() {
            int yVal;
            int dy;
            int xc = this.getWidth() / 2;
            int yc = this.getHeight() / 2;
            int xVal = this.getMouseX() - this.getX();
            int dx = xVal - xc;
            int dSq = dx * dx + (dy = (yVal = this.getHeight() - 1 - (this.getMouseY() - this.getY())) - yc) * dy;
            if (dSq < xc * xc) {
                double a = HueSaturationButton.flippedAtan2(dy, dx);
                ColorSelectorPanel.this.hsb[0] = (float)(a / (Math.PI * 2));
                ColorSelectorPanel.this.hsb[1] = (float)Math.sqrt((float)dSq / (float)(xc * xc));
                ColorSelectorPanel.this.setColor(Color4I.rgb(Color4I.HSBtoRGB(ColorSelectorPanel.this.hsb[0], ColorSelectorPanel.this.hsb[1], ColorSelectorPanel.this.hsb[2])).withAlpha(((Color4I)ColorSelectorPanel.this.config.getValue()).alphai()));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseDragged(int button, double dragX, double dragY) {
            return this.adjustToMouseXY();
        }
    }

    private class AlphaButton
    extends SimpleButton {
        public AlphaButton() {
            super((Panel)ColorSelectorPanel.this, (class_2561)class_2561.method_43473(), (Icon)Color4I.empty(), (SimpleButton b, MouseButton m) -> {});
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            GuiHelper.drawHollowRect(graphics, x, y, w, h, Color4I.BLACK, false);
            if (ColorSelectorPanel.this.allowAlphaEdit) {
                if (((Color4I)ColorSelectorPanel.this.config.getValue()).alphai() < 255) {
                    GuiHelper.pushScissor(this.getWindow(), x, y, w, h);
                    for (int i = 0; i < w; i += 10) {
                        for (int j = 0; j < h; j += 10) {
                            Color4I c = (i + j) / 10 % 2 == 0 ? Color4I.WHITE : Color4I.GRAY;
                            c.draw(graphics, x + i, y + j, 10, 10);
                        }
                    }
                    GuiHelper.popScissor(this.getWindow());
                }
                ((Color4I)ColorSelectorPanel.this.config.getValue()).draw(graphics, x, y, w, h);
                int xVal = x + (w - 1) * ((Color4I)ColorSelectorPanel.this.config.getValue()).alphai() / 255;
                Color4I.BLACK.draw(graphics, xVal, y - 2, 3, this.height + 4);
                Color4I.GRAY.draw(graphics, xVal + 1, y - 1, 1, this.height + 2);
            } else {
                ((Color4I)ColorSelectorPanel.this.config.getValue()).draw(graphics, x, y, w, h);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            if (ColorSelectorPanel.this.allowAlphaEdit) {
                this.adjustToMouseX();
            }
        }

        @Override
        public boolean mouseDragged(int button, double dragX, double dragY) {
            if (ColorSelectorPanel.this.allowAlphaEdit && this.isMouseOver()) {
                this.adjustToMouseX();
                return true;
            }
            return false;
        }

        private void adjustToMouseX() {
            int xVal = this.getWidth() - 1 - (this.getMouseX() - this.getX());
            int newA = 255 - class_3532.method_15340((int)(xVal * 255 / this.getWidth()), (int)0, (int)255);
            ColorSelectorPanel.this.setColor(Color4I.rgb(Color4I.HSBtoRGB(ColorSelectorPanel.this.hsb[0], ColorSelectorPanel.this.hsb[1], ColorSelectorPanel.this.hsb[2])).withAlpha(newA));
        }
    }

    private class RGBTextBox
    extends TextBox {
        private static final Pattern HEX = Pattern.compile("^[0-9a-fA-F]{1,8}$");

        public RGBTextBox() {
            super(ColorSelectorPanel.this);
            this.setTextFromColor((Color4I)ColorSelectorPanel.this.config.getValue());
            this.setFilter(s -> {
                if (s.isEmpty()) {
                    return true;
                }
                if (s.startsWith("#")) {
                    s = s.substring(1);
                }
                return s.isEmpty() || HEX.matcher((CharSequence)s).matches();
            });
        }

        private void setTextFromColor(Color4I color) {
            if (ColorSelectorPanel.this.allowAlphaEdit) {
                this.setText(String.format("#%08x", color.rgba()));
            } else {
                this.setText(String.format("#%06x", color.rgb()));
            }
        }

        @Override
        public void onEnterPressed() {
            Object s = this.getText();
            if (((String)s).startsWith("#")) {
                s = ((String)s).substring(1);
            }
            if (((String)s).length() == 6 || !ColorSelectorPanel.this.allowAlphaEdit) {
                s = "FF" + (String)s;
            }
            try {
                int col = Integer.parseUnsignedInt((String)s, 16);
                ColorSelectorPanel.this.setColor(ColorSelectorPanel.this.allowAlphaEdit ? Color4I.rgba(col) : Color4I.rgb(col));
                ColorSelectorPanel.this.updateHSB((Color4I)ColorSelectorPanel.this.config.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class PaletteSelectorButton
    extends SimpleTextButton {
        public PaletteSelectorButton() {
            super(ColorSelectorPanel.this, (class_2561)ColorSelectorPanel.getPaletteName(curPalette).method_27693(" \u25bc"), Color4I.empty());
        }

        @Override
        public void onClicked(MouseButton button) {
            ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
            PRESETS.forEach((k, v) -> items.add(new ContextMenuItem((class_2561)ColorSelectorPanel.getPaletteName(k), Color4I.empty(), b -> ColorSelectorPanel.this.selectPalette((String)k))));
            this.getGui().openContextMenu(items);
        }
    }

    private class PaletteButton
    extends SimpleButton {
        public PaletteButton() {
            super((Panel)ColorSelectorPanel.this, (class_2561)class_2561.method_43473(), (Icon)Color4I.empty(), (SimpleButton b, MouseButton mb) -> ((PaletteButton)b).applyColor());
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            Color4I col;
            Icon icon = this.icon;
            if (icon instanceof Color4I && !(col = (Color4I)icon).isEmpty()) {
                col.draw(graphics, x, y, w, h);
                Color4I shade = col.addBrightness(-0.15f);
                shade.draw(graphics, x, y + h - 1, w, 1);
                shade.draw(graphics, x + w - 1, y, 1, h);
            }
        }

        private void applyColor() {
            Color4I col;
            Icon icon = this.icon;
            if (icon instanceof Color4I && !(col = (Color4I)icon).isEmpty()) {
                ColorSelectorPanel.this.setColor(col);
                ColorSelectorPanel.this.updateHSB(col);
            }
        }
    }
}

