/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.nbtedit;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

public enum NBTEditResponseHandlers {
    INSTANCE;

    public static final String ITEM = "item";
    public static final String BLOCK = "block";
    public static final String PLAYER = "player";
    public static final String ENTITY = "entity";
    private final Map<String, NBTResponseHandler> MAP = new ConcurrentHashMap<String, NBTResponseHandler>();

    public static void registerBuiltinHandlers() {
        INSTANCE.registerHandler(ITEM, (player, info, data) -> class_1799.method_57360((class_7225.class_7874)player.method_56673(), (class_2520)data).ifPresent(stack -> player.method_6122(class_1268.field_5808, stack)));
        INSTANCE.registerHandler(BLOCK, (player, info, data) -> class_2512.method_10691((class_2487)info, (String)"pos").ifPresent(pos -> {
            class_2586 blockEntity;
            if (player.method_37908().method_8477(pos) && (blockEntity = player.method_37908().method_8321(pos)) != null) {
                data.method_10569("x", pos.method_10263());
                data.method_10569("y", pos.method_10264());
                data.method_10569("z", pos.method_10260());
                data.method_10582("id", info.method_10558("id"));
                blockEntity.method_58690(data, (class_7225.class_7874)player.method_37908().method_30349());
                blockEntity.method_5431();
                player.method_37908().method_8413(pos, blockEntity.method_11010(), blockEntity.method_11010(), 3);
            }
        }));
        INSTANCE.registerHandler(PLAYER, (player, info, data) -> {
            class_3222 targetPlayer;
            if (player.method_5682() != null && (targetPlayer = player.method_5682().method_3760().method_14602(info.method_25926("id"))) != null) {
                UUID uuid = targetPlayer.method_5667();
                targetPlayer.method_5651(data);
                targetPlayer.method_5826(uuid);
                targetPlayer.method_24203(targetPlayer.method_23317(), targetPlayer.method_23318(), targetPlayer.method_23321());
            }
        });
        INSTANCE.registerHandler(ENTITY, (player, info, data) -> {
            class_1297 entity = player.method_37908().method_8469(info.method_10550("id"));
            if (entity != null) {
                UUID uuid = entity.method_5667();
                entity.method_5651(data);
                entity.method_5826(uuid);
            }
        });
    }

    public void registerHandler(String name, NBTResponseHandler handler) {
        this.MAP.put(name, handler);
    }

    public void handleResponse(String name, class_3222 player, class_2487 info, class_2487 data) {
        this.MAP.getOrDefault(name, NBTResponseHandler.NONE).handleResponse(player, info, data);
    }

    @FunctionalInterface
    public static interface NBTResponseHandler {
        public static final NBTResponseHandler NONE = (player, info, data) -> {};

        public void handleResponse(class_3222 var1, class_2487 var2, class_2487 var3);
    }
}

