/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.net.EditConfigPacket;
import dev.ftb.mods.ftblibrary.net.EditNBTPacket;
import dev.ftb.mods.ftblibrary.ui.misc.UITesting;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;

public class FTBLibraryCommands {
    public static final Map<UUID, class_2487> EDITING_NBT = new HashMap<UUID, class_2487>();

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 ignoredCtx, class_2170.class_5364 ignoredType) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ftblibrary").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"gamemode").requires(commandSource -> commandSource.method_9259(2))).executes(context -> {
            if (!((class_2168)context.getSource()).method_9207().method_7337()) {
                ((class_2168)context.getSource()).method_9207().method_7336(class_1934.field_9220);
            } else {
                ((class_2168)context.getSource()).method_9207().method_7336(class_1934.field_9215);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rain").requires(commandSource -> commandSource.method_9259(2))).executes(context -> {
            if (((class_2168)context.getSource()).method_9211().method_30002().method_8419()) {
                ((class_2168)context.getSource()).method_9211().method_30002().method_27910(6000, 0, false, false);
            } else {
                ((class_2168)context.getSource()).method_9211().method_30002().method_27910(0, 6000, true, false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"day").requires(commandSource -> commandSource.method_9259(2))).executes(context -> {
            for (class_3218 world : ((class_2168)context.getSource()).method_9211().method_3738()) {
                world.method_29199(6000L);
            }
            ((class_2168)context.getSource()).method_9211().method_49749();
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"night").requires(commandSource -> commandSource.method_9259(2))).executes(context -> {
            for (class_3218 world : ((class_2168)context.getSource()).method_9211().method_3738()) {
                world.method_29199(18000L);
            }
            ((class_2168)context.getSource()).method_9211().method_49749();
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nbtedit").requires(commandSource -> commandSource.method_9259(2))).then(class_2170.method_9247((String)"block").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<class_2168>)context, (info, tag) -> FTBLibraryCommands.editBlockNBT((CommandContext<class_2168>)context, info, tag)))))).then(class_2170.method_9247((String)"entity").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<class_2168>)context, (info, tag) -> FTBLibraryCommands.editEntityNBT((CommandContext<class_2168>)context, info, tag)))))).then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<class_2168>)context, (info, tag) -> FTBLibraryCommands.editPlayerNBT((CommandContext<class_2168>)context, info, tag)))))).then(class_2170.method_9247((String)"item").executes(context -> FTBLibraryCommands.editNBT((CommandContext<class_2168>)context, (info, tag) -> FTBLibraryCommands.editItemNBT((CommandContext<class_2168>)context, info, tag)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clientconfig").requires(class_2168::method_43737)).executes(context -> {
            NetworkManager.sendToPlayer((class_3222)((class_2168)context.getSource()).method_9207(), (class_8710)new EditConfigPacket("ftblibrary-client"));
            return 1;
        }));
        if (ModUtils.isDevMode()) {
            command.then(class_2170.method_9247((String)"test_screen").executes(context -> {
                if (((class_2168)context.getSource()).method_9211().method_3816()) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Can't do this on dedicated server!").method_27692(class_124.field_1061));
                } else {
                    UITesting.openTestScreen();
                }
                return 1;
            }));
            command.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"serverconfig").requires(cs -> cs.method_9259(2))).executes(context -> {
                NetworkManager.sendToPlayer((class_3222)((class_2168)context.getSource()).method_9207(), (class_8710)new EditConfigPacket("ftblibrary-server"));
                return 1;
            }));
        }
        dispatcher.register(command);
    }

    private static int editNBT(CommandContext<class_2168> context, NBTEditCallback data) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_2487 info = new class_2487();
        class_2487 tag = new class_2487();
        data.accept(info, tag);
        if (!info.method_33133()) {
            EDITING_NBT.put(player.method_5667(), info);
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new EditNBTPacket(info, tag));
            return 1;
        }
        return 0;
    }

    private static void editItemNBT(CommandContext<class_2168> context, class_2487 info, class_2487 tag) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        if (player.method_6047().method_7960()) {
            return;
        }
        info.method_10582("type", "item");
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_2960 key = RegistrarManager.getId((Object)stack.method_7909(), (class_5321)class_7924.field_41197);
        info.method_10566("text", (class_2520)InfoBuilder.create(context).add("Class", (class_2561)class_2561.method_43470((String)stack.method_7909().getClass().getName())).add("ID", (class_2561)class_2561.method_43470((String)(key == null ? "null" : key.toString()))).add("Mod", (class_2561)class_2561.method_43470((String)(key == null ? "null" : Platform.getOptionalMod((String)key.method_12836()).map(Mod::getName).orElse("Unknown")))).build());
        class_2520 res = stack.method_57376((class_7225.class_7874)player.method_37908().method_30349(), (class_2520)tag);
        if (res instanceof class_2487) {
            class_2487 t = (class_2487)res;
            tag.method_10543(t);
        }
    }

    private static void editPlayerNBT(CommandContext<class_2168> context, class_2487 info, class_2487 tag) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        info.method_10582("type", "player");
        info.method_25927("id", player.method_5667());
        player.method_5647(tag);
        tag.method_10551("id");
        info.method_10566("text", (class_2520)InfoBuilder.create(context).add("Name", player.method_5477()).add("Display Name", player.method_5476()).add("UUID", (class_2561)class_2561.method_43470((String)player.method_5667().toString())).build());
        info.method_10582("title", class_2561.class_2562.method_10867((class_2561)player.method_5476(), (class_7225.class_7874)player.method_37908().method_30349()));
    }

    private static void editEntityNBT(CommandContext<class_2168> context, class_2487 info, class_2487 tag) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, (String)"entity");
        if (entity instanceof class_1657) {
            return;
        }
        info.method_10582("type", "entity");
        info.method_10569("id", entity.method_5628());
        entity.method_5662(tag);
        class_2960 key = RegistrarManager.getId((Object)entity.method_5864(), (class_5321)class_7924.field_41266);
        info.method_10566("text", (class_2520)InfoBuilder.create(context).add("Class", (class_2561)class_2561.method_43470((String)entity.getClass().getName())).add("ID", (class_2561)class_2561.method_43470((String)(key == null ? "null" : key.toString()))).add("Mod", (class_2561)class_2561.method_43470((String)(key == null ? "null" : Platform.getOptionalMod((String)key.method_12836()).map(Mod::getName).orElse("Unknown")))).build());
        info.method_10582("title", class_2561.class_2562.method_10867((class_2561)entity.method_5476(), (class_7225.class_7874)entity.method_37908().method_30349()));
    }

    private static void editBlockNBT(CommandContext<class_2168> context, class_2487 info, class_2487 tag) throws CommandSyntaxException {
        class_5250 class_52502;
        class_2338 pos = class_2262.method_9697(context, (String)"pos");
        class_2680 blockState = ((class_2168)context.getSource()).method_9225().method_8320(pos);
        class_2586 blockEntity = ((class_2168)context.getSource()).method_9225().method_8321(pos);
        if (blockEntity == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Not a block entity: ").method_27693(blockState.method_26204().toString()).method_27692(class_124.field_1061));
            return;
        }
        info.method_10582("type", "block");
        info.method_10566("pos", class_2512.method_10692((class_2338)pos));
        tag.method_10543(blockEntity.method_38242((class_7225.class_7874)((class_2168)context.getSource()).method_9225().method_30349()));
        tag.method_10551("x");
        tag.method_10551("y");
        tag.method_10551("z");
        info.method_10582("id", tag.method_10558("id"));
        tag.method_10551("id");
        class_2960 key = RegistrarManager.getId((Object)blockEntity.method_11017(), (class_5321)class_7924.field_41255);
        info.method_10566("text", (class_2520)InfoBuilder.create(context).add("Class", (class_2561)class_2561.method_43470((String)blockEntity.getClass().getName())).add("ID", (class_2561)class_2561.method_43470((String)(key == null ? "null" : key.toString()))).add("Block", (class_2561)class_2561.method_43470((String)String.valueOf(RegistrarManager.getId((Object)blockEntity.method_11010().method_26204(), (class_5321)class_7924.field_41254)))).add("Block Class", (class_2561)class_2561.method_43470((String)blockEntity.method_11010().method_26204().getClass().getName())).add("Position", (class_2561)class_2561.method_43470((String)("[" + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + "]"))).add("Mod", (class_2561)class_2561.method_43470((String)(key == null ? "null" : Platform.getOptionalMod((String)key.method_12836()).map(Mod::getName).orElse("Unknown")))).add("Ticking", (class_2561)class_2561.method_43470((String)(FTBLibraryCommands.isTicking(blockEntity) ? "true" : "false"))).build());
        if (blockEntity instanceof class_1275) {
            class_1275 n = (class_1275)blockEntity;
            class_52502 = n.method_5476();
        } else {
            class_52502 = class_2561.method_43470((String)blockEntity.getClass().getSimpleName());
        }
        class_5250 title = class_52502;
        info.method_10582("title", class_2561.class_2562.method_10867((class_2561)title, (class_7225.class_7874)((class_2168)context.getSource()).method_30497()));
    }

    private static boolean isTicking(class_2586 be) {
        class_2343 eb;
        class_2248 class_22482 = be.method_11010().method_26204();
        return class_22482 instanceof class_2343 && (eb = (class_2343)class_22482).method_31645(be.method_10997(), be.method_11010(), be.method_11017()) != null;
    }

    private static interface NBTEditCallback {
        public void accept(class_2487 var1, class_2487 var2) throws CommandSyntaxException;
    }

    public record InfoBuilder(class_2499 list, class_7225.class_7874 provider) {
        public static InfoBuilder create(CommandContext<class_2168> context) {
            return new InfoBuilder(new class_2499(), (class_7225.class_7874)((class_2168)context.getSource()).method_30497());
        }

        public InfoBuilder add(String key, class_2561 value) {
            return this.add((class_2561)class_2561.method_43470((String)key), value);
        }

        public InfoBuilder add(class_2561 key, class_2561 value) {
            this.list.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)key.method_27661().method_27692(class_124.field_1078).method_27693(": ").method_10852((class_2561)value.method_27661().method_27692(class_124.field_1065)), (class_7225.class_7874)this.provider)));
            return this;
        }

        public class_2499 build() {
            return this.list;
        }
    }
}

