/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.init;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.client.init.v1.ItemModelDisplayOverrides;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import net.minecraft.class_811;

public abstract class ItemDisplayOverridesImpl<T>
implements ItemModelDisplayOverrides {
    private final Map<class_1091, Map<class_811, Function<BakedModelResolver, class_1087>>> overrideLocations = new HashMap<class_1091, Map<class_811, Function<BakedModelResolver, class_1087>>>();

    protected ItemDisplayOverridesImpl() {
        this.registerEventHandlers();
    }

    @Override
    public void register(class_1091 itemModel, class_1091 itemModelOverride) {
        this.register(itemModel, itemModelOverride, ItemDisplayOverridesImpl.getVanillaItemModelDisplayOverrides());
    }

    @Override
    public void register(class_1091 itemModel, class_2960 itemModelOverride) {
        this.register(itemModel, itemModelOverride, ItemDisplayOverridesImpl.getVanillaItemModelDisplayOverrides());
    }

    static class_811[] getVanillaItemModelDisplayOverrides() {
        return (class_811[])EnumSet.complementOf(Sets.newEnumSet(Arrays.asList(class_811.field_4317, class_811.field_4318, class_811.field_4319), class_811.class)).toArray(class_811[]::new);
    }

    protected void register(class_1091 modelResourceLocation, Function<BakedModelResolver, class_1087> bakedModelGetter, class_811[] itemDisplayContexts) {
        Objects.requireNonNull(modelResourceLocation, "item model is null");
        Preconditions.checkState((itemDisplayContexts.length > 0 ? 1 : 0) != 0, (Object)"item display contexts is empty");
        Map overrides = this.overrideLocations.computeIfAbsent(modelResourceLocation, $ -> new EnumMap(class_811.class));
        for (class_811 itemDisplayContext : itemDisplayContexts) {
            if (overrides.put(itemDisplayContext, bakedModelGetter) == null) continue;
            throw new IllegalStateException("Attempting to register duplicate item model display override for model %s and display context %s".formatted(modelResourceLocation, itemDisplayContext));
        }
    }

    protected Map<T, Map<class_811, class_1087>> computeOverrideModels(BakedModelResolver modelResolver, class_1087 missingModel) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<class_1091, Map<class_811, Function<BakedModelResolver, class_1087>>> overrideEntry : this.overrideLocations.entrySet()) {
            class_1087 itemModel = modelResolver.getModel(overrideEntry.getKey());
            Preconditions.checkState((itemModel != missingModel ? 1 : 0) != 0, (Object)"item model is missing");
            ImmutableMap.Builder overrideBuilder = ImmutableMap.builder();
            for (Map.Entry<class_811, Function<BakedModelResolver, class_1087>> entry : overrideEntry.getValue().entrySet()) {
                class_1087 overrideModel = (class_1087)entry.getValue().apply((Object)modelResolver);
                Preconditions.checkState((overrideModel != missingModel ? 1 : 0) != 0, (Object)"override model is missing");
                overrideBuilder.put((Object)entry.getKey(), (Object)overrideModel);
            }
            T overrideModelKey = this.createOverrideModelKey(overrideEntry.getKey(), itemModel);
            builder.put(overrideModelKey, (Object)overrideBuilder.build());
        }
        return builder.build();
    }

    protected abstract T createOverrideModelKey(class_1091 var1, class_1087 var2);

    protected abstract void registerEventHandlers();

    protected static interface BakedModelResolver {
        public class_1087 getModel(class_1091 var1);

        public class_1087 getModel(class_2960 var1);
    }
}

