/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.network;

import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import fuzs.puzzleslib.api.network.v3.MessageV3;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import fuzs.puzzleslib.fabric.impl.core.FabricProxy;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistryImpl;
import fuzs.puzzleslib.impl.network.codec.CustomPacketPayloadAdapter;
import fuzs.puzzleslib.impl.network.codec.StreamCodecRegistryImpl;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8705;
import net.minecraft.class_8706;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9141;

public class FabricNetworkHandler
extends NetworkHandlerRegistryImpl {
    private boolean building = true;

    public FabricNetworkHandler(class_2960 channelName) {
        super(channelName);
    }

    @Override
    public <T extends Record> void registerClientbound$Internal(Class<?> clazz) {
        this.register(clazz, (PayloadTypeRegistry<class_9129>)PayloadTypeRegistry.playS2C(), (type, disconnectExceptionally) -> ((FabricProxy)Proxy.INSTANCE).registerClientReceiver(type, (BiConsumer<Throwable, Consumer<class_2561>>)disconnectExceptionally, rec$ -> (Record)((MessageV3)rec$).unwrap()));
    }

    @Override
    public <T extends Record> void registerServerbound$Internal(Class<?> clazz) {
        this.register(clazz, (PayloadTypeRegistry<class_9129>)PayloadTypeRegistry.playC2S(), (type, disconnectExceptionally) -> ((FabricProxy)Proxy.INSTANCE).registerServerReceiver(type, (BiConsumer<Throwable, Consumer<class_2561>>)disconnectExceptionally, rec$ -> (Record)((MessageV3)rec$).unwrap()));
    }

    @Override
    protected <T extends MessageV2<T>> void registerLegacyClientbound$Internal(Class<?> clazz, class_9141<class_2540, ?> factory) {
        this.registerLegacy(clazz, factory, (PayloadTypeRegistry<class_9129>)PayloadTypeRegistry.playS2C(), (type, disconnectExceptionally) -> ((FabricProxy)Proxy.INSTANCE).registerClientReceiver(type, (BiConsumer<Throwable, Consumer<class_2561>>)disconnectExceptionally, MessageV2::toClientboundMessage));
    }

    @Override
    protected <T extends MessageV2<T>> void registerLegacyServerbound$Internal(Class<?> clazz, class_9141<class_2540, ?> factory) {
        this.registerLegacy(clazz, factory, (PayloadTypeRegistry<class_9129>)PayloadTypeRegistry.playC2S(), (type, disconnectExceptionally) -> ((FabricProxy)Proxy.INSTANCE).registerServerReceiver(type, (BiConsumer<Throwable, Consumer<class_2561>>)disconnectExceptionally, MessageV2::toServerboundMessage));
    }

    private <T extends MessageV2<T>> void registerLegacy(Class<T> clazz, class_9141<class_2540, T> factory, PayloadTypeRegistry<class_9129> registry, BiConsumer<class_8710.class_9154<CustomPacketPayloadAdapter<T>>, BiConsumer<Throwable, Consumer<class_2561>>> receiverRegistrar) {
        this.registerSerializer(clazz, (buf, message) -> message.write((class_2540)buf), factory);
        this.register(clazz, registry, receiverRegistrar);
    }

    private <T> void register(Class<T> clazz, PayloadTypeRegistry<class_9129> registry, BiConsumer<class_8710.class_9154<CustomPacketPayloadAdapter<T>>, BiConsumer<Throwable, Consumer<class_2561>>> receiverRegistrar) {
        if (this.building) {
            throw new IllegalStateException("channel is null");
        }
        class_8710.class_9154<CustomPacketPayloadAdapter<T>> type = this.registerMessageType(clazz);
        class_9139 streamCodec = CustomPacketPayloadAdapter.streamCodec(type, StreamCodecRegistryImpl.fromType(clazz));
        registry.register(type, streamCodec);
        receiverRegistrar.accept(type, this.disconnectExceptionally(clazz));
    }

    @Override
    public <T> class_2596<class_8705> toClientboundPacket(ClientboundMessage<T> message) {
        if (this.building) {
            throw new IllegalStateException("channel is null");
        }
        Objects.requireNonNull(message, "message is null");
        return this.toPacket(ServerPlayNetworking::createS2CPacket, message);
    }

    @Override
    public <T> class_2596<class_8706> toServerboundPacket(ServerboundMessage<T> message) {
        if (this.building) {
            throw new IllegalStateException("channel is null");
        }
        Objects.requireNonNull(message, "message is null");
        return this.toPacket(ClientPlayNetworking::createC2SPacket, message);
    }

    @Override
    public void build() {
        this.building = false;
        super.build();
    }
}

