/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.config.ServerConfig;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.network.handler.validate.PayloadResult;
import dev.terminalmc.clientsort.platform.services.PlatformServices;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public abstract class PayloadHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processPayload(MinecraftServer server, class_3222 player, int containerId, ThrowingConsumer<class_1703> contextValidator, ThrowingConsumer<class_1703> schemaValidator, ThrowingConsumer<class_1703> operator, class_8710.class_9154<?> payloadType, class_8710.class_9154<?> responseType, BiFunction<PayloadResult, String, class_8710> responseProvider) {
        class_1703 menu = null;
        PayloadResult result = PayloadResult.SUCCESS;
        String message = "";
        try {
            menu = PayloadHandler.getMenu(player, containerId);
            menu.method_34256();
            contextValidator.accept(menu);
            schemaValidator.accept(menu);
            operator.accept(menu);
        }
        catch (Exception e) {
            if (e instanceof PayloadHandlerException) {
                PayloadHandlerException ex = (PayloadHandlerException)e;
                result = ex.result;
                message = ex.getMessage();
            } else {
                result = PayloadResult.FAILURE;
                message = PayloadHandlerException.GENERIC_MESSAGE;
                ClientSort.LOG.error("Encountered an unexpected exception while handling payload '{}' from player '{}': {}", payloadType.comp_2242(), player, e);
            }
        }
        finally {
            if (menu != null) {
                menu.method_34257();
                menu.method_7623();
            }
            if (PlatformServices.getInstance().canSendToPlayer(player, responseType)) {
                PlatformServices.getInstance().sendToPlayer(player, responseProvider.apply(result, message));
            }
        }
    }

    public static void validate(MinecraftServer server, class_1799 expected, class_1799 actual, Supplier<String> message, Consumer<String> policySetter) throws PayloadHandlerException.InconsistentStateException {
        boolean invalid = false;
        boolean log = false;
        boolean error = false;
        if (ServerConfig.serverOptions().alwaysLogUnexpectedResults) {
            log = true;
        }
        if (server.method_3816() && ServerConfig.serverOptions().validationActiveServer) {
            log = true;
            error = true;
        }
        if (!(!log && !ServerConfig.serverOptions().validateItemType || expected.method_7960() || actual.method_7960() || class_1799.method_31577((class_1799)expected, (class_1799)actual))) {
            invalid = true;
        }
        if (log || ServerConfig.serverOptions().validateStackSize) {
            int sizeDifference;
            int n = sizeDifference = expected.method_7947() > actual.method_7947() ? expected.method_7947() - actual.method_7947() : actual.method_7947() - expected.method_7947();
            if (sizeDifference > 0 && sizeDifference >= ServerConfig.serverOptions().validateStackSizeThreshold) {
                invalid = true;
            }
        }
        if (invalid && log) {
            String msg = String.format("%s: Expected '%s' in destination after set, got '%s'!", message.get(), expected, actual);
            if (!error) {
                ClientSort.LOG.warn(msg, new Object[0]);
            } else {
                ClientSort.LOG.error(msg, new Object[0]);
                policySetter.accept(msg);
                throw new PayloadHandlerException.InconsistentStateException(msg);
            }
        }
    }

    @NotNull
    private static class_1703 getMenu(class_3222 player, int containerId) throws PayloadHandlerException.InvalidDataException {
        class_1723 menu;
        if (containerId == player.field_7498.field_7763) {
            menu = player.field_7498;
        } else if (containerId == player.field_7512.field_7763) {
            menu = player.field_7512;
        } else {
            throw new PayloadHandlerException.InvalidDataException(String.format("Container ID '%d' does not match player inventory or container!", containerId));
        }
        if (!menu.method_7597((class_1657)player)) {
            throw new PayloadHandlerException.InvalidDataException(String.format("Container ID '%d' is not valid for the player!", containerId));
        }
        return menu;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

