/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.network;

import com.google.common.base.Preconditions;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.common.CritRecord;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.mehvahdjukaar.dummmmmmy.configs.ClientConfigs;
import net.mehvahdjukaar.dummmmmmy.configs.CritMode;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public record ClientBoundDamageNumberMessage(int entityID, float damageAmount, class_6880<class_8110> damageType, boolean isCrit, float critMult) implements Message
{
    public static final class_8710.class_9155<class_9129, ClientBoundDamageNumberMessage> TYPE = Message.makeType((class_2960)Dummmmmmy.res("s2c_damage_number"), ClientBoundDamageNumberMessage::of);

    public ClientBoundDamageNumberMessage(int id, float damage, @Nullable class_1282 source, @Nullable CritRecord critical, class_1937 level) {
        this(id, damage, ClientBoundDamageNumberMessage.encodeDamage(source, level), critical != null, critical == null ? 0.0f : critical.getMultiplier());
    }

    public static ClientBoundDamageNumberMessage of(class_9129 buf) {
        int entityID = buf.readInt();
        float damageAmount = buf.readFloat();
        class_6880 damageType = (class_6880)class_8110.field_51932.decode((Object)buf);
        boolean isCrit = buf.readBoolean();
        float critMult = isCrit ? buf.readFloat() : 0.0f;
        return new ClientBoundDamageNumberMessage(entityID, damageAmount, (class_6880<class_8110>)damageType, isCrit, critMult);
    }

    public static class_6880<class_8110> encodeDamage(@Nullable class_1282 source, class_1937 level) {
        if (source == null) {
            return Dummmmmmy.TRUE_DAMAGE.getHolder(level);
        }
        class_6880 damageType = source.method_48793();
        return (class_6880)Preconditions.checkNotNull((Object)damageType);
    }

    public void write(class_9129 buf) {
        buf.method_53002(this.entityID);
        buf.method_52941(this.damageAmount);
        class_8110.field_51932.encode((Object)buf, this.damageType);
        buf.method_52964(this.isCrit);
        if (this.isCrit) {
            buf.method_52941(this.critMult);
        }
    }

    public void handle(Message.Context context) {
        class_1297 entity = class_310.method_1551().field_1687.method_8469(this.entityID);
        if (entity instanceof TargetDummyEntity) {
            TargetDummyEntity dummy = (TargetDummyEntity)entity;
            if (ClientConfigs.DAMAGE_NUMBERS.get().booleanValue()) {
                int i = dummy.getNextNumberPos();
                this.spawnNumber(entity, i);
            }
            if (ClientConfigs.HAY_PARTICLES.get().booleanValue()) {
                this.spawnHay(entity);
            }
        } else if (entity != null) {
            this.spawnNumber(entity, 0);
        }
    }

    private void spawnHay(class_1297 entity) {
        class_5819 random = entity.method_59922();
        int amount = (int)(1.0f + class_3532.method_37959((float)this.damageAmount, (float)0.0f, (float)40.0f, (float)0.0f, (float)10.0f));
        amount = Math.min(amount, 10);
        for (int i = 0; i < amount; ++i) {
            class_243 pos = new class_243(entity.method_23322(0.5), entity.method_23318() + 0.75 + (double)random.method_43057() * 0.85, entity.method_23325(0.5));
            class_243 speed = ClientBoundDamageNumberMessage.getOutwardSpeed(pos.method_1020(entity.method_19538()), random);
            entity.method_37908().method_8406((class_2394)Dummmmmmy.HAY_PARTICLE.get(), pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, (double)random.method_43057() * 0.04, speed.field_1350);
        }
    }

    public static class_243 getOutwardSpeed(class_243 position, class_5819 random) {
        class_243 direction = position.method_1029();
        float randomLen = 0.02f + random.method_43057() * 0.04f;
        float angleVariation = (float)(random.method_43059() * (double)0.3f);
        float sin = class_3532.method_15374((float)angleVariation);
        float cos = class_3532.method_15362((float)angleVariation);
        double newX = direction.field_1352 * (double)cos - direction.field_1350 * (double)sin;
        double newY = direction.field_1352 * (double)sin + direction.field_1350 * (double)cos;
        return new class_243(newX * (double)randomLen, 0.0, newY * (double)randomLen);
    }

    private void spawnNumber(class_1297 entity, int animationPos) {
        class_6880 type = this.damageType;
        float mult = 0.0f;
        CritMode critMode = ClientConfigs.CRIT_MODE.get();
        if (critMode != CritMode.OFF && this.isCrit) {
            type = Dummmmmmy.CRITICAL_DAMAGE.getHolder(entity);
            mult = this.critMult;
        }
        double z = CritMode.encodeIntFloatToDouble(animationPos, mult);
        int color = ClientConfigs.getDamageColor(type);
        entity.method_37908().method_8406((class_2394)Dummmmmmy.NUMBER_PARTICLE.get(), entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), (double)this.damageAmount, (double)color, z);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE.comp_2243();
    }
}

