/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.model;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import mod.azure.azurelibarmor.common.cache.object.GeoCube;
import mod.azure.azurelibarmor.common.model.AzBoneMetadata;
import mod.azure.azurelibarmor.common.model.AzBoneSnapshot;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class AzBone {
    private final AzBoneMetadata metadata;
    private final List<AzBone> children = new ObjectArrayList();
    private final List<GeoCube> cubes = new ObjectArrayList();
    private final Matrix4f modelSpaceMatrix = new Matrix4f();
    private final Matrix4f localSpaceMatrix = new Matrix4f();
    private final Matrix4f worldSpaceMatrix = new Matrix4f();
    private AzBoneSnapshot initialSnapshot;
    private boolean hidden;
    private boolean childrenHidden = false;
    private final Vector3f pivot;
    private final Vector3f position;
    private final Vector3f rotation;
    private final Vector3f scale;
    private boolean positionChanged = false;
    private boolean rotationChanged = false;
    private boolean scaleChanged = false;
    private Matrix3f worldSpaceNormal = new Matrix3f();
    private boolean trackingMatrices;

    public AzBone(AzBoneMetadata metadata) {
        this.metadata = metadata;
        this.trackingMatrices = false;
        this.hidden = metadata.dontRender() == Boolean.TRUE;
        this.position = new Vector3f();
        this.pivot = new Vector3f();
        this.rotation = new Vector3f();
        this.scale = new Vector3f(1.0f, 1.0f, 1.0f);
        this.worldSpaceNormal.identity();
        this.worldSpaceMatrix.identity();
        this.localSpaceMatrix.identity();
        this.modelSpaceMatrix.identity();
    }

    public String getName() {
        return this.metadata.name();
    }

    public AzBone getParent() {
        return this.metadata.parent();
    }

    public float getRotX() {
        return this.rotation.x;
    }

    public void setRotX(float value) {
        this.rotation.x = value;
        this.markRotationAsChanged();
    }

    public float getRotY() {
        return this.rotation.y;
    }

    public void setRotY(float value) {
        this.rotation.y = value;
        this.markRotationAsChanged();
    }

    public float getRotZ() {
        return this.rotation.z;
    }

    public void setRotZ(float value) {
        this.rotation.z = value;
        this.markRotationAsChanged();
    }

    public float getPosX() {
        return this.position.x;
    }

    public void setPosX(float value) {
        this.position.x = value;
        this.markPositionAsChanged();
    }

    public float getPosY() {
        return this.position.y;
    }

    public void setPosY(float value) {
        this.position.y = value;
        this.markPositionAsChanged();
    }

    public float getPosZ() {
        return this.position.z;
    }

    public void setPosZ(float value) {
        this.position.z = value;
        this.markPositionAsChanged();
    }

    public float getScaleX() {
        return this.scale.x;
    }

    public void setScaleX(float value) {
        this.scale.x = value;
        this.markScaleAsChanged();
    }

    public float getScaleY() {
        return this.scale.y;
    }

    public void setScaleY(float value) {
        this.scale.y = value;
        this.markScaleAsChanged();
    }

    public float getScaleZ() {
        return this.scale.z;
    }

    public void setScaleZ(float value) {
        this.scale.z = value;
        this.markScaleAsChanged();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.setChildrenHidden(hidden);
    }

    public void setChildrenHidden(boolean hideChildren) {
        this.childrenHidden = hideChildren;
    }

    public float getPivotX() {
        return this.pivot.x;
    }

    public void setPivotX(float value) {
        this.pivot.x = value;
    }

    public float getPivotY() {
        return this.pivot.y;
    }

    public void setPivotY(float value) {
        this.pivot.y = value;
    }

    public float getPivotZ() {
        return this.pivot.z;
    }

    public void setPivotZ(float value) {
        this.pivot.z = value;
    }

    public boolean isHidingChildren() {
        return this.childrenHidden;
    }

    public void markScaleAsChanged() {
        this.scaleChanged = true;
    }

    public void markRotationAsChanged() {
        this.rotationChanged = true;
    }

    public void markPositionAsChanged() {
        this.positionChanged = true;
    }

    public boolean hasScaleChanged() {
        return this.scaleChanged;
    }

    public boolean hasRotationChanged() {
        return this.rotationChanged;
    }

    public boolean hasPositionChanged() {
        return this.positionChanged;
    }

    public void resetStateChanges() {
        this.scaleChanged = false;
        this.rotationChanged = false;
        this.positionChanged = false;
    }

    public AzBoneSnapshot getInitialAzSnapshot() {
        return this.initialSnapshot;
    }

    public List<AzBone> getChildBones() {
        return this.children;
    }

    public void saveInitialSnapshot() {
        if (this.initialSnapshot == null) {
            this.initialSnapshot = new AzBoneSnapshot(this);
        }
    }

    public Boolean getMirror() {
        return this.metadata.mirror();
    }

    public Double getInflate() {
        return this.metadata.inflate();
    }

    public Boolean shouldNeverRender() {
        return this.metadata.dontRender();
    }

    public Boolean getReset() {
        return this.metadata.reset();
    }

    public List<GeoCube> getCubes() {
        return this.cubes;
    }

    public boolean isTrackingMatrices() {
        return this.trackingMatrices;
    }

    public void setTrackingMatrices(boolean trackingMatrices) {
        this.trackingMatrices = trackingMatrices;
    }

    public Matrix4f getModelSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.modelSpaceMatrix;
    }

    public void setModelSpaceMatrix(Matrix4f matrix) {
        this.modelSpaceMatrix.set((Matrix4fc)matrix);
    }

    public Matrix4f getLocalSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.localSpaceMatrix;
    }

    public void setLocalSpaceMatrix(Matrix4f matrix) {
        this.localSpaceMatrix.set((Matrix4fc)matrix);
    }

    public Matrix4f getWorldSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.worldSpaceMatrix;
    }

    public void setWorldSpaceMatrix(Matrix4f matrix) {
        this.worldSpaceMatrix.set((Matrix4fc)matrix);
    }

    public Matrix3f getWorldSpaceNormal() {
        return this.worldSpaceNormal;
    }

    public void setWorldSpaceNormal(Matrix3f matrix) {
        this.worldSpaceNormal = matrix;
    }

    public Vector3d getLocalPosition() {
        Vector4f vec = this.getLocalSpaceMatrix().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new Vector3d((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public Vector3d getModelPosition() {
        Vector4f vec = this.getModelSpaceMatrix().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new Vector3d((double)(-vec.x() * 16.0f), (double)(vec.y() * 16.0f), (double)(vec.z() * 16.0f));
    }

    public void setModelPosition(Vector3d pos) {
        AzBone parent = this.metadata.parent();
        Matrix4f matrix = (parent == null ? new Matrix4f().identity() : new Matrix4f((Matrix4fc)parent.getModelSpaceMatrix())).invert();
        Vector4f vec = matrix.transform(new Vector4f(-((float)pos.x) / 16.0f, (float)pos.y / 16.0f, (float)pos.z / 16.0f, 1.0f));
        this.updatePosition(-vec.x() * 16.0f, vec.y() * 16.0f, vec.z() * 16.0f);
    }

    public Vector3d getWorldPosition() {
        Vector4f vec = this.getWorldSpaceMatrix().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new Vector3d((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public Matrix4f getModelRotationMatrix() {
        Matrix4f matrix = new Matrix4f((Matrix4fc)this.getModelSpaceMatrix());
        matrix.m03(0.0f);
        matrix.m13(0.0f);
        matrix.m23(0.0f);
        return matrix;
    }

    public Vector3d getPositionVector() {
        return new Vector3d((double)this.getPosX(), (double)this.getPosY(), (double)this.getPosZ());
    }

    public Vector3d getRotationVector() {
        return new Vector3d((double)this.getRotX(), (double)this.getRotY(), (double)this.getRotZ());
    }

    public Vector3d getScaleVector() {
        return new Vector3d((double)this.getScaleX(), (double)this.getScaleY(), (double)this.getScaleZ());
    }

    public void addRotationOffsetFromBone(AzBone source) {
        this.setRotX(this.getRotX() + source.getRotX() - source.getInitialAzSnapshot().getRotX());
        this.setRotY(this.getRotY() + source.getRotY() - source.getInitialAzSnapshot().getRotY());
        this.setRotZ(this.getRotZ() + source.getRotZ() - source.getInitialAzSnapshot().getRotZ());
    }

    public void updateRotation(float xRot, float yRot, float zRot) {
        this.setRotX(xRot);
        this.setRotY(yRot);
        this.setRotZ(zRot);
    }

    public void updatePosition(float posX, float posY, float posZ) {
        this.setPosX(posX);
        this.setPosY(posY);
        this.setPosZ(posZ);
    }

    public void updateScale(float scaleX, float scaleY, float scaleZ) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        this.setScaleZ(scaleZ);
    }

    public void updatePivot(float pivotX, float pivotY, float pivotZ) {
        this.setPivotX(pivotX);
        this.setPivotY(pivotY);
        this.setPivotZ(pivotZ);
    }

    public AzBone deepCopy() {
        AzBone copy = new AzBone(this.metadata);
        copy.hidden = this.hidden;
        copy.childrenHidden = this.childrenHidden;
        copy.pivot.set((Vector3fc)this.pivot);
        copy.position.set((Vector3fc)this.position);
        copy.rotation.set((Vector3fc)this.rotation);
        copy.scale.set((Vector3fc)this.scale);
        copy.modelSpaceMatrix.set((Matrix4fc)this.modelSpaceMatrix);
        copy.localSpaceMatrix.set((Matrix4fc)this.localSpaceMatrix);
        copy.worldSpaceMatrix.set((Matrix4fc)this.worldSpaceMatrix);
        copy.cubes.addAll(this.cubes);
        for (AzBone child : this.children) {
            copy.children.add(child.deepCopy());
        }
        copy.saveInitialSnapshot();
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getParent() != null ? this.getParent().getName() : Integer.valueOf(0), this.getCubes().size(), this.getChildBones().size());
    }
}

