/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.animation;

import java.util.Collection;
import java.util.WeakHashMap;
import mod.azure.azurelibarmor.common.animation.AzAnimationContext;
import mod.azure.azurelibarmor.common.animation.AzAnimationTimer;
import mod.azure.azurelibarmor.common.animation.AzAnimatorConfig;
import mod.azure.azurelibarmor.common.animation.cache.AzBakedAnimationCache;
import mod.azure.azurelibarmor.common.animation.cache.AzBoneCache;
import mod.azure.azurelibarmor.common.animation.controller.AzAnimationController;
import mod.azure.azurelibarmor.common.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelibarmor.common.animation.primitive.AzBakedAnimation;
import mod.azure.azurelibarmor.common.animation.primitive.AzBakedAnimations;
import mod.azure.azurelibarmor.core.molang.MolangParser;
import mod.azure.azurelibarmor.core.molang.MolangQueries;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public abstract class AzAnimator<K, T> {
    private AzAnimationContext<T> currentContext;
    private final WeakHashMap<K, AzAnimationContext<T>> contextCache = new WeakHashMap();
    private final AzAnimationControllerContainer<T> animationControllerContainer = new AzAnimationControllerContainer();
    protected final AzAnimatorConfig config;
    private Collection<AzAnimationController<T>> cachedControllers;
    public boolean reloadAnimations;

    protected AzAnimator() {
        this(AzAnimatorConfig.defaultConfig());
    }

    protected AzAnimator(AzAnimatorConfig config) {
        this.config = config;
    }

    public AzBoneCache createBoneCache() {
        return new AzBoneCache();
    }

    public AzAnimationTimer createAzAnimationTimer(AzAnimatorConfig config) {
        return new AzAnimationTimer(config);
    }

    public AzAnimationContext<T> getOrCreateContext(K uuid) {
        AzAnimationContext ctx;
        this.currentContext = ctx = this.contextCache.computeIfAbsent(uuid, a -> new AzAnimationContext(this.createBoneCache(), this.config, this.createAzAnimationTimer(this.config)));
        return ctx;
    }

    public abstract void registerControllers(AzAnimationControllerContainer<T> var1);

    @NotNull
    public abstract class_2960 getAnimationLocation(T var1);

    public void animate(T animatable, float partialTicks, boolean updateTimer) {
        this.currentContext.animatable = animatable;
        AzBoneCache boneCache = this.currentContext.boneCache();
        AzAnimationTimer timer = this.currentContext.timer();
        if (updateTimer) {
            timer.tick();
        }
        this.preAnimationSetup(animatable, timer.getAnimTime(), partialTicks);
        if (!boneCache.isEmpty()) {
            if (this.cachedControllers == null) {
                this.cachedControllers = this.animationControllerContainer.getAll();
            }
            for (AzAnimationController<T> controller : this.cachedControllers) {
                controller.update();
            }
            this.reloadAnimations = false;
            boneCache.update(this.currentContext);
        }
        this.setCustomAnimations(animatable, partialTicks);
    }

    public void animate(T animatable, float partialTicks) {
        this.animate(animatable, partialTicks, true);
    }

    protected void preAnimationSetup(T animatable, double animTime, float partialTicks) {
        this.applyMolangQueries(animatable, animTime, partialTicks);
    }

    protected void applyMolangQueries(T animatable, double animTime, float partialTicks) {
        class_638 level = class_310.method_1551().field_1687;
        MolangParser parser = MolangParser.INSTANCE;
        if (level == null) {
            return;
        }
        parser.setMemoizedValue(MolangQueries.LIFE_TIME, () -> animTime / 20.0);
        parser.setMemoizedValue(MolangQueries.ACTOR_COUNT, () -> ((class_638)level).method_18120());
        parser.setMemoizedValue(MolangQueries.TIME_OF_DAY, () -> (float)level.method_8532() / 24000.0f);
        parser.setMemoizedValue(MolangQueries.MOON_PHASE, () -> ((class_638)level).method_30273());
    }

    public void setCustomAnimations(T animatable, float partialTicks) {
    }

    public AzBakedAnimation getAnimation(T animatable, String name) {
        class_2960 location = this.getAnimationLocation(animatable);
        AzBakedAnimations bakedAnimations = AzBakedAnimationCache.getInstance().getNullable(location);
        return bakedAnimations.getAnimation(name);
    }

    public AzAnimationContext<T> context() {
        return this.currentContext;
    }

    public AzAnimationControllerContainer<T> getAnimationControllerContainer() {
        return this.animationControllerContainer;
    }
}

