/*
 * Decompiled with CFR 0.152.
 */
package net.relics_rpgs.datagen;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;
import net.minecraft.class_7225;
import net.relics_rpgs.item.Group;
import net.relics_rpgs.item.RelicItemTags;
import net.relics_rpgs.item.RelicItems;
import net.relics_rpgs.spell.RelicEffects;
import net.relics_rpgs.spell.RelicSounds;
import net.relics_rpgs.spell.RelicSpells;
import net.spell_engine.api.datagen.SimpleSoundGenerator;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;

public class RelicsDataGen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(LangGenerator::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(RelicsSpellGen::new);
        pack.addProvider(SoundGen::new);
    }

    public static class SoundGen
    extends SimpleSoundGenerator {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGenerator.Builder builder) {
            builder.entries.add(new SimpleSoundGenerator.Entry("relics_rpgs", RelicSounds.entries.stream().map(RelicSounds.Entry::name).toList()));
        }
    }

    public static class RelicsSpellGen
    extends SpellGenerator {
        public RelicsSpellGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (RelicSpells.Entry entry : RelicSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        }

        public void generateItemModels(class_4915 itemModelGenerator) {
            RelicItems.entries.forEach(entry -> itemModelGenerator.method_25733(entry.item().get(), class_4943.field_22938));
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            translationBuilder.add("trinkets.slot.spell.trinket", "Trinket");
            translationBuilder.add("trinkets.slot.charm.trinket", "Trinket");
            translationBuilder.add(Group.translationKey, "Relics");
            RelicItems.entries.forEach(entry -> translationBuilder.add(entry.item().get().method_7876(), entry.translatedName()));
            RelicSpells.entries.forEach(entry -> {
                class_2960 id = entry.id();
                translationBuilder.add("spell." + id.method_12836() + "." + id.method_12832() + ".name", entry.title());
                translationBuilder.add("spell." + id.method_12836() + "." + id.method_12832() + ".description", entry.description());
            });
            RelicEffects.entries.forEach(entry -> {
                translationBuilder.add(entry.effect.method_5567(), entry.title);
                translationBuilder.add(entry.effect.method_5567() + ".description", entry.description);
            });
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            FabricTagProvider.FabricTagBuilder all = this.getOrCreateTagBuilder(RelicItemTags.ALL);
            RelicItems.entries.forEach(entry -> all.addOptional(entry.id()));
            HashMap<class_2960, Equipment.LootProperties> relicEntries = new HashMap<class_2960, Equipment.LootProperties>();
            for (RelicItems.Entry entry2 : RelicItems.entries) {
                class_2960 id = entry2.id();
                Equipment.LootProperties lootProperties = Equipment.LootProperties.of((int)entry2.tier(), (String)entry2.lootTheme);
                relicEntries.put(id, lootProperties);
            }
            this.generateRelicTags(relicEntries);
        }
    }
}

