/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.translation;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class TranslationTable {
    public static final class_9139<class_2540, TranslationTable> STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.method_56377(Maps::newHashMapWithExpectedSize, (class_9139)class_9135.field_48554, (class_9139)class_9135.method_57995((class_9139)class_9135.field_48554, (class_9139)class_9135.field_48554.method_56433(class_9135.method_56363()))), t -> t.map, TranslationTable::new);
    private final Map<String, Either<String, List<String>>> map;
    private boolean saveNeeded;

    public TranslationTable() {
        this.map = new HashMap<String, Either<String, List<String>>>();
    }

    public static TranslationTable fromNBT(class_2487 tag) {
        HashMap<String, Either<String, List<String>>> map = new HashMap<String, Either<String, List<String>>>();
        tag.method_10541().forEach(k -> {
            class_2520 selector0$temp = tag.method_10580(k);
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2519.class, class_2499.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    class_2519 str = (class_2519)selector0$temp;
                    map.put((String)k, (Either<String, List<String>>)Either.left((Object)str.method_10714()));
                    break;
                }
                case 1: {
                    class_2499 list = (class_2499)selector0$temp;
                    map.put((String)k, (Either<String, List<String>>)Either.right(list.stream().map(class_2520::method_10714).toList()));
                    break;
                }
            }
        });
        return new TranslationTable(map);
    }

    private TranslationTable(Map<String, Either<String, List<String>>> map) {
        this.map = map;
    }

    boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    void setSaveNeeded(boolean saveNeeded) {
        this.saveNeeded = saveNeeded;
    }

    public Optional<String> getStringTranslation(String key) {
        return Optional.ofNullable(this.map.get(key)).flatMap(e -> e.left());
    }

    public Optional<List<String>> getStringListTranslation(String key) {
        return Optional.ofNullable(this.map.get(key)).flatMap(e -> e.right());
    }

    public void put(String key, String message) {
        this.map.put(key, (Either<String, List<String>>)Either.left((Object)message));
        this.setSaveNeeded(true);
    }

    public void put(String key, List<String> message) {
        this.map.put(key, (Either<String, List<String>>)Either.right(message));
        this.setSaveNeeded(true);
    }

    public void remove(String key) {
        if (this.map.remove(key) != null) {
            this.setSaveNeeded(true);
        }
    }

    public class_2487 saveToNBT() {
        return (class_2487)class_156.method_654((Object)new class_2487(), tag -> this.map.forEach((key, val) -> val.ifLeft(str -> {
            if (!str.isEmpty()) {
                tag.method_10582(key, str);
            }
        }).ifRight(list -> {
            if (!list.isEmpty()) {
                tag.method_10566(key, (class_2520)TranslationTable.listOfStr(list));
            }
        })));
    }

    static class_2499 listOfStr(List<String> l) {
        return (class_2499)class_156.method_654((Object)new class_2499(), t -> l.forEach(s -> t.add((Object)class_2519.method_23256((String)s))));
    }

    public int size() {
        return this.map.size();
    }

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }
}

