/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.translation;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.net.SyncTranslationTableMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.translation.TranslationKey;
import dev.ftb.mods.ftbquests.quest.translation.TranslationTable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class TranslationManager {
    private static final Pattern LANG_FILE_PAT = Pattern.compile("^\\w+\\.snbt$");
    private final Map<String, TranslationTable> map = new HashMap<String, TranslationTable>();
    public static final String DEFAULT_FALLBACK_LOCALE = "en_us";

    public static void syncTable(class_3222 player, String language) {
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file != null && file.isValid()) {
            file.getTranslationManager().sendTableToPlayer(player, language);
        }
    }

    private static String getFallbackLocale(QuestObjectBase object) {
        return object.getQuestFile().getFallbackLocale();
    }

    public void loadFromNBT(BaseQuestFile file, Path langFolder) {
        this.map.clear();
        if (!Files.exists(langFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(langFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                FTBQuests.LOGGER.error("can't create lang folder {}: {}", (Object)langFolder, (Object)e.getMessage());
                return;
            }
        }
        try (Stream<Path> s = Files.list(langFolder);){
            s.filter(TranslationManager::isValidLangFile).forEach(path -> {
                SNBTCompoundTag langNBT = SNBT.read((Path)path);
                if (langNBT != null) {
                    String locale = path.getFileName().toString().split("\\.", 2)[0].toLowerCase(Locale.ROOT);
                    this.map.put(locale, TranslationTable.fromNBT((class_2487)langNBT));
                } else {
                    FTBQuests.LOGGER.error("can't read lang file {}", path);
                }
            });
            if (!this.map.containsKey(file.getFallbackLocale())) {
                this.map.put(file.getFallbackLocale(), new TranslationTable());
            }
            FTBQuests.LOGGER.info("loaded translation tables for {} language(s)", (Object)this.map.size());
        }
        catch (IOException e) {
            FTBQuests.LOGGER.error("can't scan lang folder {}: {}", (Object)langFolder, (Object)e.getMessage());
        }
    }

    public void saveToNBT(Path langFolder, boolean force) {
        this.map.forEach((locale, table) -> {
            if (force || table.isSaveNeeded()) {
                boolean prevSort = SNBT.setShouldSortKeysOnWrite((boolean)true);
                Path savePath = langFolder.resolve(locale + ".snbt");
                if (!SNBT.write((Path)savePath, (class_2487)table.saveToNBT())) {
                    FTBQuests.LOGGER.error("can't write lang file {}", (Object)savePath);
                }
                table.setSaveNeeded(false);
                SNBT.setShouldSortKeysOnWrite((boolean)prevSort);
            }
        });
    }

    private static boolean isValidLangFile(Path p) {
        return LANG_FILE_PAT.matcher(p.getFileName().toString()).matches();
    }

    public Optional<String> getStringTranslation(QuestObjectBase object, String locale, TranslationKey subKey) {
        String key = TranslationManager.makeKey(object, subKey);
        TranslationTable table = this.map.get(locale);
        if (table != null && table.contains(key)) {
            return table.getStringTranslation(key);
        }
        return this.map.computeIfAbsent(TranslationManager.getFallbackLocale(object), k -> new TranslationTable()).getStringTranslation(key);
    }

    public Optional<List<String>> getStringListTranslation(QuestObjectBase object, String locale, TranslationKey subKey) {
        String key = TranslationManager.makeKey(object, subKey);
        TranslationTable table = this.map.get(locale);
        if (table != null && table.contains(key)) {
            return table.getStringListTranslation(key);
        }
        return this.map.computeIfAbsent(TranslationManager.getFallbackLocale(object), k -> new TranslationTable()).getStringListTranslation(key);
    }

    private Optional<TranslationTable> getTable(QuestObjectBase object, String locale) {
        return Optional.ofNullable(this.map.get(locale)).or(() -> Optional.ofNullable(this.map.get(TranslationManager.getFallbackLocale(object))));
    }

    private boolean hasTranslationForLocale(QuestObjectBase object, String locale, TranslationKey subKey) {
        return this.map.containsKey(locale) ? this.getTable(object, locale).map(t -> t.contains(TranslationManager.makeKey(object, subKey))).orElse(false) : false;
    }

    public boolean hasMissingTranslation(QuestObjectBase object, TranslationKey key) {
        BaseQuestFile file = object.getQuestFile();
        String locale = file.getLocale();
        return file.canEdit() && (Boolean)FTBQuestsClientConfig.HILITE_MISSING.get() != false && !locale.equals(file.getFallbackLocale()) && this.hasTranslationForLocale(object, file.getFallbackLocale(), key) && !this.hasTranslationForLocale(object, locale, key);
    }

    public void addTranslation(QuestObjectBase object, String locale, TranslationKey subKey, String message) {
        this.addTranslation(locale, TranslationManager.makeKey(object, subKey), message);
    }

    public void addTranslation(QuestObjectBase object, String locale, TranslationKey subKey, List<String> message) {
        this.addTranslation(locale, TranslationManager.makeKey(object, subKey), message);
    }

    private void addTranslation(String locale, String key, List<String> message) {
        this.map.computeIfAbsent(locale, k -> new TranslationTable()).put(key, message);
    }

    private void addTranslation(String locale, String key, String message) {
        this.map.computeIfAbsent(locale, k -> new TranslationTable()).put(key, message);
    }

    public void removeAllTranslations(QuestObjectBase obj) {
        this.map.values().forEach(table -> {
            for (TranslationKey key : TranslationKey.values()) {
                table.remove(TranslationManager.makeKey(obj, key));
            }
            table.setSaveNeeded(true);
        });
    }

    @NotNull
    private static String makeKey(QuestObjectBase object, TranslationKey subKey) {
        return String.format("%s.%s.%s", object.getObjectType().getId(), QuestObjectBase.getCodeString(object), subKey.getName());
    }

    public void syncTableFromServer(String locale, TranslationTable table) {
        this.map.put(locale, table);
    }

    public void sendTranslationsToPlayer(class_3222 player) {
        HashSet<String> toSend = new HashSet<String>();
        String fallback = ServerQuestFile.INSTANCE.getFallbackLocale();
        toSend.add(DEFAULT_FALLBACK_LOCALE);
        toSend.add(fallback);
        toSend.add(player.method_53823().comp_1951());
        toSend.forEach(lang -> this.sendTableToPlayer(player, (String)lang));
    }

    public void sendTableToPlayer(class_3222 player, String locale) {
        if (this.map.containsKey(locale)) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new SyncTranslationTableMessage(locale, this.map.getOrDefault(locale, new TranslationTable())));
        }
    }

    public void addInitialTranslation(class_2487 extra, String locale, TranslationKey translationKey, String value) {
        extra.method_10582("locale", locale);
        extra.method_10566("translate", (class_2520)class_156.method_654((Object)new class_2487(), t -> t.method_10582(TranslationKey.NAME_MAP.getName((Object)translationKey), value)));
    }

    public void processInitialTranslation(class_2487 extra, QuestObjectBase object) {
        if (extra.method_10545("locale") && extra.method_10545("translate")) {
            String locale = extra.method_10558("locale");
            TranslationTable table = this.map.computeIfAbsent(locale, k -> new TranslationTable());
            class_2487 tag = extra.method_10562("translate");
            for (String keyStr : tag.method_10541()) {
                TranslationKey key = (TranslationKey)((Object)TranslationKey.NAME_MAP.getNullable(keyStr));
                if (key == null) continue;
                table.put(TranslationManager.makeKey(object, key), tag.method_10558(keyStr));
            }
        }
    }
}

