/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.integration.stages.StageHelper;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamStagesHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class StageTask
extends AbstractBooleanTask {
    private String stage = "";
    private boolean teamStage = false;

    public StageTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STAGE;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10582("stage", this.stage);
        if (this.teamStage) {
            nbt.method_10556("team_stage", true);
        }
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.stage = nbt.method_10558("stage");
        this.teamStage = nbt.method_10577("team_stage");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.stage, Short.MAX_VALUE);
        buffer.method_52964(this.teamStage);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.stage = buffer.method_10800(Short.MAX_VALUE);
        this.teamStage = buffer.readBoolean();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.task.ftbquests.gamestage");
        config.addBool("team_stage", this.teamStage, v -> {
            this.teamStage = v;
        }, false);
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43471((String)"ftbquests.task.ftbquests.gamestage").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)this.stage).method_27692(class_124.field_1054));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean canSubmit(TeamData teamData, class_3222 player) {
        if (this.teamStage) {
            return FTBTeamsAPI.api().getManager().getTeamByID(teamData.getTeamId()).map(team -> TeamStagesHelper.hasTeamStage((Team)team, (String)this.stage)).orElse(false);
        }
        return StageHelper.INSTANCE.getProvider().has((class_1657)player, this.stage);
    }

    public static void checkStages(class_3222 player) {
        if (ServerQuestFile.INSTANCE == null || PlayerHooks.isFake((class_1657)player)) {
            return;
        }
        ServerQuestFile.INSTANCE.getTeamData((class_1657)player).ifPresent(data -> {
            if (!data.isLocked()) {
                ServerQuestFile.INSTANCE.withPlayerContext(player, () -> {
                    for (Task task : ServerQuestFile.INSTANCE.getAllTasks()) {
                        if (!(task instanceof StageTask) || !data.canStartTasks(task.getQuest())) continue;
                        task.submitTask((TeamData)data, player);
                    }
                });
            }
        });
    }
}

