/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.Lazy;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillTask
extends Task {
    private static final class_2960 ZOMBIE = class_2960.method_60656((String)"zombie");
    private static final Lazy<NameMap<class_2960>> entityNameMap = Lazy.of(KillTask::scanEntityTypes);
    private static final Lazy<NameMap<String>> entityTagMap = Lazy.of(KillTask::scanEntityTags);
    private class_2960 entityTypeId = ZOMBIE;
    private class_6862<class_1299<?>> entityTypeTag = null;
    private long value = 100L;
    private String customName = "";
    private static final Map<class_2960, Icon> entityIcons = new HashMap<class_2960, Icon>();

    public KillTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.KILL;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10582("entity", this.entityTypeId.toString());
        if (this.entityTypeTag != null) {
            nbt.method_10582("entityTypeTag", this.entityTypeTag.comp_327().toString());
        }
        nbt.method_10544("value", this.value);
        if (!this.customName.isEmpty()) {
            nbt.method_10582("custom_name", this.customName);
        }
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.entityTypeId = class_2960.method_12829((String)nbt.method_10558("entity"));
        this.entityTypeTag = KillTask.parseTypeTag(nbt.method_10558("entityTypeTag"));
        this.value = nbt.method_10537("value");
        this.customName = nbt.method_10558("custom_name");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10814(this.entityTypeId.toString());
        buffer.method_10814(this.entityTypeTag == null ? "" : this.entityTypeTag.comp_327().toString());
        buffer.method_10791(this.value);
        buffer.method_10814(this.customName);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.entityTypeId = class_2960.method_12829((String)buffer.method_19772());
        this.entityTypeTag = KillTask.parseTypeTag(buffer.method_19772());
        this.value = buffer.method_10816();
        this.customName = buffer.method_19772();
    }

    @Nullable
    private static class_6862<class_1299<?>> parseTypeTag(String tag) {
        class_2960 rl;
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        if (tag.startsWith("#")) {
            tag = tag.substring(1);
        }
        return (rl = class_2960.method_12829((String)tag)) == null || rl.method_12832().isEmpty() ? null : class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)rl);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("entity", (Object)this.entityTypeId, v -> {
            this.entityTypeId = v;
        }, (NameMap)entityNameMap.get(), (Object)ZOMBIE);
        config.addEnum("entity_type_tag", (Object)this.getTypeTagStr(), v -> {
            this.entityTypeTag = KillTask.parseTypeTag(v);
        }, (NameMap)entityTagMap.get());
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE);
        config.addString("custom_name", this.customName, v -> {
            this.customName = v;
        }, "");
    }

    private String getTypeTagStr() {
        return this.entityTypeTag == null ? "" : this.entityTypeTag.comp_327().toString();
    }

    private static Icon getIconForEntityType(class_2960 typeId) {
        return entityIcons.computeIfAbsent(typeId, k -> {
            class_1799 stack;
            class_1297 e;
            class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(typeId);
            if (entityType.equals(class_1299.field_6097)) {
                return Icons.PLAYER;
            }
            class_1826 item = class_1826.method_8019((class_1299)entityType);
            if (item == null && (e = entityType.method_5883(FTBQuestsClient.getClientLevel())) != null && (stack = e.method_31480()) != null) {
                item = stack.method_7909();
            }
            return ItemIcon.getItemIcon((class_1792)(item != null ? item : class_1802.field_8849));
        });
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        entityNameMap.invalidate();
        entityTagMap.invalidate();
        entityIcons.clear();
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        class_5250 name;
        class_5250 class_52502 = name = this.entityTypeTag == null ? class_2561.method_43471((String)("entity." + this.entityTypeId.method_42094())) : class_2561.method_43470((String)("#" + this.getTypeTagStr()));
        if (!this.customName.isEmpty()) {
            return class_2561.method_43469((String)"ftbquests.task.ftbquests.kill.title_named", (Object[])new Object[]{this.formatMaxProgress(), name, class_2561.method_43470((String)this.customName)});
        }
        return class_2561.method_43469((String)"ftbquests.task.ftbquests.kill.title", (Object[])new Object[]{this.formatMaxProgress(), name});
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        if (this.entityTypeTag == null) {
            return KillTask.getIconForEntityType(this.entityTypeId);
        }
        ArrayList icons = new ArrayList();
        class_7923.field_41177.method_40266(this.entityTypeTag).ifPresent(set -> set.forEach(holder -> holder.method_40230().map(k -> icons.add(KillTask.getIconForEntityType(k.method_29177())))));
        return icons.isEmpty() ? Icons.BARRIER : IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public void kill(TeamData teamData, class_1309 e) {
        if (!teamData.isCompleted(this) && this.match(e)) {
            teamData.addProgress(this, 1L);
        }
    }

    private boolean match(class_1309 e) {
        return this.entityTypeTag == null ? this.entityTypeId.equals((Object)RegistrarManager.getId((Object)e.method_5864(), (class_5321)class_7924.field_41266)) && this.nameMatchOK(e) : e.method_5864().method_20210(this.entityTypeTag) && this.nameMatchOK(e);
    }

    private boolean nameMatchOK(class_1309 e) {
        class_1657 p;
        return this.customName.isEmpty() || (e instanceof class_1657 ? (p = (class_1657)e).method_7334().getName().equals(this.customName) : e.method_5477().getString().equals(this.customName));
    }

    @NotNull
    private static NameMap<class_2960> scanEntityTypes() {
        ArrayList ids = new ArrayList();
        class_7923.field_41177.forEach(type -> {
            try {
                if (type.method_5883(FTBQuestsClient.getClientLevel()) instanceof class_1309) {
                    ids.add(type.arch$registryName());
                }
            }
            catch (Exception e) {
                FTBQuests.LOGGER.warn("Entity creation failed during kill task scanning for {}: {}", (Object)type.arch$registryName(), (Object)e.getMessage());
            }
        });
        ids.sort((r1, r2) -> {
            class_5250 c1 = class_2561.method_43471((String)("entity." + r1.method_42094()));
            class_5250 c2 = class_2561.method_43471((String)("entity." + r2.method_42094()));
            return c1.getString().compareTo(c2.getString());
        });
        return NameMap.of((Object)ZOMBIE, ids).nameKey(id -> "entity." + id.method_42094()).icon(KillTask::getIconForEntityType).create();
    }

    @NotNull
    private static NameMap<String> scanEntityTags() {
        ArrayList<String> tags = new ArrayList<String>(List.of(""));
        tags.addAll(class_7923.field_41177.method_40272().map(pair -> ((class_6862)pair.getFirst()).comp_327().toString()).sorted().toList());
        return NameMap.of((Object)"minecraft:zombies", tags).create();
    }
}

