/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public class FluidTask
extends Task {
    public static final class_2960 TANK_TEXTURE = FTBQuestsAPI.rl("textures/tasks/tank.png");
    private static final FluidStack WATER = FluidStack.create((class_3611)class_3612.field_15910, (long)FluidStack.bucketAmount());
    private FluidStack fluidStack = FluidStack.create((class_3611)class_3612.field_15910, (long)FluidStack.bucketAmount());

    public FluidTask(long id, Quest quest) {
        super(id, quest);
    }

    public class_3611 getFluid() {
        return this.fluidStack.getFluid();
    }

    public FluidTask setFluid(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    public class_9323 getFluidDataComponents() {
        return this.fluidStack.getComponents();
    }

    public class_9326 getFluidDataComponentPatch() {
        return this.fluidStack.getComponents().method_57940();
    }

    @Override
    public TaskType getType() {
        return TaskTypes.FLUID;
    }

    @Override
    public long getMaxProgress() {
        return this.fluidStack.getAmount();
    }

    @Override
    public String formatMaxProgress() {
        return FluidTask.getVolumeString(this.fluidStack.getAmount());
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return FluidTask.getVolumeString((int)Math.min(Integer.MAX_VALUE, progress));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10566("fluid", this.fluidStack.write(provider, (class_2520)new class_2487()));
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        class_2960 id;
        super.readData(nbt, provider);
        this.fluidStack = nbt.method_10573("fluid", 8) ? ((id = class_2960.method_12829((String)nbt.method_10558("fluid"))) == null ? FluidStack.create((class_3611)class_3612.field_15910, (long)1000L) : FluidStack.create((class_3611)((class_3611)class_7923.field_41173.method_10223(id)), (long)nbt.method_10537("amount"))) : FluidStack.read((class_7225.class_7874)provider, (class_2520)nbt.method_10562("fluid")).orElse(FluidStack.empty());
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        this.fluidStack.write(buffer);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.fluidStack = FluidStack.read((class_9129)buffer);
    }

    public static String getVolumeString(long a) {
        StringBuilder builder = new StringBuilder();
        if (a >= FluidStack.bucketAmount()) {
            if (a % FluidStack.bucketAmount() != 0L) {
                builder.append(StringUtils.formatDouble((double)((double)a / (double)FluidStack.bucketAmount())));
            } else {
                builder.append(a / FluidStack.bucketAmount());
            }
            builder.append(" B");
        } else {
            builder.append(a).append(" mB");
        }
        return builder.toString();
    }

    public class_5250 getAltTitle() {
        return class_2561.method_43470((String)(FluidTask.getVolumeString(this.fluidStack.getAmount()) + " of ")).method_10852(this.fluidStack.getName());
    }

    @Override
    public Icon getAltIcon() {
        return Icon.getIcon((class_2960)ClientUtils.getStillTexture((FluidStack)this.fluidStack)).withTint(Color4I.rgb((int)ClientUtils.getFluidColor((FluidStack)this.fluidStack)));
    }

    @Override
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addFluidStack("fluid", this.fluidStack, v -> {
            this.fluidStack = v;
        }, WATER, false);
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    @Nullable
    public Optional<PositionedIngredient> getIngredient(Widget widget) {
        return PositionedIngredient.of((Object)this.fluidStack, (Widget)widget);
    }
}

