/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.RecipeModHelper;
import dev.ftb.mods.ftbquests.net.ClaimRewardMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.translation.TranslationKey;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public abstract class Reward
extends QuestObjectBase {
    protected final Quest quest;
    private Tristate team;
    protected RewardAutoClaim autoclaim;
    private boolean excludeFromClaimAll;
    private boolean ignoreRewardBlocking;
    protected boolean disableRewardScreenBlur;

    public Reward(long id, Quest q) {
        super(id);
        this.quest = q;
        this.team = Tristate.DEFAULT;
        this.autoclaim = RewardAutoClaim.DEFAULT;
        this.excludeFromClaimAll = this.getType().getExcludeFromListRewards();
        this.ignoreRewardBlocking = false;
        this.disableRewardScreenBlur = false;
    }

    public Quest getQuest() {
        return this.quest;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.REWARD;
    }

    @Override
    public final BaseQuestFile getQuestFile() {
        return this.quest.getChapter().file;
    }

    @Override
    @Nullable
    public final Chapter getQuestChapter() {
        return this.quest.getChapter();
    }

    @Override
    public final long getParentID() {
        return this.quest.id;
    }

    public abstract RewardType getType();

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        if (this.team != Tristate.DEFAULT) {
            this.team.write(nbt, "team_reward");
        }
        if (this.autoclaim != RewardAutoClaim.DEFAULT) {
            nbt.method_10582("auto", this.autoclaim.id);
        }
        if (this.excludeFromClaimAll) {
            nbt.method_10556("exclude_from_claim_all", true);
        }
        if (this.ignoreRewardBlocking) {
            nbt.method_10556("ignore_reward_blocking", true);
        }
        if (this.disableRewardScreenBlur) {
            nbt.method_10556("disable_reward_screen_blur", true);
        }
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.team = Tristate.read((class_2487)nbt, (String)"team_reward");
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.get(nbt.method_10558("auto")));
        this.excludeFromClaimAll = nbt.method_10577("exclude_from_claim_all");
        this.ignoreRewardBlocking = nbt.method_10577("ignore_reward_blocking");
        this.disableRewardScreenBlur = nbt.method_10577("disable_reward_screen_blur");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        Tristate.NAME_MAP.write((class_2540)buffer, (Object)this.team);
        RewardAutoClaim.NAME_MAP.write((class_2540)buffer, (Object)this.autoclaim);
        buffer.method_52964(this.excludeFromClaimAll);
        buffer.method_52964(this.ignoreRewardBlocking);
        buffer.method_52964(this.disableRewardScreenBlur);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.team = (Tristate)Tristate.NAME_MAP.read((class_2540)buffer);
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.read((class_2540)buffer));
        this.excludeFromClaimAll = buffer.readBoolean();
        this.ignoreRewardBlocking = buffer.readBoolean();
        this.disableRewardScreenBlur = buffer.readBoolean();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("team", (Object)this.team, v -> {
            this.team = v;
        }, Tristate.NAME_MAP).setNameKey("ftbquests.reward.team_reward");
        config.addEnum("autoclaim", (Object)this.autoclaim, v -> {
            this.autoclaim = v;
        }, RewardAutoClaim.NAME_MAP).setNameKey("ftbquests.reward.autoclaim");
        config.addBool("exclude_from_claim_all", this.getExcludeFromClaimAll(), v -> {
            this.excludeFromClaimAll = v;
        }, this.excludeFromClaimAll).setNameKey("ftbquests.reward.exclude_from_claim_all").setCanEdit(!this.isClaimAllHardcoded());
        config.addBool("ignore_reward_blocking", this.ignoreRewardBlocking(), v -> {
            this.ignoreRewardBlocking = v;
        }, this.ignoreRewardBlocking).setNameKey("ftbquests.quest.misc.ignore_reward_blocking").setCanEdit(!this.isIgnoreRewardBlockingHardcoded());
        config.addBool("disable_reward_screen_blur", this.disableRewardScreenBlur, v -> {
            this.disableRewardScreenBlur = v;
        }, false).setNameKey("ftbquests.reward.disable_reward_screen_blur");
    }

    public abstract void claim(class_3222 var1, boolean var2);

    public boolean automatedClaimPre(class_2586 blockEntity, List<class_1799> items, class_5819 random, UUID playerId, @Nullable class_3222 player) {
        return player != null;
    }

    public void automatedClaimPost(class_2586 blockEntity, UUID playerId, @Nullable class_3222 player) {
        if (player != null) {
            this.claim(player, false);
        }
    }

    @Override
    public final void deleteSelf() {
        this.quest.removeReward(this);
        for (TeamData data : this.getQuestFile().getAllTeamData()) {
            data.deleteReward(this);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        for (TeamData data : this.getQuestFile().getAllTeamData()) {
            data.deleteReward(this);
        }
        super.deleteChildren();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.refreshQuestPanel();
            if (gui.isViewingQuest()) {
                gui.refreshViewQuestPanel();
            }
        }
    }

    @Override
    public void onCreated() {
        this.quest.addReward(this);
    }

    public final boolean isTeamReward() {
        return this.team.get(this.quest.getQuestFile().isDefaultPerTeamReward());
    }

    public final RewardAutoClaim getAutoClaimType() {
        if (this.quest.getChapter().isAlwaysInvisible() && (this.autoclaim == RewardAutoClaim.DEFAULT || this.autoclaim == RewardAutoClaim.DISABLED)) {
            return RewardAutoClaim.ENABLED;
        }
        if (this.autoclaim == RewardAutoClaim.DEFAULT) {
            return this.quest.getQuestFile().getDefaultRewardAutoClaim();
        }
        return this.autoclaim;
    }

    @Override
    public final void forceProgress(TeamData teamData, ProgressChange progressChange) {
        if (progressChange.shouldReset()) {
            teamData.resetReward(progressChange.getPlayerId(), this);
        } else {
            BaseQuestFile baseQuestFile = this.getQuestFile();
            if (baseQuestFile instanceof ServerQuestFile) {
                ServerQuestFile sqf = (ServerQuestFile)baseQuestFile;
                if (this.getAutoClaimType() != RewardAutoClaim.DISABLED) {
                    if (this.isTeamReward()) {
                        class_3222 player2 = sqf.server.method_3760().method_14602(progressChange.getPlayerId());
                        if (player2 != null) {
                            teamData.claimReward(player2, this, this.getAutoClaimType() == RewardAutoClaim.ENABLED, progressChange.getDate().getTime());
                        }
                    } else {
                        teamData.getOnlineMembers().forEach(player -> teamData.claimReward((class_3222)player, this, this.getAutoClaimType() == RewardAutoClaim.ENABLED, progressChange.getDate().getTime()));
                    }
                }
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        return this.getType().getIconSupplier();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        RewardType type = this.getType();
        return group.getOrCreateSubgroup(this.getObjectType().getId()).getOrCreateSubgroup(type.getTypeId().method_12836()).getOrCreateSubgroup(type.getTypeId().method_12832());
    }

    @Environment(value=EnvType.CLIENT)
    public void addMouseOverText(TooltipList list) {
    }

    @Environment(value=EnvType.CLIENT)
    public boolean addTitleInMouseOverText() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (canClick) {
            button.playClickSound();
            NetworkManager.sendToServer((class_8710)new ClaimRewardMessage(this.id, true));
        }
    }

    public boolean getExcludeFromClaimAll() {
        return this.excludeFromClaimAll;
    }

    public boolean isClaimAllHardcoded() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public Optional<PositionedIngredient> getIngredient(Widget widget) {
        return PositionedIngredient.of((Object)this.getIcon().getIngredient(), (Widget)widget);
    }

    @Override
    public Set<RecipeModHelper.Components> componentsToRefresh() {
        return EnumSet.of(RecipeModHelper.Components.QUESTS);
    }

    @Environment(value=EnvType.CLIENT)
    public String getButtonText() {
        return "";
    }

    public boolean ignoreRewardBlocking() {
        return this.ignoreRewardBlocking;
    }

    protected boolean isIgnoreRewardBlockingHardcoded() {
        return false;
    }

    public void addAnyProtoTranslations(class_2487 tag) {
        if (this.protoTranslations.containsKey((Object)TranslationKey.TITLE)) {
            this.getQuestFile().getTranslationManager().addInitialTranslation(tag, this.getQuestFile().getLocale(), TranslationKey.TITLE, (String)this.protoTranslations.get((Object)TranslationKey.TITLE));
        }
    }
}

