/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.integration.currency.CurrencyHelper;
import dev.ftb.mods.ftblibrary.integration.currency.CurrencyProvider;
import dev.ftb.mods.ftbquests.net.NotifyRewardMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;

public class CurrencyReward
extends Reward {
    private int coinAmount;

    public CurrencyReward(long id, Quest q) {
        this(id, q, 1);
    }

    public CurrencyReward(long id, Quest q, int coinAmount) {
        super(id, q);
        this.coinAmount = coinAmount;
    }

    public int getCoinAmount() {
        return this.coinAmount;
    }

    @Override
    public RewardType getType() {
        return RewardTypes.CURRENCY;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10569("amount", this.coinAmount);
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.coinAmount = nbt.method_10550("amount");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10804(this.coinAmount);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.coinAmount = buffer.method_10816();
    }

    @Override
    public class_2561 getAltTitle() {
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u2b24 ").method_27692(class_124.field_1054)).method_27693(String.valueOf(this.coinAmount));
    }

    @Override
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("coins", this.coinAmount, v -> {
            this.coinAmount = v;
        }, 100, 1, Integer.MAX_VALUE).setNameKey("ftbquests.reward.ftbquests.currency");
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        CurrencyProvider provider = CurrencyHelper.getInstance().getProvider();
        if (provider.isValidProvider()) {
            provider.giveCurrency((class_1657)player, this.coinAmount);
            if (notify) {
                class_5250 msg = class_2561.method_43470((String)Integer.toString(this.coinAmount)).method_27693(" ").method_10852(provider.coinName(this.coinAmount > 1));
                NetworkManager.sendToPlayer((class_3222)player, (class_8710)new NotifyRewardMessage(this.id, (class_2561)msg, Icons.MONEY, this.disableRewardScreenBlur));
            }
        }
    }
}

