/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.ConfigIconItemStack;
import dev.ftb.mods.ftbquests.integration.RecipeModHelper;
import dev.ftb.mods.ftbquests.item.CustomIconItem;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.net.SyncTranslationMessageToServer;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.quest.translation.TranslationKey;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import dev.ftb.mods.ftbquests.registry.ModItems;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QuestObjectBase
implements Comparable<QuestObjectBase> {
    private static final Pattern TAG_PATTERN = Pattern.compile("^[a-z0-9_]*$");
    private static Tristate sendNotifications = Tristate.DEFAULT;
    public final long id;
    protected boolean invalid = false;
    private class_1799 rawIcon = class_1799.field_8037;
    private List<String> tags = new ArrayList<String>(0);
    private Icon cachedIcon = null;
    private class_2561 cachedTitle = null;
    private Set<String> cachedTags = null;
    protected EnumMap<TranslationKey, String> protoTranslations = new EnumMap(TranslationKey.class);

    public QuestObjectBase(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public static boolean isNull(@Nullable QuestObjectBase object) {
        return object == null || object.invalid;
    }

    public static long getID(@Nullable QuestObjectBase object) {
        return QuestObjectBase.isNull(object) ? 0L : object.id;
    }

    public static String getCodeString(long id) {
        return String.format("%016X", id);
    }

    public static String getCodeString(@Nullable QuestObjectBase object) {
        return QuestObjectBase.getCodeString(QuestObjectBase.getID(object));
    }

    public static boolean shouldSendNotifications() {
        return sendNotifications.get(true);
    }

    public static class_1799 itemOrMissingFromNBT(class_2520 tag, class_7225.class_7874 provider) {
        class_2487 compoundTag = QuestObjectBase.processItemTagData(tag);
        return compoundTag.method_33133() ? class_1799.field_8037 : class_1799.method_57360((class_7225.class_7874)provider, (class_2520)compoundTag).orElse(QuestObjectBase.createMissing(compoundTag));
    }

    public static class_1799 singleItemOrMissingFromNBT(class_2520 tag, class_7225.class_7874 provider) {
        class_2487 compoundTag = QuestObjectBase.processItemTagData(tag);
        return compoundTag.method_33133() ? class_1799.field_8037 : class_1799.field_49747.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)compoundTag).result().orElse(QuestObjectBase.createMissing(compoundTag));
    }

    private static class_2487 processItemTagData(class_2520 tag) {
        if (tag instanceof class_2519) {
            class_2519 s = (class_2519)tag;
            return (class_2487)class_156.method_654((Object)new class_2487(), t -> t.method_10582("id", s.method_10714()));
        }
        if (tag instanceof class_2487) {
            class_2487 c = (class_2487)tag;
            if (c.method_10545("Count") || c.method_10545("tag")) {
                return (class_2487)class_156.method_654((Object)new class_2487(), t -> {
                    t.method_10582("id", c.method_10558("id"));
                    int count = c.method_10550("Count");
                    if (count != 0) {
                        t.method_10569("count", count);
                    }
                });
            }
            return c;
        }
        return new class_2487();
    }

    private static class_1799 createMissing(class_2487 tag) {
        String id = tag.method_10558("id");
        int count = Math.max(1, tag.method_10550("count"));
        String text = count == 1 ? id : count + "x " + id;
        return (class_1799)class_156.method_654((Object)new class_1799((class_1935)ModItems.MISSING_ITEM.get()), stack -> stack.method_57379((class_9331)ModDataComponents.MISSING_ITEM_DESC.get(), (Object)text));
    }

    public final boolean isValid() {
        return !this.invalid;
    }

    public final void setRawIcon(class_1799 rawIcon) {
        this.rawIcon = rawIcon;
    }

    public String getRawTitle() {
        if (!this.getQuestFile().isServerSide() && this.protoTranslations.containsKey((Object)TranslationKey.TITLE)) {
            return this.protoTranslations.get((Object)TranslationKey.TITLE);
        }
        return this.getQuestFile().getTranslationManager().getStringTranslation(this, this.getQuestFile().getLocale(), TranslationKey.TITLE).orElse("");
    }

    public void setRawTitle(String rawTitle) {
        this.setTranslatableValue(TranslationKey.TITLE, rawTitle);
        this.cachedTitle = null;
    }

    protected final void setTranslatableValue(TranslationKey translationKey, String value) {
        if (this.id != 0L) {
            String locale = this.getQuestFile().getLocale();
            this.getQuestFile().getTranslationManager().addTranslation(this, locale, translationKey, value);
            if (!this.getQuestFile().isServerSide()) {
                NetworkManager.sendToServer((class_8710)SyncTranslationMessageToServer.create(this, locale, translationKey, value));
            }
        } else if (!this.getQuestFile().isServerSide()) {
            this.protoTranslations.put(translationKey, value);
        }
    }

    protected final void setTranslatableValue(TranslationKey translationKey, List<String> value) {
        if (this.id != 0L) {
            String locale = this.getQuestFile().getLocale();
            this.getQuestFile().getTranslationManager().addTranslation(this, locale, translationKey, value);
            if (!this.getQuestFile().isServerSide()) {
                NetworkManager.sendToServer((class_8710)SyncTranslationMessageToServer.create(this, locale, translationKey, value));
            }
        }
    }

    public final String getProtoTranslation(TranslationKey key) {
        return this.protoTranslations.getOrDefault((Object)key, "");
    }

    public final void modifyTranslatableListValue(TranslationKey translationKey, Consumer<List<String>> setter) {
        if (translationKey.isListVal()) {
            List mutable = this.getQuestFile().getTranslationManager().getStringListTranslation(this, this.getQuestFile().getLocale(), translationKey).map(ArrayList::new).orElse(new ArrayList());
            setter.accept(mutable);
            this.setTranslatableValue(translationKey, List.copyOf(mutable));
        }
    }

    public static long parseCodeString(String id) {
        if (id.isEmpty() || id.equals("-")) {
            return 0L;
        }
        try {
            return Long.parseLong(id.charAt(0) == '#' ? id.substring(1) : id, 16);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static Optional<Long> parseHexId(String id) {
        try {
            return Optional.of(Long.parseLong(id, 16));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> titleToID(String s) {
        s = s.replace(' ', '_').replaceAll("\\W", "").toLowerCase().trim();
        while (s.startsWith("_")) {
            s = s.substring(1);
        }
        while (s.endsWith("_")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.isEmpty() ? Optional.empty() : Optional.of(s);
    }

    public final String getCodeString() {
        return QuestObjectBase.getCodeString(this.id);
    }

    public final String toString() {
        return this.getCodeString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return Long.hashCode(this.id);
    }

    public abstract QuestObjectType getObjectType();

    public abstract BaseQuestFile getQuestFile();

    public Set<String> getTags() {
        if (this.tags.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.cachedTags == null) {
            this.cachedTags = new LinkedHashSet<String>(this.tags);
        }
        return this.cachedTags;
    }

    public boolean hasTag(String tag) {
        return !this.tags.isEmpty() && this.getTags().contains(tag);
    }

    public void forceProgress(TeamData teamData, ProgressChange progressChange) {
    }

    public final void forceProgressRaw(TeamData teamData, ProgressChange progressChange) {
        if (teamData.isLocked()) {
            return;
        }
        teamData.clearCachedProgress();
        sendNotifications = progressChange.shouldNotify() ? Tristate.TRUE : Tristate.FALSE;
        this.forceProgress(teamData, progressChange);
        sendNotifications = Tristate.DEFAULT;
        teamData.clearCachedProgress();
        teamData.markDirty();
    }

    @Nullable
    public Chapter getQuestChapter() {
        return null;
    }

    public long getParentID() {
        return 1L;
    }

    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        if (!this.rawIcon.method_7960()) {
            class_1799.field_49747.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.rawIcon).ifSuccess(t -> nbt.method_10566("icon", t));
        }
        if (!this.tags.isEmpty()) {
            nbt.method_10566("tags", (class_2520)class_156.method_654((Object)new class_2499(), l -> {
                for (String s : this.tags) {
                    l.add((Object)class_2519.method_23256((String)s));
                }
            }));
        }
    }

    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        this.rawIcon = QuestObjectBase.singleItemOrMissingFromNBT((class_2520)nbt.method_10562("icon"), provider);
        class_2499 tagsList = nbt.method_10554("tags", 8);
        this.tags = new ArrayList<String>(tagsList.size());
        for (int i = 0; i < tagsList.size(); ++i) {
            this.tags.add(tagsList.method_10608(i));
        }
        if (nbt.method_10545("custom_id")) {
            this.tags.add(nbt.method_10558("custom_id"));
        }
    }

    public void writeNetData(class_9129 buffer) {
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)2, (!this.rawIcon.method_7960() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (!this.tags.isEmpty() ? 1 : 0) != 0);
        buffer.method_10804(flags);
        if (!this.rawIcon.method_7960()) {
            class_1799.field_49268.encode((Object)buffer, (Object)this.rawIcon);
        }
        if (!this.tags.isEmpty()) {
            NetUtils.writeStrings((class_2540)buffer, this.tags);
        }
    }

    public void readNetData(class_9129 buffer) {
        int flags = buffer.method_10816();
        this.rawIcon = Bits.getFlag((int)flags, (int)2) ? (class_1799)class_1799.field_49268.decode((Object)buffer) : class_1799.field_8037;
        this.tags = new ArrayList<String>(0);
        if (Bits.getFlag((int)flags, (int)4)) {
            NetUtils.readStrings((class_2540)buffer, this.tags);
        }
    }

    protected boolean hasTitleConfig() {
        return true;
    }

    protected boolean hasIconConfig() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        if (this.hasTitleConfig()) {
            config.addString("title", this.getRawTitle(), this::setRawTitle, "").setNameKey("ftbquests.title").setOrder(-127);
        }
        if (this.hasIconConfig()) {
            ((ConfigIconItemStack)config.add("icon", (ConfigValue)new ConfigIconItemStack(), (Object)this.rawIcon, v -> {
                this.rawIcon = v;
            }, (Object)class_1799.field_8037)).setNameKey("ftbquests.icon").setOrder(-126);
        }
        config.addList("tags", this.tags, (ConfigValue)new StringConfig(TAG_PATTERN), (Object)"").setNameKey("ftbquests.tags").setOrder(-125);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract class_2561 getAltTitle();

    @Environment(value=EnvType.CLIENT)
    public abstract Icon getAltIcon();

    @Environment(value=EnvType.CLIENT)
    public final class_2561 getTitle() {
        if (this.cachedTitle != null) {
            return this.cachedTitle.method_27661();
        }
        this.cachedTitle = !this.getRawTitle().isEmpty() ? TextUtils.parseRawText(this.getRawTitle(), this.holderLookup()) : this.getAltTitle();
        return this.cachedTitle.method_27661();
    }

    @Environment(value=EnvType.CLIENT)
    public final class_5250 getMutableTitle() {
        return this.getTitle().method_27661();
    }

    @Environment(value=EnvType.CLIENT)
    public final Icon getIcon() {
        if (this.cachedIcon == null) {
            if (!this.rawIcon.method_7960()) {
                this.cachedIcon = CustomIconItem.getIcon(this.rawIcon);
            }
            if (this.cachedIcon == null || this.cachedIcon.isEmpty()) {
                this.cachedIcon = (Icon)ThemeProperties.ICON.get(this);
            }
            if (this.cachedIcon.isEmpty()) {
                this.cachedIcon = this.getAltIcon();
            }
        }
        return this.cachedIcon;
    }

    public void deleteSelf() {
        this.getQuestFile().remove(this.id);
    }

    public void deleteChildren() {
    }

    @Environment(value=EnvType.CLIENT)
    public void editedFromGUI() {
        ClientQuestFile.INSTANCE.refreshGui();
    }

    public void editedFromGUIOnServer() {
    }

    public void onCreated() {
    }

    public Optional<String> getPath() {
        return Optional.empty();
    }

    public void clearCachedData() {
        this.cachedIcon = null;
        this.cachedTitle = null;
        this.cachedTags = null;
    }

    public ConfigGroup createSubGroup(ConfigGroup group) {
        return group.getOrCreateSubgroup(this.getObjectType().getId());
    }

    @Environment(value=EnvType.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        final ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
            gui.run();
            if (accepted && this.validateEditedConfig()) {
                NetworkManager.sendToServer((class_8710)EditObjectMessage.forQuestObject(this));
            }
        }){

            public class_2561 getName() {
                class_5250 type = class_2561.method_43470((String)" [").method_10852((class_2561)class_2561.method_43471((String)("ftbquests." + QuestObjectBase.this.getObjectType().getId()))).method_27693("]").method_27692(QuestObjectBase.this.getObjectType().getColor());
                return class_2561.method_43473().method_10852((class_2561)QuestObjectBase.this.getTitle().method_27661().method_27692(class_124.field_1073)).method_10852((class_2561)type);
            }
        };
        this.fillConfigGroup(this.createSubGroup(group));
        new EditConfigScreen(this, group){

            public class_2561 getTitle() {
                return group.getName();
            }
        }.openGui();
    }

    protected boolean validateEditedConfig() {
        return true;
    }

    public Set<RecipeModHelper.Components> componentsToRefresh() {
        return EnumSet.noneOf(RecipeModHelper.Components.class);
    }

    public static <T extends QuestObjectBase> T copy(T orig, Supplier<T> factory) {
        QuestObjectBase copied = (QuestObjectBase)factory.get();
        if (copied == null) {
            return null;
        }
        class_2487 tag = new class_2487();
        orig.writeData(tag, orig.holderLookup());
        copied.readData(tag, orig.holderLookup());
        return (T)copied;
    }

    @Override
    public int compareTo(@NotNull QuestObjectBase other) {
        int typeCmp = Integer.compare(this.getObjectType().ordinal(), other.getObjectType().ordinal());
        return typeCmp == 0 ? this.getTitle().getString().toLowerCase().compareTo(other.getTitle().getString().toLowerCase()) : typeCmp;
    }

    public class_7225.class_7874 holderLookup() {
        return this.getQuestFile().holderLookup();
    }

    protected class_2487 saveItemSingleLine(class_1799 stack) {
        if (stack.method_7960()) {
            return new SNBTCompoundTag();
        }
        return (class_2487)class_156.method_654((Object)SNBTCompoundTag.of((class_2520)stack.method_57358(this.holderLookup())), SNBTCompoundTag::singleLine);
    }
}

