/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import com.mojang.datafixers.util.Either;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.net.SyncTranslationMessageToClient;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.translation.TranslationKey;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public record SyncTranslationMessageToServer(long id, String locale, TranslationKey subKey, Either<String, List<String>> val) implements class_8710
{
    public static final class_8710.class_9154<SyncTranslationMessageToServer> TYPE = new class_8710.class_9154(FTBQuestsAPI.rl("sync_translation_to_server"));
    public static class_9139<class_2540, SyncTranslationMessageToServer> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_48551, SyncTranslationMessageToServer::id, (class_9139)class_9135.field_48554, SyncTranslationMessageToServer::locale, (class_9139)NetworkHelper.enumStreamCodec(TranslationKey.class), SyncTranslationMessageToServer::subKey, (class_9139)class_9135.method_57995((class_9139)class_9135.field_48554, (class_9139)class_9135.field_48554.method_56433(class_9135.method_56374(ArrayList::new))), SyncTranslationMessageToServer::val, SyncTranslationMessageToServer::new);

    public static SyncTranslationMessageToServer create(QuestObjectBase obj, String locale, TranslationKey subKey, String text) {
        return new SyncTranslationMessageToServer(obj.id, locale, subKey, subKey.validate((Either<String, List<String>>)Either.left((Object)text)));
    }

    public static SyncTranslationMessageToServer create(QuestObjectBase obj, String locale, TranslationKey subKey, List<String> list) {
        return new SyncTranslationMessageToServer(obj.id, locale, subKey, subKey.validate((Either<String, List<String>>)Either.right(list)));
    }

    public SyncTranslationMessageToClient createResponse() {
        return new SyncTranslationMessageToClient(this.id, this.locale, this.subKey, this.val);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(SyncTranslationMessageToServer message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            QuestObjectBase object;
            ServerQuestFile file;
            if (NetUtils.canEdit(context) && (file = ServerQuestFile.INSTANCE).isValid() && (object = file.getBase(message.id)) != null) {
                message.val.ifLeft(str -> file.getTranslationManager().addTranslation(object, message.locale, message.subKey, (String)str)).ifRight(list -> file.getTranslationManager().addTranslation(object, message.locale, message.subKey, (List<String>)list));
                NetworkHelper.sendToAll((MinecraftServer)file.server, (class_8710)message.createResponse());
            }
        });
    }
}

