/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.ftb.mods.ftblibrary.api.sidebar.ButtonOverlayRender;
import dev.ftb.mods.ftblibrary.api.sidebar.SidebarButtonCreatedEvent;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.PinnedQuestsTracker;
import dev.ftb.mods.ftbquests.client.TaskScreenRenderer;
import dev.ftb.mods.ftbquests.client.fabric.FTBQuestsClientEventHandlerImpl;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.item.LootCrateItem;
import dev.ftb.mods.ftbquests.net.RequestTranslationTableMessage;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.StructureTask;
import dev.ftb.mods.ftbquests.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbquests.registry.ModItems;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1935;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsClientEventHandler {
    private static final class_2960 QUESTS_BUTTON = FTBQuestsAPI.rl("quests");
    static boolean creativeTabRebuildPending = false;
    private List<ObservationTask> observationTasks = null;
    private ObservationTask currentlyObserving = null;
    private long currentlyObservingTicks = 0L;
    public static class_1058 inputOnlySprite;
    public static class_1058 tankSprite;
    public static class_1058 feEnergyEmptySprite;
    public static class_1058 feEnergyFullSprite;
    public static class_1058 trEnergyEmptySprite;
    public static class_1058 trEnergyFullSprite;

    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::registerItemColors);
        ClientLifecycleEvent.CLIENT_SETUP.register(this::registerBERs);
        SidebarButtonCreatedEvent.EVENT.register(this::onSidebarButtonCreated);
        ClearFileCacheEvent.EVENT.register(this::onFileCacheClear);
        ClientTickEvent.CLIENT_PRE.register(this::onKeyEvent);
        CustomClickEvent.EVENT.register(this::onCustomClick);
        ClientTickEvent.CLIENT_PRE.register(this::onClientTick);
        ClientGuiEvent.RENDER_HUD.register(this::onScreenRender);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(this::onPlayerLogin);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::onPlayerLogout);
    }

    public static void onTextureStitchPost(class_1059 textureAtlas) {
        if (textureAtlas.method_24106().equals((Object)class_1723.field_21668)) {
            inputOnlySprite = textureAtlas.method_4608(TaskScreenRenderer.INPUT_ONLY_TEXTURE);
            tankSprite = textureAtlas.method_4608(TaskScreenRenderer.TANK_TEXTURE);
            feEnergyEmptySprite = textureAtlas.method_4608(TaskScreenRenderer.FE_ENERGY_EMPTY_TEXTURE);
            feEnergyFullSprite = textureAtlas.method_4608(TaskScreenRenderer.FE_ENERGY_FULL_TEXTURE);
            trEnergyEmptySprite = textureAtlas.method_4608(TaskScreenRenderer.TR_ENERGY_EMPTY_TEXTURE);
            trEnergyFullSprite = textureAtlas.method_4608(TaskScreenRenderer.TR_ENERGY_FULL_TEXTURE);
        }
    }

    private void registerBERs(class_310 minecraft) {
        BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntityTypes.CORE_TASK_SCREEN.get()), FTBQuestsClientEventHandler.taskScreenRenderer());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_5614<TaskScreenBlockEntity> taskScreenRenderer() {
        return FTBQuestsClientEventHandlerImpl.taskScreenRenderer();
    }

    private void registerItemColors(class_310 minecraft) {
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> {
            LootCrate crate = LootCrateItem.getCrate(stack, true);
            return crate == null ? -1 : 0xFF000000 | crate.getColor().rgb();
        }, (class_1935[])new class_1935[]{(class_1935)ModItems.LOOTCRATE.get()});
    }

    private void onSidebarButtonCreated(SidebarButtonCreatedEvent event) {
        if (event.getButton().getId().equals((Object)QUESTS_BUTTON)) {
            event.getButton().addOverlayRender(ButtonOverlayRender.ofSimpleString(() -> {
                if (ClientQuestFile.exists()) {
                    if (ClientQuestFile.INSTANCE.isDisableGui() && !ClientQuestFile.INSTANCE.canEdit()) {
                        return "[X]";
                    }
                    if (ClientQuestFile.INSTANCE.selfTeamData.isLocked()) {
                        return "[X]";
                    }
                    if (ClientQuestFile.INSTANCE.selfTeamData.hasUnclaimedRewards(class_310.method_1551().field_1724.method_5667(), ClientQuestFile.INSTANCE)) {
                        return "[!]";
                    }
                }
                return "";
            }));
        }
    }

    private void onFileCacheClear(BaseQuestFile file) {
        if (!file.isServerSide()) {
            this.observationTasks = null;
        }
    }

    private void onKeyEvent(class_310 mc) {
        if (ClientQuestFile.exists() && (!ClientQuestFile.INSTANCE.isDisableGui() || ClientQuestFile.INSTANCE.canEdit()) && FTBQuestsClient.KEY_QUESTS.method_1436()) {
            ClientQuestFile.openGui();
        }
    }

    private EventResult onCustomClick(CustomClickEvent event) {
        if (event.id().method_12836().equals("ftbquests") && "open_gui".equals(event.id().method_12832())) {
            double mx = class_310.method_1551().field_1729.method_1603();
            double my = class_310.method_1551().field_1729.method_1604();
            class_310.method_1551().method_1507(null);
            if (ClientQuestFile.openGui() != null) {
                class_3675.method_15984((long)class_310.method_1551().method_22683().method_4490(), (int)212993, (double)mx, (double)my);
            }
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private void onClientTick(class_310 mc) {
        if (mc.field_1687 != null && ClientQuestFile.exists() && mc.field_1724 != null) {
            PinnedQuestsTracker.INSTANCE.tick(ClientQuestFile.INSTANCE);
            if (this.observationTasks == null) {
                this.observationTasks = ClientQuestFile.INSTANCE.collect(ObservationTask.class);
            }
            if (this.observationTasks.isEmpty()) {
                return;
            }
            this.currentlyObserving = null;
            TeamData selfTeamData = ClientQuestFile.INSTANCE.selfTeamData;
            if (mc.field_1765 != null && mc.field_1765.method_17783() != class_239.class_240.field_1333) {
                for (ObservationTask task : this.observationTasks) {
                    if (selfTeamData.isCompleted(task) || !task.observe((class_1657)mc.field_1724, mc.field_1765) || !selfTeamData.canStartTasks(task.getQuest())) continue;
                    this.currentlyObserving = task;
                    break;
                }
            }
            if (this.currentlyObserving != null) {
                if (!mc.method_1493()) {
                    ++this.currentlyObservingTicks;
                }
                if (this.currentlyObservingTicks >= this.currentlyObserving.getTimer()) {
                    NetworkManager.sendToServer((class_8710)new SubmitTaskMessage(this.currentlyObserving.id));
                    selfTeamData.addProgress(this.currentlyObserving, 1L);
                    this.currentlyObserving = null;
                    this.currentlyObservingTicks = 0L;
                }
            } else {
                this.currentlyObservingTicks = 0L;
            }
        }
    }

    private void onPlayerLogin(class_746 localPlayer) {
        String locale;
        if (creativeTabRebuildPending) {
            FTBQuestsClient.rebuildCreativeTabs();
            creativeTabRebuildPending = false;
        }
        if (!(locale = (String)FTBQuestsClientConfig.EDITING_LOCALE.get()).isEmpty() && !locale.equals(class_310.method_1551().field_1690.field_1883)) {
            NetworkManager.sendToServer((class_8710)new RequestTranslationTableMessage(locale));
        }
    }

    private void onPlayerLogout(@Nullable class_746 localPlayer) {
        StructureTask.syncKnownStructureList(List.of());
    }

    private void onScreenRender(class_332 graphics, class_9779 tickDelta) {
        if (!ClientQuestFile.exists()) {
            return;
        }
        if (this.currentlyObserving != null) {
            this.renderCurrentlyObserving(class_310.method_1551(), graphics, tickDelta);
        }
        PinnedQuestsTracker.INSTANCE.render(class_310.method_1551(), graphics);
    }

    private void renderCurrentlyObserving(class_310 mc, class_332 graphics, class_9779 tickDelta) {
        int cx = mc.method_22683().method_4486() / 2;
        int cy = mc.method_22683().method_4502() / 2;
        class_5250 txt = this.currentlyObserving.getMutableTitle().method_27695(new class_124[]{class_124.field_1054, class_124.field_1073});
        int txtWidth = mc.field_1772.method_27525((class_5348)txt);
        int boxWidth = Math.max(txtWidth, 100);
        Color4I.DARK_GRAY.withAlpha(130).draw(graphics, cx - boxWidth / 2 - 3, cy - 63, boxWidth + 6, 29);
        GuiHelper.drawHollowRect((class_332)graphics, (int)(cx - boxWidth / 2 - 3), (int)(cy - 63), (int)(boxWidth + 6), (int)29, (Color4I)Color4I.DARK_GRAY, (boolean)false);
        graphics.method_27535(mc.field_1772, (class_2561)txt, cx - txtWidth / 2, cy - 60, 0xFFFFFF);
        double completed = (double)((float)this.currentlyObservingTicks + tickDelta.method_60637(false)) / (double)this.currentlyObserving.getTimer();
        GuiHelper.drawHollowRect((class_332)graphics, (int)(cx - boxWidth / 2), (int)(cy - 49), (int)boxWidth, (int)12, (Color4I)Color4I.DARK_GRAY, (boolean)false);
        Color4I.LIGHT_BLUE.withAlpha(130).draw(graphics, cx - boxWidth / 2 + 1, cy - 48, (int)(((double)boxWidth - 2.0) * completed), 10);
        String pctTxt = this.currentlyObservingTicks * 100L / this.currentlyObserving.getTimer() + "%";
        graphics.method_25303(mc.field_1772, pctTxt, cx - mc.field_1772.method_1727(pctTxt) / 2, cy - 47, 0xFFFFFF);
    }
}

