/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import dev.ftb.mods.ftbquests.item.LootCrateItem;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9331;

public class LootCrateOpenerBlockEntity
extends class_2586 {
    private static final ItemEntry EMPTY_ENTRY = new ItemEntry(class_1799.field_8037);
    private static final int MAX_ITEM_TYPES = 64;
    private UUID owner = null;
    private final Map<ItemEntry, Integer> outputs = new LinkedHashMap<ItemEntry, Integer>();

    public LootCrateOpenerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntityTypes.LOOT_CRATE_OPENER.get(), blockPos, blockState);
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.outputs.clear();
        class_2499 itemTag = compoundTag.method_10554("Items", 10);
        itemTag.forEach(el -> {
            if (el instanceof class_2487) {
                class_2487 tag = (class_2487)el;
                class_1799 stack = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)tag.method_10562("item"));
                int amount = tag.method_10550("amount");
                this.outputs.put(new ItemEntry(stack), amount);
            }
        });
        this.owner = compoundTag.method_25928("Owner") ? compoundTag.method_25926("Owner") : null;
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        class_2499 itemTag = new class_2499();
        this.outputs.forEach((item, amount) -> {
            class_2487 tag = new class_2487();
            tag.method_10566("item", item.stack.method_57376(provider, (class_2520)new class_2487()));
            tag.method_10569("amount", amount.intValue());
            itemTag.add((Object)tag);
        });
        if (!itemTag.isEmpty()) {
            compoundTag.method_10566("Items", (class_2520)itemTag);
        }
        if (this.owner != null) {
            compoundTag.method_25927("Owner", this.owner);
        }
    }

    protected void method_57568(class_2586.class_9473 dataComponentInput) {
        super.method_57568(dataComponentInput);
        this.outputs.clear();
        ((class_9288)dataComponentInput.method_58695((class_9331)ModDataComponents.LOOT_CRATE_ITEMS.get(), (Object)class_9288.field_49334)).method_57489().forEach(stack -> this.outputs.put(new ItemEntry((class_1799)stack), stack.method_7947()));
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840((class_9331)ModDataComponents.LOOT_CRATE_ITEMS.get(), (Object)class_9288.method_57493(this.outputs.keySet().stream().map(ItemEntry::stack).toList()));
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public int getOutputCount() {
        return this.outputs.values().stream().mapToInt(v -> v).sum();
    }

    protected int _getSlots() {
        return 2;
    }

    protected class_1799 _getStackInSlot(int slot) {
        return slot == 0 ? class_1799.field_8037 : this.outputs.keySet().stream().findFirst().orElse(LootCrateOpenerBlockEntity.EMPTY_ENTRY).stack;
    }

    protected class_1799 _insertItem(int slot, class_1799 stack, boolean simulate) {
        if (slot != 0 || this.field_11863 == null || this.field_11863.method_8503() == null || this.field_11863.field_9236 || this.outputs.size() >= 64) {
            return stack;
        }
        LootCrate crate = LootCrateItem.getCrate(stack, false);
        if (crate == null) {
            return stack;
        }
        class_3222 player = this.owner == null ? null : this.field_11863.method_8503().method_3760().method_14602(this.owner);
        boolean update = false;
        int nAttempts = stack.method_7947();
        for (WeightedReward wr : crate.getTable().generateWeightedRandomRewards(this.field_11863.method_8409(), nAttempts, true)) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            if (!wr.getReward().automatedClaimPre(this, stacks, this.field_11863.field_9229, this.owner, player)) continue;
            update = true;
            if (simulate) continue;
            for (class_1799 stack1 : stacks) {
                ItemEntry entry = new ItemEntry(stack1);
                int newAmount = this.outputs.getOrDefault(entry, 0) + stack1.method_7947();
                this.outputs.put(entry, newAmount);
            }
            wr.getReward().automatedClaimPost(this, this.owner, player);
        }
        if (update && !simulate) {
            this.method_5431();
        }
        return class_1799.field_8037;
    }

    protected boolean _isItemValid(int slot, class_1799 stack) {
        return slot == 0 && LootCrateItem.getCrate(stack, this.field_11863.field_9236) != null;
    }

    protected class_1799 _extractItem(int slot, int amount, boolean simulate) {
        if (this.field_11863 == null || slot == 0 || amount <= 0 || this.outputs.isEmpty()) {
            return class_1799.field_8037;
        }
        ItemEntry entry = (ItemEntry)this.outputs.keySet().stream().findFirst().orElseThrow();
        class_1799 stack1 = entry.stack().method_7972();
        int count = this.outputs.get(entry);
        int toExtract = Math.min(count, Math.min(amount, stack1.method_7914()));
        stack1.method_7939(toExtract);
        if (!simulate && !this.field_11863.field_9236) {
            if ((count -= toExtract) <= 0) {
                this.outputs.remove(entry);
            } else {
                this.outputs.put(entry, count);
            }
            this.method_5431();
        }
        return stack1;
    }

    private record ItemEntry(class_1799 stack) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return class_1799.method_31577((class_1799)this.stack, (class_1799)((ItemEntry)o).stack);
        }

        @Override
        public int hashCode() {
            return class_1799.method_57355((class_1799)this.stack);
        }
    }
}

