/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.block.QuestBarrierBlock;
import dev.ftb.mods.ftbquests.block.entity.EditableBlockEntity;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.net.BlockConfigResponseMessage;
import dev.ftb.mods.ftbquests.registry.ModBlocks;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBarrierBlockEntity
extends EditableBlockEntity {
    protected String objStr = "";
    protected class_2680 camo = null;
    private boolean invisibleWhenOpen = false;
    private class_1799 skin = class_1799.field_8037;
    private TeleportData teleportData = TeleportData.NONE;

    public BaseBarrierBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        if (blockEntity instanceof BaseBarrierBlockEntity) {
            boolean completed;
            BaseBarrierBlockEntity barrier = (BaseBarrierBlockEntity)blockEntity;
            if (level.field_9236 && FTBQuestsClient.isClientDataLoaded() && level.method_8510() % 5L == 0L && (completed = barrier.isOpen(FTBQuestsClient.getClientPlayer())) != (Boolean)blockState.method_11654((class_2769)QuestBarrierBlock.OPEN)) {
                level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)QuestBarrierBlock.OPEN, (Comparable)Boolean.valueOf(completed)), 10);
                blockEntity.method_5431();
                barrier.forceAppearanceUpdate();
            }
        }
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10545("Object")) {
            this.objStr = tag.method_10558("Object");
            this.skin = class_1799.field_8037;
        } else {
            BarrierSavedData data = BarrierSavedData.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("savedData")).result().orElse(BarrierSavedData.DEFAULT);
            this.applySavedData(data);
        }
    }

    public void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        BarrierSavedData.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)BarrierSavedData.fromBlockEntity(this)).ifSuccess(tag -> compoundTag.method_10566("savedData", tag));
    }

    protected void method_57568(class_2586.class_9473 dataComponentInput) {
        super.method_57568(dataComponentInput);
        this.applySavedData((BarrierSavedData)dataComponentInput.method_58695((class_9331)ModDataComponents.BARRIER_SAVED.get(), (Object)BarrierSavedData.DEFAULT));
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840((class_9331)ModDataComponents.BARRIER_SAVED.get(), (Object)BarrierSavedData.fromBlockEntity(this));
    }

    protected void applySavedData(BarrierSavedData data) {
        this.objStr = data.objStr;
        this.setSkin(data.skin);
        this.setInvisibleWhenOpen(data.invisibleWhenOpen);
        this.teleportData = data.teleportData.orElse(TeleportData.NONE);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    public void method_5431() {
        if (this.field_11863 instanceof class_3218) {
            this.field_11863.method_8524(this.method_11016());
        }
    }

    public void updateFromString(String objStr) {
        this.objStr = objStr;
        this.method_5431();
    }

    public abstract boolean isOpen(class_1657 var1);

    protected abstract void addConfigEntries(ConfigGroup var1);

    public ConfigGroup fillConfigGroup() {
        ConfigGroup group = new ConfigGroup("ftbquests.barrier", accepted -> {
            if (accepted) {
                NetworkManager.sendToServer((class_8710)new BlockConfigResponseMessage(this.method_11016(), this.method_38244((class_7225.class_7874)this.method_10997().method_30349())));
            }
        });
        group.setNameKey(this.method_11010().method_26204().method_9539());
        this.addConfigEntries(group);
        if (Platform.isForgeLike()) {
            ConfigGroup appearance = group.getOrCreateSubgroup("appearance").setNameKey("ftbquests.quest.appearance");
            ((ItemStackConfig)appearance.add("skin", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getSkin(), this::setSkin, (Object)class_1799.field_8037)).withFilter(stack -> stack.method_7909() instanceof class_1747).setNameKey("block.ftbquests.screen.skin");
            appearance.addBool("invis_when_open", this.isInvisibleWhenOpen(), this::setInvisibleWhenOpen, false).setNameKey("block.ftbquests.barrier.invis_when_open");
        }
        ConfigGroup teleport = group.getOrCreateSubgroup("teleport").setNameKey("ftbquests.barrier.teleport");
        teleport.addBool("enabled", this.teleportData.enabled, v -> {
            this.teleportData = this.teleportData.withEnabled((boolean)v);
        }, false);
        teleport.addBool("relative", this.teleportData.relative, v -> {
            this.teleportData = this.teleportData.withRelative((boolean)v);
        }, false);
        teleport.addInt("dest_x", this.teleportData.dest.method_10263(), v -> {
            this.teleportData = this.teleportData.withDestX((int)v);
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        teleport.addInt("dest_y", this.teleportData.dest.method_10264(), v -> {
            this.teleportData = this.teleportData.withDestY((int)v);
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        teleport.addInt("dest_z", this.teleportData.dest.method_10260(), v -> {
            this.teleportData = this.teleportData.withDestZ((int)v);
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        teleport.addDouble("pitch", (double)this.teleportData.pitch, v -> {
            this.teleportData = this.teleportData.withPitch(v.floatValue());
        }, 0.0, -90.0, 90.0);
        teleport.addDouble("yaw", (double)this.teleportData.yaw, v -> {
            this.teleportData = this.teleportData.withYaw(v.floatValue());
        }, 0.0, 0.0, 360.0);
        teleport.addString("dimension", this.teleportData.dimStr(), v -> {
            this.teleportData = this.teleportData.withDimId((String)v);
        }, "");
        return group;
    }

    public class_1799 getSkin() {
        return this.skin;
    }

    public void setSkin(class_1799 skin) {
        this.skin = skin;
        this.forceAppearanceUpdate();
        this.method_5431();
    }

    public boolean isInvisibleWhenOpen() {
        return this.invisibleWhenOpen;
    }

    public void setInvisibleWhenOpen(boolean invisibleWhenOpen) {
        this.invisibleWhenOpen = invisibleWhenOpen;
        this.forceAppearanceUpdate();
        this.method_5431();
    }

    public void forceAppearanceUpdate() {
        this.camo = null;
    }

    public class_2680 getClientAppearance() {
        if (this.camo == null) {
            if (this.isOpen(FTBQuestsClient.getClientPlayer())) {
                this.camo = this.invisibleWhenOpen ? class_2246.field_10124.method_9564() : (class_2680)((class_2248)ModBlocks.BARRIER.get()).method_9564().method_11657((class_2769)QuestBarrierBlock.OPEN, (Comparable)Boolean.valueOf(true));
            } else {
                class_2680 class_26802;
                class_1792 class_17922 = this.skin.method_7909();
                if (class_17922 instanceof class_1747) {
                    class_1747 bi = (class_1747)class_17922;
                    class_26802 = bi.method_7711().method_9564();
                } else {
                    class_26802 = (class_2680)((class_2248)ModBlocks.BARRIER.get()).method_9564().method_11657((class_2769)QuestBarrierBlock.OPEN, (Comparable)Boolean.valueOf(false));
                }
                this.camo = class_26802;
            }
        }
        return this.camo;
    }

    @Override
    public boolean hasPermissionToEdit(class_1657 player) {
        return FTBQuestsAPI.api().getQuestFile(this.field_11863.field_9236).getTeamData(player).map(team -> team.getCanEdit(player)).orElse(false);
    }

    public Optional<TeleportData> optionalTeleportData() {
        return this.teleportData.equals(TeleportData.NONE) ? Optional.empty() : Optional.of(this.teleportData);
    }

    public record TeleportData(boolean enabled, boolean relative, class_2338 dest, float pitch, float yaw, Optional<class_5321<class_1937>> dimId) {
        public static final Codec<TeleportData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)false).forGetter(TeleportData::enabled), (App)Codec.BOOL.optionalFieldOf("relative", (Object)false).forGetter(TeleportData::relative), (App)class_2338.field_25064.fieldOf("dest").forGetter(TeleportData::dest), (App)Codec.FLOAT.fieldOf("pitch").forGetter(TeleportData::pitch), (App)Codec.FLOAT.fieldOf("yaw").forGetter(TeleportData::yaw), (App)class_5321.method_39154((class_5321)class_7924.field_41223).optionalFieldOf("dim_id").forGetter(TeleportData::dimId)).apply((Applicative)builder, TeleportData::new));
        public static final class_9139<class_9129, TeleportData> STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.field_48547, TeleportData::enabled, (class_9139)class_9135.field_48547, TeleportData::relative, (class_9139)class_2338.field_48404, TeleportData::dest, (class_9139)class_9135.field_48552, TeleportData::pitch, (class_9139)class_9135.field_48552, TeleportData::yaw, (class_9139)class_9135.method_56382((class_9139)class_5321.method_56038((class_5321)class_7924.field_41223)), TeleportData::dimId, TeleportData::new);
        public static final TeleportData NONE = new TeleportData(false, false, class_2338.field_10980, 0.0f, 0.0f, Optional.empty());

        public TeleportData withEnabled(boolean enabled) {
            return new TeleportData(enabled, this.relative, this.dest, this.pitch, this.yaw, this.dimId);
        }

        public TeleportData withRelative(boolean relative) {
            return new TeleportData(this.enabled, relative, this.dest, this.pitch, this.yaw, this.dimId);
        }

        public TeleportData withPitch(float pitch) {
            return new TeleportData(this.enabled, this.relative, this.dest, pitch, this.yaw, this.dimId);
        }

        public TeleportData withYaw(float yaw) {
            return new TeleportData(this.enabled, this.relative, this.dest, this.pitch, yaw, this.dimId);
        }

        public TeleportData withDimId(String dimStr) {
            return this.withDimId(dimStr.isEmpty() || class_2960.method_12829((String)dimStr) == null ? null : class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)dimStr)));
        }

        public TeleportData withDimId(@Nullable class_5321<class_1937> dimId) {
            return new TeleportData(this.enabled, this.relative, this.dest, this.pitch, this.yaw, Optional.ofNullable(dimId));
        }

        public TeleportData withDestPos(class_2338 pos) {
            return new TeleportData(this.enabled, this.relative, pos, this.pitch, this.yaw, this.dimId);
        }

        public TeleportData withDestX(int x) {
            return this.withDestPos(new class_2338(x, this.dest.method_10264(), this.dest.method_10264()));
        }

        public TeleportData withDestY(int y) {
            return this.withDestPos(new class_2338(this.dest.method_10263(), y, this.dest.method_10264()));
        }

        public TeleportData withDestZ(int z) {
            return this.withDestPos(new class_2338(this.dest.method_10263(), this.dest.method_10264(), z));
        }

        public String dimStr() {
            return this.dimId.map(id -> id.method_29177().toString()).orElse("");
        }

        @Nullable
        public class_1937 getLevel(MinecraftServer server) {
            return this.dimId.map(arg_0 -> ((MinecraftServer)server).method_3847(arg_0)).orElse(null);
        }

        public TeleportData effectiveDest(class_2338 basePos) {
            return this.relative ? this.withDestPos(basePos.method_10081((class_2382)this.dest)) : this;
        }

        public void teleportPlayer(class_3222 player) {
            if (player != null && player.method_5682() != null && this.enabled) {
                class_243 dest = this.dest().method_61082();
                class_1937 destLevel = Objects.requireNonNullElse(this.getLevel(player.method_5682()), player.method_37908());
                if (destLevel instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)destLevel;
                    player.method_14251(serverLevel, dest.field_1352, dest.field_1351, dest.field_1350, this.yaw(), this.pitch());
                    class_6880 sound = class_7923.field_41172.method_47983((Object)class_3417.field_46945);
                    player.field_13987.method_14364((class_2596)new class_2767(sound, class_3419.field_15248, dest.field_1352, dest.field_1351, dest.field_1350, 0.5f, 1.0f, serverLevel.method_8409().method_43055()));
                }
            }
        }
    }

    public record BarrierSavedData(String objStr, class_1799 skin, boolean invisibleWhenOpen, Optional<TeleportData> teleportData) {
        public static final BarrierSavedData DEFAULT = new BarrierSavedData("", class_1799.field_8037, false, Optional.empty());
        public static final Codec<BarrierSavedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.optionalFieldOf("object", (Object)"").forGetter(BarrierSavedData::objStr), (App)class_1799.field_24671.optionalFieldOf("skin", (Object)class_1799.field_8037).forGetter(BarrierSavedData::skin), (App)Codec.BOOL.optionalFieldOf("invis_when_open", (Object)false).forGetter(BarrierSavedData::invisibleWhenOpen), (App)TeleportData.CODEC.optionalFieldOf("teleport").forGetter(BarrierSavedData::teleportData)).apply((Applicative)builder, BarrierSavedData::new));
        public static class_9139<class_9129, BarrierSavedData> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_48554, BarrierSavedData::objStr, (class_9139)class_1799.field_49268, BarrierSavedData::skin, (class_9139)class_9135.field_48547, BarrierSavedData::invisibleWhenOpen, (class_9139)class_9135.method_56382(TeleportData.STREAM_CODEC), BarrierSavedData::teleportData, BarrierSavedData::new);

        public static BarrierSavedData fromBlockEntity(BaseBarrierBlockEntity b) {
            return new BarrierSavedData(b.objStr, b.skin, b.invisibleWhenOpen, b.optionalTeleportData());
        }

        public void addTooltipInfo(BarrierSavedData data, List<class_2561> tooltip, String what) {
            tooltip.add((class_2561)class_2561.method_43469((String)("item.ftbquests.barrier.object." + what), (Object[])new Object[]{data.objStr().isEmpty() ? "-" : data.objStr}).method_27692(class_124.field_1080));
            if (Platform.isForgeLike() && !data.skin().method_7960()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.ftbquests.barrier.skin", (Object[])new Object[]{data.skin().method_7954()}).method_27692(class_124.field_1080));
            }
            tooltip.add((class_2561)class_2561.method_43469((String)"item.ftbquests.barrier.invis_when_open", (Object[])new Object[]{data.invisibleWhenOpen()}).method_27692(class_124.field_1080));
        }
    }
}

