/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenAuxBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.block.fabric.TaskScreenBlockImpl;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.item.ScreenBlockItem;
import dev.ftb.mods.ftbquests.net.BlockConfigRequestMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.registry.ModBlocks;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_8710;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class TaskScreenBlock
extends class_2237 {
    private static final MapCodec<TaskScreenBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TaskScreenBlock.method_54096()).and((App)Codec.INT.fieldOf("size").forGetter(TaskScreenBlock::getSize)).apply((Applicative)instance, TaskScreenBlock::new));
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_4970.class_2251 PROPS = class_4970.class_2251.method_9637().method_51517(class_1767.field_7963).method_9632(0.3f);
    private final int size;

    public TaskScreenBlock(class_4970.class_2251 props, int size) {
        super(props);
        this.size = size;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public int getSize() {
        return this.size;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return TaskScreenBlock.blockEntityProvider().create(blockPos, blockState);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2591.class_5559<TaskScreenBlockEntity> blockEntityProvider() {
        return TaskScreenBlockImpl.blockEntityProvider();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2591.class_5559<TaskScreenAuxBlockEntity> blockEntityAuxProvider() {
        return TaskScreenBlockImpl.blockEntityAuxProvider();
    }

    protected MapCodec<? extends TaskScreenBlock> method_53969() {
        return CODEC;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        if (!this.validatePlaceable(blockPlaceContext)) {
            return null;
        }
        return (class_2680)super.method_9605(blockPlaceContext).method_11657((class_2769)FACING, (Comparable)blockPlaceContext.method_8042().method_10153());
    }

    private boolean validatePlaceable(class_1750 ctx) {
        int screenSize = ScreenBlockItem.getSize(ctx.method_8041());
        if (screenSize == 1) {
            return true;
        }
        class_2350 facing = ctx.method_8042();
        return class_2338.method_23627((class_3341)TaskScreenBlock.getMultiblockBounds(ctx.method_8037(), this.getSize(), facing)).allMatch(pos -> ctx.method_8045().method_8320(pos).method_26166(ctx));
    }

    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1309 livingEntity, class_1799 itemStack) {
        super.method_9567(level, blockPos, blockState, livingEntity, itemStack);
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof TaskScreenBlockEntity) {
            TaskScreenBlockEntity coreScreen = (TaskScreenBlockEntity)class_25862;
            if (livingEntity instanceof class_3222) {
                class_3222 sp = (class_3222)livingEntity;
                ServerQuestFile.INSTANCE.getTeamData((class_1657)sp).ifPresent(d -> coreScreen.setTeamId(d.getTeamId()));
            }
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)FACING);
            class_2680 auxState = (class_2680)((class_2248)ModBlocks.AUX_SCREEN.get()).method_9564().method_11657((class_2769)FACING, (Comparable)facing);
            class_2338.method_23627((class_3341)TaskScreenBlock.getMultiblockBounds(blockPos, this.getSize(), facing)).filter(pos -> !pos.equals((Object)blockPos)).forEach(auxPos -> {
                level.method_8501(auxPos, auxState);
                class_2586 patt0$temp = level.method_8321(auxPos);
                if (patt0$temp instanceof TaskScreenAuxBlockEntity) {
                    TaskScreenAuxBlockEntity auxScreen = (TaskScreenAuxBlockEntity)patt0$temp;
                    auxScreen.setCoreScreen(coreScreen);
                }
            });
        }
    }

    public void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 newState, boolean isMoving) {
        class_2586 class_25862;
        if (blockState.method_26204() != newState.method_26204() && (class_25862 = level.method_8321(blockPos)) instanceof ITaskScreen) {
            ITaskScreen taskScreen = (ITaskScreen)class_25862;
            taskScreen.getCoreScreen().ifPresent(coreScreen -> {
                coreScreen.removeAllAuxScreens();
                if (coreScreen != taskScreen) {
                    level.method_8651(coreScreen.method_11016(), true, null);
                }
            });
            super.method_9536(blockState, level, blockPos, newState, isMoving);
        }
    }

    public float method_9594(class_2680 blockState, class_1657 player, class_1922 blockGetter, class_2338 blockPos) {
        ITaskScreen taskScreen;
        class_2586 class_25862 = player.method_37908().method_8321(blockPos);
        if (class_25862 instanceof ITaskScreen && (taskScreen = (ITaskScreen)class_25862).isIndestructible()) {
            return 0.0f;
        }
        return super.method_9594(blockState, player, blockGetter, blockPos);
    }

    protected class_1269 method_55766(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            class_2586 class_25862 = level.method_8321(blockPos);
            if (class_25862 instanceof ITaskScreen) {
                ITaskScreen taskScreen = (ITaskScreen)class_25862;
                if (taskScreen.hasPermissionToEdit((class_1657)sp)) {
                    taskScreen.getCoreScreen().ifPresent(coreScreen -> NetworkManager.sendToPlayer((class_3222)sp, (class_8710)new BlockConfigRequestMessage(coreScreen.method_11016(), BlockConfigRequestMessage.BlockType.TASK_SCREEN)));
                } else {
                    sp.method_7353((class_2561)class_2561.method_43471((String)"block.ftbquests.screen.no_permission").method_27692(class_124.field_1061), true);
                    return class_1269.field_5814;
                }
            }
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void method_9568(class_1799 itemStack, class_1792.class_9635 context, List<class_2561> list, class_1836 tooltipFlag) {
        super.method_9568(itemStack, context, list, tooltipFlag);
        class_9279 data = (class_9279)itemStack.method_57824(class_9334.field_49611);
        if (data != null) {
            Task task;
            class_2487 subTag = data.method_57461();
            BaseQuestFile questFile = FTBQuestsClient.getClientQuestFile();
            if (questFile != null && (task = questFile.getTask(subTag.method_10537("TaskID"))) != null) {
                list.add((class_2561)class_2561.method_43471((String)"ftbquests.chapter").method_27693(": ").method_10852((class_2561)task.getQuest().getChapter().getTitle().method_27661().method_27692(class_124.field_1054)));
                list.add((class_2561)class_2561.method_43471((String)"ftbquests.quest").method_27693(": ").method_10852((class_2561)task.getQuest().getMutableTitle().method_27692(class_124.field_1054)));
                list.add((class_2561)class_2561.method_43471((String)"ftbquests.task").method_27693(": ").method_10852((class_2561)task.getMutableTitle().method_27692(class_124.field_1054)));
            }
        }
    }

    public static class_3341 getMultiblockBounds(class_2338 corePos, int size, class_2350 facing) {
        if (size == 1) {
            return new class_3341(corePos);
        }
        int size2 = size / 2;
        facing = facing.method_10160();
        class_2338 pos1 = new class_2338(corePos.method_10263() - size2 * facing.method_10148(), corePos.method_10264(), corePos.method_10260() - size2 * facing.method_10165());
        class_2338 pos2 = new class_2338(corePos.method_10263() + size2 * facing.method_10148(), corePos.method_10264() + size - 1, corePos.method_10260() + size2 * facing.method_10165());
        return class_3341.method_34390((class_2382)pos1, (class_2382)pos2);
    }

    public static class Aux
    extends TaskScreenBlock {
        private static final MapCodec<Aux> CODEC = Aux.method_54094(Aux::new);

        public Aux(class_4970.class_2251 props) {
            super(props, 0);
        }

        @Override
        @Nullable
        public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
            return Aux.blockEntityAuxProvider().create(blockPos, blockState);
        }

        protected MapCodec<Aux> method_53969() {
            return CODEC;
        }
    }
}

