/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.client.particle;

import net.critical_strike.client.particle.TemplateParticleEffect;
import net.critical_strike.client.particle.TemplateParticleType;
import net.critical_strike.client.util.Color;
import net.critical_strike.fx.CriticalStrikeParticles;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class CriticalStrikeParticle
extends class_4003 {
    private static final class_5819 RANDOM = class_5819.method_43047();
    private final class_4002 spriteProvider;
    private final CriticalStrikeParticles.Motion motion;
    private boolean animated = false;
    public boolean glows = true;
    public boolean translucent = true;
    @Nullable
    class_1297 followEntity;
    private float growPerTickDelta = 0.0f;
    private float fadePerTickDelta = 0.0f;
    private float overlayScale = 0.8f;
    private float lastRendered = 0.0f;
    private boolean geometryForOverlay = false;

    CriticalStrikeParticle(class_638 world, class_4002 spriteProvider, CriticalStrikeParticles.Motion motion, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, 0.5 - RANDOM.method_43058(), velocityY, 0.5 - RANDOM.method_43058());
        this.spriteProvider = spriteProvider;
        this.motion = motion;
        switch (motion) {
            case FLOAT: 
            case DECELERATE: {
                this.field_28786 = 0.96f;
                this.field_3852 = this.field_3852 * (double)0.01f + velocityX;
                this.field_3869 = this.field_3869 * (double)0.01f + velocityY;
                this.field_3850 = this.field_3850 * (double)0.01f + velocityZ;
                this.field_3874 += (double)((this.field_3840.method_43057() - this.field_3840.method_43057()) * 0.05f);
                this.field_3854 += (double)((this.field_3840.method_43057() - this.field_3840.method_43057()) * 0.05f);
                this.field_3871 += (double)((this.field_3840.method_43057() - this.field_3840.method_43057()) * 0.05f);
                if (motion == CriticalStrikeParticles.Motion.DECELERATE) {
                    this.field_28786 *= 0.8f;
                }
                this.field_3847 = (int)(8.0 / (Math.random() * 0.8 + 0.2));
                break;
            }
            case ASCEND: {
                this.field_28786 = 0.96f;
                this.field_3844 = -0.1f;
                this.field_28787 = true;
                this.field_3869 *= 0.2;
                if (velocityX == 0.0 && velocityZ == 0.0) {
                    this.field_3852 *= (double)0.1f;
                    this.field_3850 *= (double)0.1f;
                }
                this.field_3847 = (int)(8.0 / (Math.random() * 0.8 + 0.2));
                break;
            }
            case BURST: {
                this.field_28786 = 0.7f;
                this.field_3844 = 0.5f;
                this.field_3852 *= (double)0.1f;
                this.field_3869 *= (double)0.1f;
                this.field_3850 *= (double)0.1f;
                this.field_3852 += velocityX * 0.4;
                this.field_3869 += velocityY * 0.4;
                this.field_3850 += velocityZ * 0.4;
                this.field_3847 = Math.max((int)(6.0 / (Math.random() * 0.8 + 0.6)), 1);
            }
        }
        this.method_18142(spriteProvider);
        this.field_3862 = false;
    }

    public class_3999 method_18122() {
        if (this.glows) {
            if (this.translucent) {
                return class_3999.field_17829;
            }
            return class_3999.field_17830;
        }
        if (this.translucent) {
            return class_3999.field_17829;
        }
        return class_3999.field_17828;
    }

    public int method_3068(float tint) {
        if (this.glows) {
            return 255;
        }
        return super.method_3068(tint);
    }

    public void method_3069(double dx, double dy, double dz) {
        if (this.followEntity != null && !this.followEntity.method_31481()) {
            dx += this.followEntity.method_23317() - this.followEntity.field_6014;
            dy += this.followEntity.method_23318() - this.followEntity.field_6036;
            dz += this.followEntity.method_23321() - this.followEntity.field_5969;
        }
        super.method_3069(dx, dy, dz);
    }

    public void method_3070() {
        super.method_3070();
        if (this.animated) {
            this.method_18142(this.spriteProvider);
        }
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        float currentAge = (float)this.field_3866 + tickDelta;
        float elapsed = currentAge - this.lastRendered;
        this.field_17867 += this.growPerTickDelta * elapsed;
        this.field_3841 -= this.fadePerTickDelta * elapsed;
        if (this.field_3841 < 0.0f) {
            this.field_3841 = 0.0f;
        }
        super.method_3074(vertexConsumer, camera, tickDelta);
        float red = this.field_3861;
        float green = this.field_3842;
        float blue = this.field_3859;
        float scale = this.field_17867;
        this.field_3861 = 1.0f;
        this.field_3842 = 1.0f;
        this.field_3859 = 1.0f;
        this.field_17867 *= this.overlayScale;
        this.geometryForOverlay = true;
        super.method_3074(vertexConsumer, camera, tickDelta);
        this.geometryForOverlay = false;
        this.field_3861 = red;
        this.field_3842 = green;
        this.field_3859 = blue;
        this.field_17867 = scale;
        this.lastRendered = currentAge;
    }

    protected void method_60373(class_4588 vertexConsumer, class_4184 camera, Quaternionf quaternionf, float f) {
        class_243 vec3d = camera.method_19326();
        class_243 overlayOffset = new class_243(0.0, 0.0, 0.0);
        if (this.geometryForOverlay) {
            class_243 cameraLook = class_243.method_1030((float)0.0f, (float)camera.method_19330());
            overlayOffset = cameraLook.method_1029().method_1021(0.01);
        }
        float g = (float)(class_3532.method_16436((double)f, (double)this.field_3858, (double)this.field_3874) - vec3d.method_10216() - overlayOffset.method_10216());
        float h = (float)(class_3532.method_16436((double)f, (double)this.field_3838, (double)this.field_3854) - vec3d.method_10214());
        float i = (float)(class_3532.method_16436((double)f, (double)this.field_3856, (double)this.field_3871) - vec3d.method_10215() - overlayOffset.method_10215());
        this.method_60374(vertexConsumer, quaternionf, g, h, i, f);
    }

    @Environment(value=EnvType.CLIENT)
    public static class MagicVariant
    implements class_707<TemplateParticleType> {
        private final class_4002 spriteProvider;
        private final CriticalStrikeParticles.Behaviour particleBehaviour;

        public MagicVariant(class_4002 spriteProvider, CriticalStrikeParticles.Behaviour particleBehaviour) {
            this.spriteProvider = spriteProvider;
            this.particleBehaviour = particleBehaviour;
        }

        public class_703 createParticle(TemplateParticleType particleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            CriticalStrikeParticle particle = new CriticalStrikeParticle(clientWorld, this.spriteProvider, this.particleBehaviour.motion(), d, e, f, g, h, i);
            particle.glows = true;
            particle.translucent = this.particleBehaviour.fadePerTickDelta() > 0.0f;
            particle.field_3861 = 1.0f;
            particle.field_3842 = 1.0f;
            particle.field_3859 = 1.0f;
            particle.field_3841 = 0.75f;
            particle.animated = this.particleBehaviour.animated();
            particle.field_17867 *= this.particleBehaviour.scale();
            particle.field_3847 = this.particleBehaviour.maxAge();
            particle.growPerTickDelta = this.particleBehaviour.growPerTickDelta();
            particle.fadePerTickDelta = this.particleBehaviour.fadePerTickDelta();
            particle.overlayScale = this.particleBehaviour.overlayScale();
            TemplateParticleType.apply(particleType, (class_703)particle);
            TemplateParticleEffect.Appearance appearance = particleType.getAppearance();
            if (appearance != null) {
                Color color = appearance.color;
                if (color != null) {
                    particle.field_3841 *= appearance.color.alpha();
                }
                particle.field_17867 *= appearance.scale;
                particle.followEntity = appearance.entityFollowed;
            }
            float j = clientWorld.field_9229.method_43057() * 0.4f + 0.6f;
            particle.method_3084(particle.field_3861 * j, particle.field_3842 * j, particle.field_3859 * j);
            return particle;
        }
    }
}

