/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bagofholding.capability;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import fuzs.bagofholding.BagOfHolding;
import fuzs.bagofholding.config.ServerConfig;
import fuzs.bagofholding.init.ModRegistry;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.container.v1.ContainerSerializationHelper;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class BagPerseveranceCapability
extends CapabilityComponent<class_1657> {
    private static final String TAG_AMOUNT = BagOfHolding.id("amount").toString();
    private static final String TAG_ITEMS = BagOfHolding.id("items").toString();
    public static final Codec<BagPerseveranceCapability> CODEC = class_1799.field_24671.listOf().xmap(BagPerseveranceCapability::new, capability -> capability.items);
    private List<class_1799> items;

    private BagPerseveranceCapability(List<class_1799> items) {
        this.items = items;
    }

    public BagPerseveranceCapability() {
        this((List<class_1799>)ImmutableList.of());
    }

    public void saveOnDeath() {
        if (!((class_1657)this.getHolder()).method_37908().method_8450().method_8355(class_1928.field_19389)) {
            class_1661 inventory = ((class_1657)this.getHolder()).method_31548();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 itemStack = inventory.method_5438(i);
                class_6880 enchantment = LookupHelper.lookup((class_1297)((class_1297)this.getHolder()), (class_5321)class_7924.field_41265, ModRegistry.PRESERVATION_ENCHANTMENT);
                if (itemStack.method_7960() || class_1890.method_8225((class_6880)enchantment, (class_1799)itemStack) <= 0) continue;
                inventory.method_5441(i);
                if (!((class_1657)this.getHolder()).method_31549().field_7477 && ((class_1657)this.getHolder()).method_59922().method_43058() < ((ServerConfig)BagOfHolding.CONFIG.get(ServerConfig.class)).preservationLevelLossChance) {
                    class_1890.method_57531((class_1799)itemStack, enchantments -> enchantments.method_57547(enchantment, enchantments.method_57546(enchantment) - 1));
                }
                builder.add((Object)itemStack);
            }
            this.items = builder.build();
            if (!this.items.isEmpty()) {
                this.setChanged();
            }
        }
    }

    public void restoreAfterRespawn(class_1657 newPlayer) {
        if (!this.items.isEmpty()) {
            this.giveItemsToPlayer(this.items, newPlayer);
            this.items = ImmutableList.of();
            this.setChanged();
        }
    }

    private void giveItemsToPlayer(List<class_1799> items, class_1657 player) {
        for (class_1799 itemstack : items) {
            class_1542 itemEntity;
            boolean flag = player.method_31548().method_7394(itemstack);
            if (flag && itemstack.method_7960()) {
                itemstack.method_7939(1);
                itemEntity = player.method_7328(itemstack, false);
                if (itemEntity != null) {
                    itemEntity.method_6987();
                }
                player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((player.method_59922().method_43057() - player.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
                player.field_7512.method_7623();
                continue;
            }
            itemEntity = player.method_7328(itemstack, false);
            if (itemEntity == null) continue;
            itemEntity.method_6975();
            itemEntity.method_48349(player.method_5667());
        }
    }

    public void write(class_2487 tag, class_7225.class_7874 registries) {
        tag.method_10567(TAG_AMOUNT, (byte)this.items.size());
        ContainerSerializationHelper.saveAllItems((String)TAG_ITEMS, (class_2487)tag, (int)this.items.size(), this.items::get, (boolean)false, (class_7225.class_7874)registries);
    }

    public void read(class_2487 tag, class_7225.class_7874 registries) {
        byte amount = tag.method_10571(TAG_AMOUNT);
        if (amount != 0) {
            ImmutableList.Builder builder = ImmutableList.builder();
            ContainerSerializationHelper.loadAllItems((String)TAG_ITEMS, (class_2487)tag, (int)amount, (element, index) -> builder.add(element), (class_7225.class_7874)registries);
            this.items = builder.build();
        }
    }
}

