/*
 * Decompiled with CFR 0.152.
 */
package qu.noshielddelay.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Path;
import java.util.Arrays;
import net.fabricmc.loader.api.FabricLoader;
import qu.noshielddelay.NoShieldDelay;

public class ModConfig {
    public static final boolean ENABLED;
    public static final int DELAY;

    public static void init() {
    }

    private static void checkConfig(CommentedFileConfig config) {
        ConfigSpec spec = new ConfigSpec();
        spec.defineInList("Enabled", (Object)true, Arrays.asList(true, false));
        spec.defineInRange("RaiseTime", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(5));
        if (!spec.isCorrect((Config)config)) {
            NoShieldDelay.LOGGER.warn("One or more config settings were incorrect, setting to default value(s)");
            config.setComment("Enabled", "This is a Fabric recreation of Revvilo's Responsive Shield's mod. Their mod is exclusively for Forge and I wanted a Fabric one for myself, so here you go.\nMinecraft by default has a hard-coded 5 tick delay between right-clicking with the shield and being able to block.\nSetting RaiseTime to 0 makes shields capable of blocking instantly. Setting it to 5 would be equivalent to vanilla.");
            ConfigSpec.CorrectionListener listener = (action, path, incorrectValue, correctedValue) -> {
                String pathString = String.join((CharSequence)",", path);
                NoShieldDelay.LOGGER.info("Corrected {}: was {}, is now {}", new Object[]{pathString, incorrectValue, correctedValue});
            };
            spec.correct((Config)config, listener);
            config.save();
        }
    }

    static {
        NoShieldDelay.LOGGER.info("Reading config file for no-shield-delay");
        CommentedFileConfig config = CommentedFileConfig.of((Path)FabricLoader.getInstance().getConfigDir().resolve("no-shield-delay.toml"));
        config.load();
        ModConfig.checkConfig(config);
        ENABLED = (Boolean)config.get("Enabled");
        DELAY = (Integer)config.get("RaiseTime");
        config.close();
        NoShieldDelay.LOGGER.info("Enabled: {}, Raise Time: {}", (Object)ENABLED, (Object)DELAY);
    }
}

