/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power;

import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellPowerTags;
import net.spell_power.api.SpellResistance;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.config.AttributesConfig;
import net.spell_power.internals.AttributeUtil;
import net.tiny_config.ConfigManager;

public class SpellPowerMod {
    public static final String ID = "spell_power";
    public static final ConfigManager<AttributesConfig> attributesConfig = new ConfigManager("attributes", (Object)AttributesConfig.defaults()).builder().setDirectory("spell_power").sanitize(true).validate(AttributesConfig::isValid).build();
    private static boolean potionsRegistered = false;
    @Deprecated(forRemoval=true)
    public static AttributesConfig.AttributeScope attributeScopeOverride = null;

    public static void init() {
        AttributesConfig config = (AttributesConfig)attributesConfig.safeValue();
        if (config.migrate_attributes_base) {
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
                class_3222 player = handler.method_32311();
                SpellPowerMod.migrateAttributes(player);
            });
        }
    }

    public static void registerAttributes() {
        for (Map.Entry<String, SpellPowerMechanics.Entry> entry : SpellPowerMechanics.all.entrySet()) {
            entry.getValue().registerAttribute();
        }
        for (SpellResistance.Attributes.Entry resistance : SpellResistance.Attributes.all) {
            resistance.registerAttribute();
        }
        for (SpellSchool school : SpellSchools.all()) {
            school.registerAttribute();
        }
        EnchantmentEvents.ALLOW_ENCHANTING.register((enchantment, target, enchantingContext) -> {
            List enchantmentAttributes;
            if (((AttributesConfig)SpellPowerMod.attributesConfig.value).enchantments_require_matching_attribute && enchantment.method_40220(SpellPowerTags.Enchantments.REQUIRES_MATCHING_ATTRIBUTE) && (enchantmentAttributes = (List)((class_1887)enchantment.comp_349()).comp_2689().method_57829(class_9701.field_51668)) != null && !enchantmentAttributes.isEmpty()) {
                boolean intersect;
                class_9285 itemAttributes = (class_9285)target.method_57353().method_57829(class_9334.field_49636);
                if (itemAttributes == null) {
                    return TriState.FALSE;
                }
                if (itemAttributes.comp_2393().isEmpty()) {
                    itemAttributes = target.method_7909().method_7844();
                }
                if (!(intersect = AttributeUtil.attributesIntersect(enchantmentAttributes, itemAttributes))) {
                    return TriState.FALSE;
                }
            }
            return TriState.DEFAULT;
        });
    }

    public static void registerStatusEffects() {
        class_2960 modifierId = class_2960.method_60655((String)ID, (String)"potion_effect");
        float bonus_per_stack = 0.1f;
        for (SpellSchool school : SpellSchools.all()) {
            class_2960 id = school.id;
            if (school.ownedBoostEffect == null || school.attributeEntry == null) continue;
            school.ownedBoostEffect.method_5566(school.attributeEntry, modifierId, (double)bonus_per_stack, class_1322.class_1323.field_6330);
            class_2378.method_10226((class_2378)class_7923.field_41174, (String)id.toString(), (Object)school.ownedBoostEffect);
        }
        AttributesConfig safeConfig = (AttributesConfig)attributesConfig.safeValue();
        for (Map.Entry<String, SpellPowerMechanics.Entry> entry : SpellPowerMechanics.all.entrySet()) {
            SpellPowerMechanics.Entry secondary = entry.getValue();
            class_2960 id = secondary.id;
            AttributesConfig.EffectConfig config = safeConfig.secondary_effects.get(secondary.name);
            if (config != null) {
                bonus_per_stack = config.bonus_per_stack;
            }
            secondary.boostEffect.method_5566(secondary.attributeEntry, modifierId, (double)bonus_per_stack, class_1322.class_1323.field_6330);
            class_2378.method_10226((class_2378)class_7923.field_41174, (String)id.toString(), (Object)secondary.boostEffect);
        }
    }

    public static void registerPotionsInternal() {
        if (((AttributesConfig)SpellPowerMod.attributesConfig.safeValue()).register_potions) {
            SpellPowerMod.registerPotions();
        }
    }

    public static void registerPotions() {
        if (potionsRegistered) {
            return;
        }
        potionsRegistered = true;
        for (SpellSchool spellSchool : SpellSchools.all()) {
            if (spellSchool.archetype != SpellSchool.Archetype.MAGIC || spellSchool.id.method_12832().contains("generic")) continue;
            spellSchool.registerPotion();
        }
        for (Map.Entry entry : SpellPowerMechanics.all.entrySet()) {
            SpellPowerMechanics.Entry mechanic = (SpellPowerMechanics.Entry)entry.getValue();
            class_6880 entry2 = class_7923.field_41174.method_47983((Object)mechanic.boostEffect);
            if (entry2 == null) continue;
            class_1842 potion = new class_1842(new class_1293[]{new class_1293(entry2, 3600)});
            class_2378.method_10230((class_2378)class_7923.field_41179, (class_2960)SpellPowerMod.potionIdFrom(mechanic.id), (Object)potion);
        }
    }

    public static class_2960 potionIdFrom(class_2960 id) {
        return class_2960.method_60655((String)id.method_12836(), (String)(id.method_12836() + "." + id.method_12832()));
    }

    @Deprecated(forRemoval=true)
    public static AttributesConfig.AttributeScope attributeScope() {
        return attributeScopeOverride;
    }

    public static void migrateAttributes(class_3222 player) {
        List<class_6880> attributes = SpellSchools.all().stream().filter(school -> school.isMagicArchetype() && school.ownsAttribute()).map(school -> school.attributeEntry).toList();
        for (class_6880 attribute : attributes) {
            class_1324 instance;
            if (attribute == null || (instance = player.method_5996(attribute)) == null) continue;
            double defaultValue = ((class_1320)attribute.comp_349()).method_6169();
            if (instance.method_6201() == defaultValue) continue;
            instance.method_6192(defaultValue);
        }
    }
}

