/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.configuration;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.network.FrameworkResponse;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

public record S2CConfigData(class_2960 key, byte[] data) {
    public static final class_9139<class_2540, S2CConfigData> STREAM_CODEC = class_9139.method_56437((buf, data) -> {
        buf.method_10812(data.key);
        buf.method_52983(data.data);
    }, buf -> {
        class_2960 key = buf.method_10810();
        byte[] data = new byte[buf.readableBytes()];
        buf.method_52979(data);
        return new S2CConfigData(key, data);
    });

    public static FrameworkResponse handle(S2CConfigData message, Consumer<Runnable> executor) {
        Constants.LOG.debug("Received config data from server");
        boolean[] failed = new boolean[1];
        CountDownLatch block = new CountDownLatch(1);
        executor.accept(() -> {
            try {
                if (!FrameworkConfigManager.getInstance().processConfigData(message)) {
                    failed[0] = true;
                }
            }
            catch (Exception e) {
                failed[0] = true;
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (failed[0]) {
            return FrameworkResponse.error(class_2561.method_43471((String)"configured.gui.handshake_process_failed").getString());
        }
        return FrameworkResponse.SUCCESS;
    }
}

