/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Beta
public final class ItemSprites {
    private final ImmutableMap<Integer, class_2960> map;

    private ItemSprites(@Nullable class_2960 enabled, @Nullable class_2960 disabled, @Nullable class_2960 enabledHovered, @Nullable class_2960 disabledHovered, @Nullable class_2960 enabledSelected, @Nullable class_2960 disabledSelected, @Nullable class_2960 enabledHoveredSelected, @Nullable class_2960 disabledHoveredSelected) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (disabled != null) {
            builder.put((Object)this.calculateKey(false, false, false), (Object)disabled);
        }
        if (enabled != null) {
            builder.put((Object)this.calculateKey(true, false, false), (Object)enabled);
        }
        if (disabledHovered != null) {
            builder.put((Object)this.calculateKey(false, true, false), (Object)disabledHovered);
        }
        if (enabledHovered != null) {
            builder.put((Object)this.calculateKey(true, true, false), (Object)enabledHovered);
        }
        if (disabledSelected != null) {
            builder.put((Object)this.calculateKey(false, false, true), (Object)disabledSelected);
        }
        if (enabledSelected != null) {
            builder.put((Object)this.calculateKey(true, false, true), (Object)enabledSelected);
        }
        if (disabledHoveredSelected != null) {
            builder.put((Object)this.calculateKey(false, true, true), (Object)disabledHoveredSelected);
        }
        if (enabledHoveredSelected != null) {
            builder.put((Object)this.calculateKey(true, true, true), (Object)enabledHoveredSelected);
        }
        this.map = builder.build();
    }

    private int calculateKey(boolean enabled, boolean hovered, boolean selected) {
        int key = 0;
        if (enabled) {
            key |= 1;
        }
        if (hovered) {
            key |= 2;
        }
        if (selected) {
            key |= 4;
        }
        return key;
    }

    public class_2960 getSprite(boolean enabled, boolean hovered, boolean selected) {
        return (class_2960)this.map.get((Object)this.calculateKey(enabled, hovered, selected));
    }

    public static ItemSprites of(@Nullable class_2960 all) {
        return new ItemSprites(all, all, all, all, all, all, all, all);
    }

    public static ItemSprites of(@Nullable class_2960 enabled, @Nullable class_2960 disabled, @Nullable class_2960 enabledSelected) {
        return new ItemSprites(enabled, disabled, enabled, disabled, enabledSelected, disabled, enabledSelected, disabled);
    }

    public static ItemSprites of(@Nullable class_2960 enabled, @Nullable class_2960 disabled, @Nullable class_2960 enabledHovered, @Nullable class_2960 disabledHovered, @Nullable class_2960 enabledSelected, @Nullable class_2960 disabledSelected, @Nullable class_2960 enabledHoveredSelected, @Nullable class_2960 disabledHoveredSelected) {
        return new ItemSprites(enabled, disabled, enabledHovered, disabledHovered, enabledSelected, disabledSelected, enabledHoveredSelected, disabledHoveredSelected);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private class_2960 enabled;
        @Nullable
        private class_2960 disabled;
        @Nullable
        private class_2960 enabledHovered;
        @Nullable
        private class_2960 disabledHovered;
        @Nullable
        private class_2960 enabledSelected;
        @Nullable
        private class_2960 disabledSelected;
        @Nullable
        private class_2960 enabledHoveredSelected;
        @Nullable
        private class_2960 disabledHoveredSelected;

        public ItemSprites build() {
            return new ItemSprites(this.enabled, this.disabled, this.enabledHovered, this.disabledHovered, this.enabledSelected, this.disabledSelected, this.enabledHoveredSelected, this.disabledHoveredSelected);
        }

        public Builder setEnabled(@Nullable class_2960 enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setDisabled(@Nullable class_2960 disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder setEnabledHovered(@Nullable class_2960 enabledHovered) {
            this.enabledHovered = enabledHovered;
            return this;
        }

        public Builder setDisabledHovered(@Nullable class_2960 disabledHovered) {
            this.disabledHovered = disabledHovered;
            return this;
        }

        public Builder setEnabledSelected(@Nullable class_2960 enabledSelected) {
            this.enabledSelected = enabledSelected;
            return this;
        }

        public Builder setDisabledSelected(@Nullable class_2960 disabledSelected) {
            this.disabledSelected = disabledSelected;
            return this;
        }

        public Builder setEnabledHoveredSelected(@Nullable class_2960 enabledHoveredSelected) {
            this.enabledHoveredSelected = enabledHoveredSelected;
            return this;
        }

        public Builder setDisabledHoveredSelected(@Nullable class_2960 disabledHoveredSelected) {
            this.disabledHoveredSelected = disabledHoveredSelected;
            return this;
        }
    }
}

