/*
 * Decompiled with CFR 0.152.
 */
package net.brazier_modding.gdarp.pack_finders;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.brazier_modding.gdarp.Constants;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7670;
import net.minecraft.class_9224;
import net.minecraft.class_9225;

public class GlobalPackFinder
implements class_3285 {
    private static final Predicate<Path> IS_VALID_RESOURCE_PACK = pack -> {
        if (Files.isSymbolicLink(pack)) {
            return false;
        }
        boolean flag = true;
        if (Files.isRegularFile(pack, new LinkOption[0]) && pack.toString().endsWith(".zip")) {
            try (FileSystem fs = FileSystems.newFileSystem(pack);){
                flag &= Files.isDirectory(fs.getPath("assets/", new String[0]), new LinkOption[0]);
                flag &= Files.isRegularFile(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            flag &= Files.isDirectory(pack.resolve("assets/"), new LinkOption[0]);
            flag &= Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);
        }
        return flag;
    };
    private static final Predicate<Path> IS_VALID_DATA_PACK = pack -> {
        if (Files.isSymbolicLink(pack)) {
            return false;
        }
        boolean flag = true;
        if (Files.isRegularFile(pack, new LinkOption[0]) && pack.toString().endsWith(".zip")) {
            try (FileSystem fs = FileSystems.newFileSystem(pack);){
                flag &= Files.isDirectory(fs.getPath("data/", new String[0]), new LinkOption[0]);
                flag &= Files.isRegularFile(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            flag &= Files.isDirectory(pack.resolve("data"), new LinkOption[0]);
            flag &= Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);
        }
        return flag;
    };
    private static class_5352 GLOBAL = class_5352.method_45281(name -> name.method_27661().method_27693(" (Global)").method_27692(class_124.field_1075), (boolean)true);
    private static class_5352 GLOBAL_OPT = class_5352.method_45281(name -> name.method_27661().method_27693(" (Global Optional)").method_27692(class_124.field_1062), (boolean)false);
    public final class_3264 packType;
    private final boolean forcedPacks;
    private final ImmutableList<Path> packLocations;

    public GlobalPackFinder(class_3264 packType, boolean required, List<Path> packLocations) {
        this.packType = packType;
        this.forcedPacks = required;
        this.packLocations = ImmutableList.builder().addAll(packLocations).build();
    }

    public void method_14453(Consumer<class_3288> packRegistrar) {
        try {
            this.discoverResourcePacks(path -> {
                class_3288.class_7680 resourceSupplier = null;
                resourceSupplier = Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip") ? this.createFilePack((Path)path) : this.createFolderPack((Path)path);
                if (resourceSupplier == null) {
                    return;
                }
                class_3288 pack = class_3288.method_45275((class_9224)new class_9224(path.getFileName().toString(), (class_2561)class_2561.method_43470((String)path.getFileName().toString()), this.forcedPacks ? GLOBAL : GLOBAL_OPT, Optional.empty()), (class_3288.class_7680)resourceSupplier, (class_3264)this.packType, (class_9225)new class_9225(this.forcedPacks, class_3288.class_3289.field_14280, true));
                if (pack != null) {
                    packRegistrar.accept(pack);
                }
            });
        }
        catch (IOException e) {
            Constants.LOG.error((Object)e);
        }
    }

    private class_3288.class_7680 createFilePack(Path path) {
        Object supplier = null;
        FileSystem fs = path.getFileSystem();
        if (this.packType == class_3264.field_14188 && !IS_VALID_RESOURCE_PACK.test(path)) {
            return null;
        }
        if (this.packType == class_3264.field_14190 && !IS_VALID_DATA_PACK.test(path)) {
            return null;
        }
        if (fs == FileSystems.getDefault() || fs instanceof class_7670) {
            return new class_3258.class_8615(path);
        }
        return null;
    }

    private class_3288.class_7680 createFolderPack(Path path) {
        if (this.packType == class_3264.field_14188 && !IS_VALID_RESOURCE_PACK.test(path)) {
            return null;
        }
        if (this.packType == class_3264.field_14190 && !IS_VALID_DATA_PACK.test(path)) {
            return null;
        }
        return new class_3259.class_8619(path);
    }

    private void discoverResourcePacks(Consumer<Path> packCallback) throws IOException {
        ArrayList<Path> packs = new ArrayList<Path>();
        ArrayList<Path> directoryPacks = new ArrayList<Path>();
        for (Path path : this.packLocations) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                if (Files.isRegularFile(path.resolve("pack.mcmeta"), new LinkOption[0])) {
                    this.addNoDuplicatePaths(packs, directoryPacks, path, false);
                    continue;
                }
                if (Files.notExists(path, new LinkOption[0])) {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                try (Stream<Path> fileStream = Files.list(path);){
                    fileStream.forEach(filePath -> {
                        if (Files.isRegularFile(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0]) && Files.isRegularFile(filePath.resolve("pack.mcmeta"), new LinkOption[0])) {
                            this.addNoDuplicatePaths((List<Path>)packs, (List<Path>)directoryPacks, (Path)filePath, true);
                        }
                    });
                }
                catch (IOException e) {
                    Constants.LOG.error((Object)e);
                }
                continue;
            }
            this.addNoDuplicatePaths(packs, directoryPacks, path, false);
        }
        LinkedList<Path> noDuplicatePacks = new LinkedList<Path>();
        block8: for (Path pack : packs) {
            for (Path pack2 : noDuplicatePacks) {
                if (!Files.isSameFile(pack, pack2)) continue;
                continue block8;
            }
            noDuplicatePacks.addFirst(pack);
        }
        for (Path pack : noDuplicatePacks) {
            packCallback.accept(pack);
        }
    }

    private void addNoDuplicatePaths(List<Path> packs, List<Path> directoryPacks, Path path, boolean isLowPriority) {
        try {
            for (int i = 0; i < packs.size(); ++i) {
                Path firstPath = packs.get(i);
                if (!Files.isSameFile(firstPath, path)) continue;
                for (int j = 0; j < directoryPacks.size(); ++j) {
                    Path dirPath = directoryPacks.get(j);
                    if (!Files.isSameFile(dirPath, path)) continue;
                    Constants.LOG.info("Pack {} with lower priority, overrides Pack {} added by a folder entry.", (Object)path, (Object)firstPath);
                    packs.set(i, path);
                    if (isLowPriority) {
                        directoryPacks.set(j, path);
                    } else {
                        directoryPacks.remove(j);
                    }
                    return;
                }
                Constants.LOG.info("Pack with the path {} has already been loaded with higher priority, skipping it.", (Object)path);
                return;
            }
            packs.add(path);
            if (isLowPriority) {
                directoryPacks.add(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

