/*
 * Decompiled with CFR 0.152.
 */
package net.brazier_modding.gdarp.pack_dependencies;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackDependency {
    private static final Pattern regexPattern = Pattern.compile("^(?:(.*?):)?(.*?)(?:\\@(.*))?$", 2);
    private final DependencyType type;
    private final String namespace;
    private final String versionRange;

    public static PackDependency parse(String dependencyString) {
        Matcher matcher = regexPattern.matcher(dependencyString);
        if (!matcher.find()) {
            return null;
        }
        String type = matcher.group(1);
        String namespace = matcher.group(2);
        String versionRange = matcher.group(3);
        return new PackDependency(DependencyType.getType(type), namespace, versionRange);
    }

    public PackDependency(DependencyType type, String namespace, String versionRange) {
        this.type = type;
        this.namespace = namespace;
        this.versionRange = versionRange;
    }

    public DependencyType type() {
        return this.type;
    }

    public String namespace() {
        return this.namespace;
    }

    public String versionRange() {
        return this.versionRange;
    }

    public static enum DependencyType {
        MOD("m"),
        DATAPACK("d"),
        RESOURCEPACK("r"),
        ANY(null);

        private final String identifier;

        private DependencyType(String identifier) {
            this.identifier = identifier;
        }

        public String identifier() {
            return this.identifier;
        }

        public static DependencyType getType(String typeIdentifier) {
            if (typeIdentifier == null) {
                return ANY;
            }
            for (DependencyType type : DependencyType.values()) {
                if (!type.identifier.equals(typeIdentifier)) continue;
                return type;
            }
            return ANY;
        }
    }
}

