/*
 * Decompiled with CFR 0.152.
 */
package net.brazier_modding.gdarp.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.brazier_modding.gdarp.CommonClass;
import net.brazier_modding.gdarp.Constants;

public class PackConfig {
    private static boolean hasLoadedConfig = false;
    public static final PackConfig INSTANCE = new PackConfig();
    private static final String CONFIG_VERSION_KEY = "config_version";
    private static final String SYSTEM_GLOBAL_KEY = "enable_system_global_packs";
    private static final String LOG_PACK_IDS_KEY = "log_pack_ids";
    private static final String R_DATA_KEY = "datapacks.required";
    private static final String O_DATA_KEY = "datapacks.optional";
    private static final String B_DATA_KEY = "datapacks.enable_builtin";
    private static final String R_ASSETS_KEY = "resourcepacks.required";
    private static final String B_ASSETS_KEY = "resourcepacks.enable_builtin";
    private final Path configFile = CommonClass.getGameDir().resolve("config/global_packs.toml");
    private final ConfigSpec spec = new ConfigSpec();
    private int configVersion;
    private boolean enableSystemGlobal;
    private boolean logPackIDs;
    private List<String> rData;
    private List<String> oData;
    private List<String> bData;
    private List<String> rAssets;
    private List<String> oAssets;
    private List<String> bAssets;
    private static Path SYSTEM_GLOBAL_PATH;

    public PackConfig() {
        this.spec.defineInRange(CONFIG_VERSION_KEY, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2));
        this.spec.define(SYSTEM_GLOBAL_KEY, (Object)false);
        this.spec.define(LOG_PACK_IDS_KEY, (Object)false);
        this.spec.defineList(R_DATA_KEY, List.of("datapacks/", "resourcepacks/", "global_packs/required_data/"), o -> true);
        this.spec.defineList(O_DATA_KEY, List.of("global_packs/optional_data/"), o -> true);
        this.spec.defineList(B_DATA_KEY, List.of(), o -> true);
        this.spec.defineList(R_ASSETS_KEY, List.of("global_packs/required_resources/"), o -> true);
        this.spec.defineList(B_ASSETS_KEY, List.of(), o -> true);
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.configFile).preserveInsertionOrder().onFileNotFound(FileNotFoundAction.CREATE_EMPTY).defaultData(PackConfig.class.getClassLoader().getResource("default_config.toml")).sync().build();){
            this.attemptUpdateLegacyOrCopyDefaultConfig();
            config.load();
            this.configVersion = config.getOptional(CONFIG_VERSION_KEY).orElse(1);
            boolean correct = this.spec.isCorrect((Config)config);
            if (correct) {
                this.spec.correct((Config)config, (action, path, incorrectValue, correctedValue) -> {
                    String pathString = String.join((CharSequence)",", path);
                    Constants.LOG.info("Corrected global Packs Config: '{}': was '{}, is now '{}'", (Object)pathString, incorrectValue, correctedValue);
                });
            }
            this.enableSystemGlobal = config.getOptional(SYSTEM_GLOBAL_KEY).orElseGet(() -> false);
            this.logPackIDs = config.getOptional(LOG_PACK_IDS_KEY).orElseGet(() -> false);
            this.rData = config.getOptional(R_DATA_KEY).orElseGet(ArrayList::new);
            this.oData = config.getOptional(O_DATA_KEY).orElseGet(ArrayList::new);
            this.bData = config.getOptional(B_DATA_KEY).orElseGet(ArrayList::new);
            this.rAssets = config.getOptional(R_ASSETS_KEY).orElseGet(ArrayList::new);
            this.bAssets = config.getOptional(B_ASSETS_KEY).orElseGet(ArrayList::new);
            this.oAssets = new ArrayList<String>();
            if (this.configVersion < 2) {
                this.rData.add("datapacks/");
                config.set(R_DATA_KEY, (Object)this.rData.reversed());
                config.set(O_DATA_KEY, (Object)this.oData.reversed());
                config.set(R_ASSETS_KEY, (Object)this.rAssets.reversed());
                config.set(CONFIG_VERSION_KEY, (Object)2);
            }
            if (this.configVersion < 3) {
                config.set(CONFIG_VERSION_KEY, (Object)3);
                config.set(LOG_PACK_IDS_KEY, (Object)false);
                config.set(B_ASSETS_KEY, List.of());
            }
            if (this.configVersion < 4) {
                config.set(CONFIG_VERSION_KEY, (Object)4);
                config.set(B_DATA_KEY, List.of());
                config.save();
            }
            if (this.enableSystemGlobal) {
                String userHome = System.getProperty("user.home");
                SYSTEM_GLOBAL_PATH = Path.of(userHome, ".minecraft_global_packs");
                this.rData.add(SYSTEM_GLOBAL_PATH.resolve("required_datapacks").toFile().getPath());
                this.oData.add(SYSTEM_GLOBAL_PATH.resolve("optional_datapacks").toFile().getPath());
                this.rAssets.add(SYSTEM_GLOBAL_PATH.resolve("required_resourcepacks").toFile().getPath());
                this.oAssets.add(SYSTEM_GLOBAL_PATH.resolve("optional_resourcepacks").toFile().getPath());
            }
            this.createFolders();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void attemptUpdateLegacyOrCopyDefaultConfig() throws IOException {
        Path legacyConfig = CommonClass.getGameDir().resolve("config/global_data_and_resourcepacks.toml");
        Path defaultConfig = CommonClass.getGameDir().resolve("defaultconfigs/global_packs.toml");
        if (Files.notExists(this.configFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
        }
        if (Files.exists(this.configFile, new LinkOption[0])) {
            return;
        }
        if (Files.exists(legacyConfig, new LinkOption[0])) {
            Files.move(legacyConfig, this.configFile, new CopyOption[0]);
        } else if (Files.exists(defaultConfig, new LinkOption[0])) {
            Files.move(defaultConfig, this.configFile, new CopyOption[0]);
        }
    }

    public boolean isSystemGlobalPath(Path other) {
        return SYSTEM_GLOBAL_PATH != null && other.startsWith(SYSTEM_GLOBAL_PATH);
    }

    public void createFolders() {
        if (this.enableSystemGlobal) {
            String userHome = System.getProperty("user.home");
            try {
                Files.createDirectories(Paths.get(userHome, ".minecraft_global_packs", "1.21.1", "required_datapacks"), new FileAttribute[0]);
                Files.createDirectories(Paths.get(userHome, ".minecraft_global_packs", "1.21.1", "optional_datapacks"), new FileAttribute[0]);
                Files.createDirectories(Paths.get(userHome, ".minecraft_global_packs", "1.21.1", "required_resourcepacks"), new FileAttribute[0]);
                Files.createDirectories(Paths.get(userHome, ".minecraft_global_packs", "1.21.1", "optional_resourcepacks"), new FileAttribute[0]);
            }
            catch (IOException e) {
                Constants.LOG.error((Object)e);
            }
        }
        for (int i = 0; i < 4; ++i) {
            List<String> folders = switch (i) {
                case 0 -> this.getRequiredDatapacks();
                case 1 -> this.getOptionalDatapacks();
                case 2 -> this.getRequiredResourcePacks();
                case 3 -> this.getOptionalResourcePacks();
                default -> throw new IllegalStateException("Unexpected value: " + i);
            };
            folders.stream().map(str -> str.startsWith("/") ? str.substring(1) : str).map(x$0 -> Path.of(x$0, new String[0])).map(path -> this.isSystemGlobalPath((Path)path) ? path : CommonClass.GAME_DIR.resolve((Path)path)).forEach(path -> {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    Constants.LOG.error((Object)e);
                }
            });
        }
    }

    public boolean logPacks() {
        return this.logPackIDs;
    }

    public List<String> getRequiredDatapacks() {
        return this.rData;
    }

    public List<String> getOptionalDatapacks() {
        return this.oData;
    }

    public List<String> getRequiredResourcePacks() {
        return this.rAssets;
    }

    public List<String> getRequiredBuiltinResourcePacks() {
        return this.bAssets;
    }

    public List<String> getRequiredBuiltinDataPacks() {
        return this.bData;
    }

    public List<String> getOptionalResourcePacks() {
        return this.oAssets;
    }
}

