/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.maelstrom.general.data;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import net.barribob.maelstrom.general.data.IHistoricalData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lnet/barribob/maelstrom/general/data/HistoricalData;", "T", "Lnet/barribob/maelstrom/general/data/IHistoricalData;", "defaultValue", "", "maxHistory", "<init>", "(Ljava/lang/Object;I)V", "", "clear", "()V", "past", "get", "(I)Ljava/lang/Object;", "", "getAll", "()Ljava/util/List;", "getSize", "()I", "value", "set", "(Ljava/lang/Object;)V", "", "history", "Ljava/util/List;", "I", "getMaxHistory", "BOMD"})
public final class HistoricalData<T>
implements IHistoricalData<T> {
    private final int maxHistory;
    @NotNull
    private final List<T> history;

    public HistoricalData(T defaultValue, int maxHistory) {
        this.maxHistory = maxHistory;
        Object[] objectArray = new Object[]{defaultValue};
        this.history = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.maxHistory < 2) {
            throw new IllegalArgumentException("Max History cannot be less than 2");
        }
    }

    public /* synthetic */ HistoricalData(Object object, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        this(object, n);
    }

    public final int getMaxHistory() {
        return this.maxHistory;
    }

    @Override
    public void set(T value) {
        this.history.add(value);
        if (this.history.size() > this.maxHistory) {
            this.history.remove(0);
        }
    }

    @Override
    public T get(int past) {
        if (past < 0) {
            throw new IllegalArgumentException("Past cannot be negative");
        }
        int clampedPast = RangesKt.coerceAtLeast((int)(this.history.size() - 1 - past), (int)0);
        return this.history.get(clampedPast);
    }

    @Override
    @NotNull
    public List<T> getAll() {
        return CollectionsKt.toList((Iterable)this.history);
    }

    public final int getSize() {
        return this.history.size();
    }

    public final void clear() {
        this.history.clear();
    }
}

